/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaState;
import kafka.log.Log;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.LogDirFailureTest$Checkpoint$;
import kafka.server.LogDirFailureTest$Roll$;
import kafka.server.ReplicaFetcherThread;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.VolatileObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005uf\u0001B\u00181\u0001UBQ\u0001\u0010\u0001\u0005\u0002uBq\u0001\u0011\u0001C\u0002\u0013\u0005\u0011\t\u0003\u0004I\u0001\u0001\u0006IA\u0011\u0005\b\u0013\u0002\u0011\r\u0011\"\u0001B\u0011\u0019Q\u0005\u0001)A\u0005\u0005\"91\n\u0001b\u0001\n\u0003\t\u0005B\u0002'\u0001A\u0003%!\tC\u0004N\u0001\t\u0007I\u0011\u0002(\t\r]\u0003\u0001\u0015!\u0003P\u0011\u001dA\u0006A1A\u0005\n\u0005Ca!\u0017\u0001!\u0002\u0013\u0011\u0005b\u0002.\u0001\u0005\u0004%\t%\u0011\u0005\u00077\u0002\u0001\u000b\u0011\u0002\"\t\u000bq\u0003A\u0011I/\t\u000b)\u0004A\u0011A/\t\u000b=\u0004A\u0011A/\t\u000bE\u0004A\u0011A/\t\u000bM\u0004A\u0011A/\t\u000bU\u0004A\u0011\u0001<\t\u000f\u0005\u0015\u0005\u0001\"\u0003\u0002\b\u001e9\u0011Q\u0001\u0019\t\u0002\u0005\u001daAB\u00181\u0011\u0003\tI\u0001\u0003\u0004=-\u0011\u0005\u0011\u0011\u0003\u0004\n\u0003'1\u0002\u0013aI\u0011\u0003+9q!!!\u0017\u0011\u0003\u000b9HB\u0004\u0002rYA\t)a\u001d\t\rqRB\u0011AA;\u0011!\t\tDGA\u0001\n\u0003r\u0005\u0002CA\u001a5\u0005\u0005I\u0011A!\t\u0013\u0005U\"$!A\u0005\u0002\u0005e\u0004\"CA\"5\u0005\u0005I\u0011IA#\u0011%\t\u0019FGA\u0001\n\u0003\ti\bC\u0005\u0002`i\t\t\u0011\"\u0011\u0002b!I\u00111\r\u000e\u0002\u0002\u0013\u0005\u0013Q\r\u0005\n\u0003OR\u0012\u0011!C\u0005\u0003S:q!a!\u0017\u0011\u0003\u000byCB\u0004\u0002\u001aYA\t)a\u0007\t\rq*C\u0011AA\u0017\u0011!\t\t$JA\u0001\n\u0003r\u0005\u0002CA\u001aK\u0005\u0005I\u0011A!\t\u0013\u0005UR%!A\u0005\u0002\u0005]\u0002\"CA\"K\u0005\u0005I\u0011IA#\u0011%\t\u0019&JA\u0001\n\u0003\t)\u0006C\u0005\u0002`\u0015\n\t\u0011\"\u0011\u0002b!I\u00111M\u0013\u0002\u0002\u0013\u0005\u0013Q\r\u0005\n\u0003O*\u0013\u0011!C\u0005\u0003S\u0012\u0011\u0003T8h\t&\u0014h)Y5mkJ,G+Z:u\u0015\t\t$'\u0001\u0004tKJ4XM\u001d\u0006\u0002g\u0005)1.\u00194lC\u000e\u00011C\u0001\u00017!\t9$(D\u00019\u0015\tI$'A\u0002ba&L!a\u000f\u001d\u0003-%sG/Z4sCRLwN\u001c+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#\u0001 \u0011\u0005}\u0002Q\"\u0001\u0019\u0002\u001bA\u0014x\u000eZ;dKJ\u001cu.\u001e8u+\u0005\u0011\u0005CA\"G\u001b\u0005!%\"A#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d#%aA%oi\u0006q\u0001O]8ek\u000e,'oQ8v]R\u0004\u0013!D2p]N,X.\u001a:D_VtG/\u0001\bd_:\u001cX/\\3s\u0007>,h\u000e\u001e\u0011\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u0001\rEJ|7.\u001a:D_VtG\u000fI\u0001\u0006i>\u0004\u0018nY\u000b\u0002\u001fB\u0011\u0001+V\u0007\u0002#*\u0011!kU\u0001\u0005Y\u0006twMC\u0001U\u0003\u0011Q\u0017M^1\n\u0005Y\u000b&AB*ue&tw-\u0001\u0004u_BL7\rI\u0001\ra\u0006\u0014H/\u001b;j_:tU/\\\u0001\u000ea\u0006\u0014H/\u001b;j_:tU/\u001c\u0011\u0002\u00171|w\rR5s\u0007>,h\u000e^\u0001\rY><G)\u001b:D_VtG\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002=B\u00111iX\u0005\u0003A\u0012\u0013A!\u00168ji\"\u0012aB\u0019\t\u0003G\"l\u0011\u0001\u001a\u0006\u0003K\u001a\fQA[;oSRT\u0011aZ\u0001\u0004_J<\u0017BA5e\u0005\u0019\u0011UMZ8sK\u0006aB/Z:u\u0013>+\u0005pY3qi&|g\u000eR;sS:<Gj\\4S_2d\u0007FA\bm!\t\u0019W.\u0003\u0002oI\n!A+Z:u\u0003e\u0012'o\\6fe^KG\u000f[(mI&sG/\u001a:Ce>\\WM\u001d)s_R|7m\u001c7TQ>,H\u000e\u001a%bYR|e\u000eT8h\t&\u0014h)Y5mkJ,\u0007F\u0001\tm\u0003}!Xm\u001d;J\u001f\u0016C8-\u001a9uS>tG)\u001e:j]\u001e\u001c\u0005.Z2la>Lg\u000e\u001e\u0015\u0003#1\fA\u0007^3tiJ+\u0007\u000f\\5dC\u001a+Go\u00195feRC'/Z1e\u0003\u001a$XM\u001d'pO\u0012K'OR1jYV\u0014Xm\u00148G_2dwn^3sQ\t\u0011B.A\u0013uKN$\bK]8ek\u000e,\u0017I\u001a;fe2{w\rR5s\r\u0006LG.\u001e:f\u001f:dU-\u00193feR\u0011al\u001e\u0005\u0006qN\u0001\r!_\u0001\fM\u0006LG.\u001e:f)f\u0004X\r\u0005\u0002{19\u001110\u0006\b\u0004y\u0006\rabA?\u0002\u00025\taP\u0003\u0002\u0000i\u00051AH]8pizJ\u0011aM\u0005\u0003cI\n\u0011\u0003T8h\t&\u0014h)Y5mkJ,G+Z:u!\tydcE\u0002\u0017\u0003\u0017\u00012aQA\u0007\u0013\r\ty\u0001\u0012\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005\u001d!!\u0005'pO\u0012K'OR1jYV\u0014X\rV=qKN\u0019\u0001$a\u0003*\u0007a)#D\u0001\u0006DQ\u0016\u001c7\u000e]8j]R\u001c\u0012\"JA\u0006\u0003;\t\t#a\n\u0011\u0007\u0005}\u0001$D\u0001\u0017!\r\u0019\u00151E\u0005\u0004\u0003K!%a\u0002)s_\u0012,8\r\u001e\t\u0004\u0007\u0006%\u0012bAA\u0016\t\na1+\u001a:jC2L'0\u00192mKR\u0011\u0011q\u0006\t\u0004\u0003?)\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005e\u0012q\b\t\u0004\u0007\u0006m\u0012bAA\u001f\t\n\u0019\u0011I\\=\t\u0011\u0005\u0005\u0013&!AA\u0002\t\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA$!\u0019\tI%a\u0014\u0002:5\u0011\u00111\n\u0006\u0004\u0003\u001b\"\u0015AC2pY2,7\r^5p]&!\u0011\u0011KA&\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005]\u0013Q\f\t\u0004\u0007\u0006e\u0013bAA.\t\n9!i\\8mK\u0006t\u0007\"CA!W\u0005\u0005\t\u0019AA\u001d\u0003!A\u0017m\u001d5D_\u0012,G#\u0001\"\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012aT\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002lA\u0019\u0001+!\u001c\n\u0007\u0005=\u0014K\u0001\u0004PE*,7\r\u001e\u0002\u0005%>dGnE\u0005\u001b\u0003\u0017\ti\"!\t\u0002(Q\u0011\u0011q\u000f\t\u0004\u0003?QB\u0003BA\u001d\u0003wB\u0001\"!\u0011\u001f\u0003\u0003\u0005\rA\u0011\u000b\u0005\u0003/\ny\bC\u0005\u0002B\u0001\n\t\u00111\u0001\u0002:\u0005!!k\u001c7m\u0003)\u0019\u0005.Z2la>Lg\u000e^\u0001\u001egV\u00147o\u0019:jE\u0016\fe\u000eZ,bSR4uN]!tg&<g.\\3oiR)a,!#\u0002\u001a\"1Q\n\u0006a\u0001\u0003\u0017\u0003B!!$\u0002\u0016:!\u0011qRAI!\tiH)C\u0002\u0002\u0014\u0012\u000ba\u0001\u0015:fI\u00164\u0017b\u0001,\u0002\u0018*\u0019\u00111\u0013#\t\u000f\u0005mE\u00031\u0001\u0002\u001e\u0006A1m\u001c8tk6,'\u000f\u0005\u0005\u0002 \u00065\u0016\u0011WAY\u001b\t\t\tK\u0003\u0003\u0002\u001c\u0006\r&\u0002BAS\u0003O\u000bqa\u00197jK:$8OC\u00024\u0003SS1!a+g\u0003\u0019\t\u0007/Y2iK&!\u0011qVAQ\u00055Y\u0015MZ6b\u0007>t7/^7feB)1)a-\u00028&\u0019\u0011Q\u0017#\u0003\u000b\u0005\u0013(/Y=\u0011\u0007\r\u000bI,C\u0002\u0002<\u0012\u0013AAQ=uK\u0002")
public class LogDirFailureTest
extends IntegrationTestHarness {
    private final int producerCount;
    private final int consumerCount;
    private final int brokerCount;
    private final String topic;
    private final int partitionNum;
    private final int logDirCount;

    public int producerCount() {
        return this.producerCount;
    }

    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    private String topic() {
        return this.topic;
    }

    private int partitionNum() {
        return this.partitionNum;
    }

    @Override
    public int logDirCount() {
        return this.logDirCount;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic(), this.partitionNum(), this.brokerCount(), this.createTopic$default$4());
    }

    @Test
    public void testIOExceptionDuringLogRoll() {
        this.testProduceAfterLogDirFailureOnLeader(LogDirFailureTest$Roll$.MODULE$);
    }

    @Test
    public void brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure() {
        block3: {
            VolatileObjectRef statusCodeOption = VolatileObjectRef.create((Object)None$.MODULE$);
            Exit$.MODULE$.setHaltProcedure((Function2 & Serializable & scala.Serializable)(statusCode, x$1) -> LogDirFailureTest.$anonfun$brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$1(statusCodeOption, BoxesRunTime.unboxToInt((Object)statusCode), x$1));
            KafkaServer server = null;
            try {
                int x$12 = this.brokerCount();
                String x$2 = this.zkConnect();
                int x$3 = 3;
                boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
                boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
                int x$6 = TestUtils$.MODULE$.createBrokerConfig$default$5();
                Option<SecurityProtocol> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$6();
                Option<File> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$7();
                Option<Properties> x$9 = TestUtils$.MODULE$.createBrokerConfig$default$8();
                boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$9();
                boolean x$11 = TestUtils$.MODULE$.createBrokerConfig$default$10();
                int x$122 = TestUtils$.MODULE$.createBrokerConfig$default$11();
                boolean x$13 = TestUtils$.MODULE$.createBrokerConfig$default$12();
                int x$14 = TestUtils$.MODULE$.createBrokerConfig$default$13();
                boolean x$15 = TestUtils$.MODULE$.createBrokerConfig$default$14();
                int x$16 = TestUtils$.MODULE$.createBrokerConfig$default$15();
                Option<String> x$17 = TestUtils$.MODULE$.createBrokerConfig$default$16();
                boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
                Properties props = TestUtils$.MODULE$.createBrokerConfig(x$12, x$2, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$122, x$13, x$14, x$15, x$16, x$17, x$3, x$18);
                props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "0.11.0");
                props.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), "0.11.0");
                KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
                File logDir = new File((String)kafkaConfig.logDirs().head());
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Utils.delete((File)logDir), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
                logDir.createNewFile();
                Assert.assertTrue((boolean)logDir.isFile());
                server = TestUtils$.MODULE$.createServer(kafkaConfig, TestUtils$.MODULE$.createServer$default$2());
                TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Option)statusCodeOption$1.elem).contains((Object)BoxesRunTime.boxToInteger((int)1)), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "timed out waiting for broker to halt", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            }
            catch (Throwable throwable) {
                Exit$.MODULE$.resetHaltProcedure();
                if (server != null) {
                    TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)new .colon.colon(server, (List)Nil$.MODULE$));
                }
                throw throwable;
            }
            Exit$.MODULE$.resetHaltProcedure();
            if (server == null) break block3;
            TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$));
        }
    }

    @Test
    public void testIOExceptionDuringCheckpoint() {
        this.testProduceAfterLogDirFailureOnLeader(LogDirFailureTest$Checkpoint$.MODULE$);
    }

    @Test
    public void testReplicaFetcherThreadAfterLogDirFailureOnFollower() {
        this.producerConfig().setProperty("retries", "0");
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        PartitionInfo partitionInfo = (PartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(producer.partitionsFor(this.topic())).asScala()).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$1(x$2))).get();
        int leaderServerId = partitionInfo.leader().id();
        KafkaServer leaderServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$2(leaderServerId, x$3))).get();
        int followerServerId = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.replicas())).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$5 -> x$5 != leaderServerId).get());
        KafkaServer followerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$5(followerServerId, x$6))).get();
        followerServer.replicaManager().markPartitionOffline(partition);
        int anotherPartitionWithTheSameLeader = BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), this.partitionNum()).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> leaderServer.replicaManager().getPartition(new TopicPartition(this.topic(), i)).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> x$7.leaderReplicaIfLocal()).isDefined()).get());
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(anotherPartitionWithTheSameLeader), (Object)this.topic().getBytes(), (Object)"message".getBytes());
        producer.send(record).get();
        Assert.assertEquals((long)this.brokerCount(), (long)((Partition)leaderServer.replicaManager().getPartition(new TopicPartition(this.topic(), anotherPartitionWithTheSameLeader)).get()).inSyncReplicas().size());
        followerServer.replicaManager().replicaFetcherManager().fetcherThreadMap().values().foreach((Function1 & Serializable & scala.Serializable)thread -> {
            LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$8(thread);
            return BoxedUnit.UNIT;
        });
    }

    public void testProduceAfterLogDirFailureOnLeader(LogDirFailureType failureType) {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        this.producerConfig().setProperty("retries", "0");
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        int leaderServerId = ((PartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(producer.partitionsFor(this.topic())).asScala()).find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$1(x$8))).get()).leader().id();
        KafkaServer leaderServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$2(leaderServerId, x$9))).get();
        producer.send(record).get();
        TestUtils$.MODULE$.consumeRecords(consumer, 1, TestUtils$.MODULE$.consumeRecords$default$3());
        Replica replica = leaderServer.replicaManager().localReplicaOrException(partition);
        File logDir = ((Log)replica.log().get()).dir().getParentFile();
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Utils.delete((File)logDir), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
        logDir.createNewFile();
        Assert.assertTrue((boolean)logDir.isFile());
        LogDirFailureType logDirFailureType = failureType;
        LogDirFailureTest$Roll$ logDirFailureTest$Roll$ = LogDirFailureTest$Roll$.MODULE$;
        if (!(logDirFailureType != null ? !logDirFailureType.equals(logDirFailureTest$Roll$) : logDirFailureTest$Roll$ != null)) {
            try {
                Log qual$1 = (Log)leaderServer.replicaManager().getLog(partition).get();
                Option x$1 = qual$1.roll$default$1();
                qual$1.roll(x$1);
                throw Assertions$.MODULE$.fail("Log rolling should fail with KafkaStorageException", new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
            }
            catch (KafkaStorageException e) {}
        } else {
            LogDirFailureType logDirFailureType2 = failureType;
            LogDirFailureTest$Checkpoint$ logDirFailureTest$Checkpoint$ = LogDirFailureTest$Checkpoint$.MODULE$;
            if (!(logDirFailureType2 != null ? !logDirFailureType2.equals(logDirFailureTest$Checkpoint$) : logDirFailureTest$Checkpoint$ != null)) {
                leaderServer.replicaManager().checkpointHighWatermarks();
            }
        }
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !leaderServer.logManager().isLogDirOnline(logDir.getAbsolutePath()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected log directory offline", 3000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertTrue((boolean)leaderServer.replicaManager().localReplica(partition).isEmpty());
        try {
            producer.send(record).get(6000L, TimeUnit.MILLISECONDS);
            throw Assertions$.MODULE$.fail("send() should fail with either KafkaStorageException or NotLeaderForPartitionException", new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof KafkaStorageException) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (throwable instanceof NotLeaderForPartitionException) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                if (throwable != null) {
                    Throwable throwable2 = throwable;
                    throw Assertions$.MODULE$.fail(new StringBuilder(98).append("send() should fail with either KafkaStorageException or NotLeaderForPartitionException instead of ").append(throwable2.toString()).toString(), new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
                }
                throw new MatchError((Object)throwable);
            }
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                producer.send(record);
                return ((PartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(producer.partitionsFor(this.topic())).asScala()).find((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$7(x$10))).get()).leader().id() != leaderServerId;
            }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected new leader for the partition", 6000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            producer.send(record).get(6000L, TimeUnit.MILLISECONDS);
            TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
            Assert.assertTrue((boolean)this.zkClient().getAllLogDirEventNotifications().isEmpty());
            KafkaServer controllerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$9(x$11))).get();
            Set offlineReplicas = controllerServer.kafkaController().controllerContext().replicasInState(this.topic(), (ReplicaState)OfflineReplica$.MODULE$);
            Assert.assertTrue((boolean)offlineReplicas.contains((Object)new PartitionAndReplica(new TopicPartition(this.topic(), 0), leaderServerId)));
            return;
        }
    }

    private void subscribeAndWaitForAssignment(String topic, KafkaConsumer<byte[], byte[]> consumer) {
        consumer.subscribe(Collections.singletonList(topic));
        TestUtils$.MODULE$.pollUntilTrue((Consumer<?, ?>)consumer, (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !consumer.assignment().isEmpty(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected non-empty assignment", TestUtils$.MODULE$.pollUntilTrue$default$4());
    }

    public static final /* synthetic */ Nothing$ $anonfun$brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$1(VolatileObjectRef statusCodeOption$1, int statusCode, Option x$1) {
        statusCodeOption$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)statusCode));
        throw new IllegalArgumentException();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$1(PartitionInfo x$2) {
        return x$2.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$2(int leaderServerId$1, KafkaServer x$3) {
        return x$3.config().brokerId() == leaderServerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$5(int followerServerId$1, KafkaServer x$6) {
        return x$6.config().brokerId() == followerServerId$1;
    }

    public static final /* synthetic */ void $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$8(ReplicaFetcherThread thread) {
        Assert.assertFalse((String)"ReplicaFetcherThread should still be working if its partition count > 0", (boolean)thread.isShutdownComplete());
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$1(PartitionInfo x$8) {
        return x$8.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$2(int leaderServerId$2, KafkaServer x$9) {
        return x$9.config().brokerId() == leaderServerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$7(PartitionInfo x$10) {
        return x$10.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$9(KafkaServer x$11) {
        return x$11.kafkaController().isActive();
    }

    public LogDirFailureTest() {
        this.producerCount = 1;
        this.consumerCount = 1;
        this.brokerCount = 2;
        this.topic = "topic";
        this.partitionNum = 12;
        this.logDirCount = 3;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ReplicaHighWatermarkCheckpointIntervalMsProp(), "60000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.NumReplicaFetchersProp(), "1");
    }

    public static interface LogDirFailureType {
    }
}

