/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManager$;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.QuotaType;
import kafka.server.ThrottledChannel;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001\u0002\u000b\u0016\u0001iAQ!\t\u0001\u0005\u0002\tBq!\n\u0001C\u0002\u0013%a\u0005\u0003\u00045\u0001\u0001\u0006Ia\n\u0005\bk\u0001\u0001\r\u0011\"\u00037\u0011\u001dQ\u0004\u00011A\u0005\nmBa!\u0011\u0001!B\u00139\u0004b\u0002\"\u0001\u0001\u0004%IA\u000e\u0005\b\u0007\u0002\u0001\r\u0011\"\u0003E\u0011\u00191\u0005\u0001)Q\u0005o!9q\t\u0001b\u0001\n\u0013A\u0005B\u0002(\u0001A\u0003%\u0011\nC\u0004P\u0001\t\u0007I\u0011\u0002)\t\rm\u0003\u0001\u0015!\u0003R\u0011\u0015a\u0006\u0001\"\u0003^\u0011%\t\t\u0001AI\u0001\n\u0013\t\u0019\u0001C\u0004\u0002\u001e\u0001!\t!a\b\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>!9\u0011Q\n\u0001\u0005\u0002\u0005u\u0002bBA,\u0001\u0011\u0005\u0011Q\b\u0002\u001f)\"\u0014x\u000e\u001e;mK\u0012\u001c\u0005.\u00198oK2,\u0005\u0010]5sCRLwN\u001c+fgRT!AF\f\u0002\rM,'O^3s\u0015\u0005A\u0012!B6bM.\f7\u0001A\n\u0003\u0001m\u0001\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001$!\t!\u0003!D\u0001\u0016\u0003\u0011!\u0018.\\3\u0016\u0003\u001d\u0002\"\u0001\u000b\u001a\u000e\u0003%R!AK\u0016\u0002\u000bU$\u0018\u000e\\:\u000b\u00051j\u0013AB2p[6|gN\u0003\u0002\u0019])\u0011q\u0006M\u0001\u0007CB\f7\r[3\u000b\u0003E\n1a\u001c:h\u0013\t\u0019\u0014F\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003yqW/\\\"bY2\u0014\u0017mY6t\r>\u00148\u000b^1siRC'o\u001c;uY&tw-F\u00018!\ta\u0002(\u0003\u0002:;\t\u0019\u0011J\u001c;\u0002E9,XnQ1mY\n\f7m[:G_J\u001cF/\u0019:u)\"\u0014x\u000e\u001e;mS:<w\fJ3r)\tat\b\u0005\u0002\u001d{%\u0011a(\b\u0002\u0005+:LG\u000fC\u0004A\u000b\u0005\u0005\t\u0019A\u001c\u0002\u0007a$\u0013'A\u0010ok6\u001c\u0015\r\u001c7cC\u000e\\7OR8s'R\f'\u000f\u001e+ie>$H\u000f\\5oO\u0002\nAD\\;n\u0007\u0006dGNY1dWN4uN]#oIRC'o\u001c;uY&tw-\u0001\u0011ok6\u001c\u0015\r\u001c7cC\u000e\\7OR8s\u000b:$G\u000b\u001b:piRd\u0017N\\4`I\u0015\fHC\u0001\u001fF\u0011\u001d\u0001\u0005\"!AA\u0002]\nQD\\;n\u0007\u0006dGNY1dWN4uN]#oIRC'o\u001c;uY&tw\rI\u0001\b[\u0016$(/[2t+\u0005I\u0005C\u0001&M\u001b\u0005Y%BA$,\u0013\ti5JA\u0004NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\nqA]3rk\u0016\u001cH/F\u0001R!\t\u0011\u0006L\u0004\u0002T-6\tAK\u0003\u0002V/\u00059a.\u001a;x_J\\\u0017BA,U\u00039\u0011V-];fgR\u001c\u0005.\u00198oK2L!!\u0017.\u0003\u000fI+\u0017/^3ti*\u0011q\u000bV\u0001\te\u0016\fX/Z:uA\u0005a!-^5mIJ+\u0017/^3tiV\u0011a\f\u001a\u000b\u0004?BL\b\u0003\u0002\u000faEFK!!Y\u000f\u0003\rQ+\b\u000f\\33!\t\u0019G\r\u0004\u0001\u0005\u000b\u0015t!\u0019\u00014\u0003\u0003Q\u000b\"a\u001a6\u0011\u0005qA\u0017BA5\u001e\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"a\u001b8\u000e\u00031T!!\\\u0016\u0002\u0011I,\u0017/^3tiNL!a\u001c7\u0003\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRDQ!\u001d\bA\u0002I\fqAY;jY\u0012,'\u000fE\u0002tm\nt!a\u001b;\n\u0005Ud\u0017aD!cgR\u0014\u0018m\u0019;SKF,Xm\u001d;\n\u0005]D(a\u0002\"vS2$WM\u001d\u0006\u0003k2DqA\u001f\b\u0011\u0002\u0003\u000710\u0001\u0007mSN$XM\\3s\u001d\u0006lW\r\u0005\u0002}}6\tQP\u0003\u0002VW%\u0011q0 \u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.Z\u0001\u0017EVLG\u000e\u001a*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%eU!\u0011QAA\u000e+\t\t9AK\u0002|\u0003\u0013Y#!a\u0003\u0011\t\u00055\u0011qC\u0007\u0003\u0003\u001fQA!!\u0005\u0002\u0014\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003+i\u0012AC1o]>$\u0018\r^5p]&!\u0011\u0011DA\b\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\u0006K>\u0011\rAZ\u0001\tG\u0006dGNY1dWR\u0019A(!\t\t\u000f\u0005\r\u0002\u00031\u0001\u0002&\u0005A!/Z:q_:\u001cX\r\u0005\u0003\u0002(\u0005]bbAA\u0015-:!\u00111FA\u001b\u001d\u0011\ti#a\r\u000e\u0005\u0005=\"bAA\u00193\u00051AH]8pizJ\u0011\u0001G\u0005\u0003+^I1!!\u000f[\u0005!\u0011Vm\u001d9p]N,\u0017\u0001\u00042fM>\u0014X-T3uQ>$G#\u0001\u001f)\u0007E\t\t\u0005\u0005\u0003\u0002D\u0005%SBAA#\u0015\r\t9\u0005M\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003\u0017\n)E\u0001\u0004CK\u001a|'/Z\u0001&i\u0016\u001cHoQ1mY\n\f7m[%om>\u001c\u0017\r^5p]\u00063G/\u001a:FqBL'/\u0019;j_:D3AEA)!\u0011\t\u0019%a\u0015\n\t\u0005U\u0013Q\t\u0002\u0005)\u0016\u001cH/A\ruKN$H\u000b\u001b:piRdW\rZ\"iC:tW\r\u001c#fY\u0006L\bfA\n\u0002R\u0001")
public class ThrottledChannelExpirationTest {
    private final MockTime time = new MockTime();
    private int numCallbacksForStartThrottling = 0;
    private int numCallbacksForEndThrottling = 0;
    private final Metrics metrics = new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time());
    private final RequestChannel.Request request = (RequestChannel.Request)this.buildRequest((AbstractRequest.Builder)FetchRequest.Builder.forConsumer((int)0, (int)1000, new HashMap()), this.buildRequest$default$2())._2();

    private MockTime time() {
        return this.time;
    }

    private int numCallbacksForStartThrottling() {
        return this.numCallbacksForStartThrottling;
    }

    private void numCallbacksForStartThrottling_$eq(int x$1) {
        this.numCallbacksForStartThrottling = x$1;
    }

    private int numCallbacksForEndThrottling() {
        return this.numCallbacksForEndThrottling;
    }

    private void numCallbacksForEndThrottling_$eq(int x$1) {
        this.numCallbacksForEndThrottling = x$1;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private RequestChannel.Request request() {
        return this.request;
    }

    private <T extends AbstractRequest> Tuple2<T, RequestChannel.Request> buildRequest(AbstractRequest.Builder<T> builder, ListenerName listenerName) {
        AbstractRequest request = builder.build();
        ByteBuffer buffer = request.serialize(new RequestHeader(builder.apiKey(), request.version(), "", 0));
        RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)EasyMock.createNiceMock(RequestChannel.Metrics.class);
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, listenerName, SecurityProtocol.PLAINTEXT);
        return new Tuple2((Object)request, (Object)new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, requestChannelMetrics));
    }

    private <T extends AbstractRequest> ListenerName buildRequest$default$2() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    }

    public void callback(RequestChannel.Response response) {
        RequestChannel.Response response2 = response;
        if (response2 instanceof RequestChannel.StartThrottlingResponse) {
            this.numCallbacksForStartThrottling_$eq(this.numCallbacksForStartThrottling() + 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (response2 instanceof RequestChannel.EndThrottlingResponse) {
            this.numCallbacksForEndThrottling_$eq(this.numCallbacksForEndThrottling() + 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)response2);
        }
    }

    @Before
    public void beforeMethod() {
        this.numCallbacksForStartThrottling_$eq(0);
        this.numCallbacksForEndThrottling_$eq(0);
    }

    @Test
    public void testCallbackInvocationAfterExpiration() {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.apply$default$1(), ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        DelayQueue<ThrottledChannel> delayQueue = new DelayQueue<ThrottledChannel>();
        ClientQuotaManager.ThrottledChannelReaper reaper = new ClientQuotaManager.ThrottledChannelReaper(clientMetrics, delayQueue, "");
        try {
            ThrottledChannel channel1 = new ThrottledChannel(this.request(), (Time)this.time(), 10, (Function1 & Serializable & scala.Serializable)response -> {
                this.callback(response);
                return BoxedUnit.UNIT;
            });
            ThrottledChannel channel2 = new ThrottledChannel(this.request(), (Time)this.time(), 30, (Function1 & Serializable & scala.Serializable)response -> {
                this.callback(response);
                return BoxedUnit.UNIT;
            });
            ThrottledChannel channel3 = new ThrottledChannel(this.request(), (Time)this.time(), 30, (Function1 & Serializable & scala.Serializable)response -> {
                this.callback(response);
                return BoxedUnit.UNIT;
            });
            ThrottledChannel channel4 = new ThrottledChannel(this.request(), (Time)this.time(), 20, (Function1 & Serializable & scala.Serializable)response -> {
                this.callback(response);
                return BoxedUnit.UNIT;
            });
            delayQueue.add(channel1);
            delayQueue.add(channel2);
            delayQueue.add(channel3);
            delayQueue.add(channel4);
            Assert.assertEquals((long)4L, (long)this.numCallbacksForStartThrottling());
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)itr -> {
                this.time().sleep(10L);
                reaper.doWork();
                Assert.assertEquals((long)itr, (long)this.numCallbacksForEndThrottling());
            });
            reaper.doWork();
            Assert.assertEquals((long)4L, (long)this.numCallbacksForEndThrottling());
            Assert.assertEquals((long)0L, (long)delayQueue.size());
            reaper.doWork();
            Assert.assertEquals((long)4L, (long)this.numCallbacksForEndThrottling());
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testThrottledChannelDelay() {
        ThrottledChannel t1 = new ThrottledChannel(this.request(), (Time)this.time(), 10, (Function1 & Serializable & scala.Serializable)response -> {
            this.callback(response);
            return BoxedUnit.UNIT;
        });
        ThrottledChannel t2 = new ThrottledChannel(this.request(), (Time)this.time(), 20, (Function1 & Serializable & scala.Serializable)response -> {
            this.callback(response);
            return BoxedUnit.UNIT;
        });
        ThrottledChannel t3 = new ThrottledChannel(this.request(), (Time)this.time(), 20, (Function1 & Serializable & scala.Serializable)response -> {
            this.callback(response);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)10L, (long)t1.throttleTimeMs());
        Assert.assertEquals((long)20L, (long)t2.throttleTimeMs());
        Assert.assertEquals((long)20L, (long)t3.throttleTimeMs());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)itr -> {
            Assert.assertEquals((long)(10 - 10 * itr), (long)t1.getDelay(TimeUnit.MILLISECONDS));
            Assert.assertEquals((long)(20 - 10 * itr), (long)t2.getDelay(TimeUnit.MILLISECONDS));
            Assert.assertEquals((long)(20 - 10 * itr), (long)t3.getDelay(TimeUnit.MILLISECONDS));
            this.time().sleep(10L);
        });
    }
}

