/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Range;
import scala.collection.immutable.TreeMap;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\r\u001b\u0001}AQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001A\u0002\u0013\u00051\u0006C\u00040\u0001\u0001\u0007I\u0011\u0001\u0019\t\rY\u0002\u0001\u0015)\u0003-\u0011\u001d9\u0004A1A\u0005\u0002aBa\u0001\u0010\u0001!\u0002\u0013I\u0004bB\u001f\u0001\u0005\u0004%\tA\u0010\u0005\u0007\u0005\u0002\u0001\u000b\u0011B \t\u000b\r\u0003A\u0011\u0001#\t\u000b9\u0003A\u0011\u0001#\t\u000bM\u0003A\u0011\u0001#\t\u000ba\u0003A\u0011\u0001#\t\u000bi\u0003A\u0011\u0001#\t\u000bq\u0003A\u0011\u0001#\t\u000b1\u0004A\u0011\u0001#\t\u000b9\u0004A\u0011\u0001#\t\u000bq\u0004A\u0011\u0001#\t\u000by\u0004A\u0011\u0001#\t\r\u0005\u0005\u0001\u0001\"\u0001E\u0011\u0019\t)\u0001\u0001C\u0001\t\"1\u0011\u0011\u0002\u0001\u0005\u0002\u0011Cq!!\u0004\u0001\t\u0003\ty\u0001C\u0004\u0002N\u0001!\t!a\u0014\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0002h\tyqJ\u001a4tKRLe\u000eZ3y)\u0016\u001cHO\u0003\u0002\u001c9\u0005\u0019An\\4\u000b\u0003u\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001AA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0015\u0011\u0005%\u0002Q\"\u0001\u000e\u0002\u0007%$\u00070F\u0001-!\tIS&\u0003\u0002/5\tYqJ\u001a4tKRLe\u000eZ3y\u0003\u001dIG\r_0%KF$\"!\r\u001b\u0011\u0005\u0005\u0012\u0014BA\u001a#\u0005\u0011)f.\u001b;\t\u000fU\u001a\u0011\u0011!a\u0001Y\u0005\u0019\u0001\u0010J\u0019\u0002\t%$\u0007\u0010I\u0001\u000b[\u0006DXI\u001c;sS\u0016\u001cX#A\u001d\u0011\u0005\u0005R\u0014BA\u001e#\u0005\rIe\u000e^\u0001\f[\u0006DXI\u001c;sS\u0016\u001c\b%\u0001\u0006cCN,wJ\u001a4tKR,\u0012a\u0010\t\u0003C\u0001K!!\u0011\u0012\u0003\t1{gnZ\u0001\fE\u0006\u001cXm\u00144gg\u0016$\b%A\u0003tKR,\b\u000fF\u00012Q\tIa\t\u0005\u0002H\u00196\t\u0001J\u0003\u0002J\u0015\u0006)!.\u001e8ji*\t1*A\u0002pe\u001eL!!\u0014%\u0003\r\t+gm\u001c:f\u0003!!X-\u0019:e_^t\u0007F\u0001\u0006Q!\t9\u0015+\u0003\u0002S\u0011\n)\u0011I\u001a;fe\u0006\u0001\"/\u00198e_6dun\\6vaR+7\u000f\u001e\u0015\u0003\u0017U\u0003\"a\u0012,\n\u0005]C%\u0001\u0002+fgR\f!\u0003\\8pWV\u0004X\t\u001f;sK6,7)Y:fg\"\u0012A\"V\u0001\ni\u0016\u001cH/\u00128uefD#!D+\u0002#Q,7\u000f^#oiJLxJ^3sM2|w\u000f\u000b\u0003\u000f+z{\u0016\u0001C3ya\u0016\u001cG/\u001a3$\u0003\u0001\u0004\"!Y5\u000f\u0005\t<gBA2g\u001b\u0005!'BA3\u001f\u0003\u0019a$o\\8u}%\t1%\u0003\u0002iE\u00059\u0001/Y2lC\u001e,\u0017B\u00016l\u0005aIE\u000e\\3hC2\f%oZ;nK:$X\t_2faRLwN\u001c\u0006\u0003Q\n\nQ\"\u00199qK:$Gk\\8NC:L\bFA\bV\u0003A\t\u0007\u000f]3oI>+Ho\u00144Pe\u0012,'\u000f\u000b\u0003\u0011+z\u00038%A9\u0011\u0005ITX\"A:\u000b\u0005Q,\u0018AB3se>\u00148O\u0003\u0002wo\u000611m\\7n_:T!!\b=\u000b\u0005eT\u0015AB1qC\u000eDW-\u0003\u0002|g\n1\u0012J\u001c<bY&$wJ\u001a4tKR,\u0005pY3qi&|g.A\ruKN$h)\u001a;dQV\u0003\b/\u001a:C_VtGm\u00144gg\u0016$\bFA\tV\u0003)!Xm\u001d;SK>\u0004XM\u001c\u0015\u0003%U\u000b\u0001\u0002\u001e:v]\u000e\fG/\u001a\u0015\u0003'U\u000baBZ8sG\u0016,f.\\1q)\u0016\u001cH\u000f\u000b\u0002\u0015+\u0006)C/Z:u'\u0006t\u0017\u000e^=MCN$xJ\u001a4tKR,\u0015/^1m)>\u0014\u0015m]3PM\u001a\u001cX\r\u001e\u0015\u0003+U\u000b\u0001#Y:tKJ$xK]5uK\u001a\u000b\u0017\u000e\\:\u0016\t\u0005E\u00111\b\u000b\nc\u0005M\u0011qEA\u0015\u0003[Aq!!\u0006\u0017\u0001\u0004\t9\"A\u0004nKN\u001c\u0018mZ3\u0011\t\u0005e\u0011\u0011\u0005\b\u0005\u00037\ti\u0002\u0005\u0002dE%\u0019\u0011q\u0004\u0012\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019#!\n\u0003\rM#(/\u001b8h\u0015\r\tyB\t\u0005\u0006UY\u0001\r\u0001\f\u0005\u0007\u0003W1\u0002\u0019A\u001d\u0002\r=4gm]3u\u0011\u001d\tyC\u0006a\u0001\u0003c\tQa\u001b7bgN\u0004b!!\u0007\u00024\u0005]\u0012\u0002BA\u001b\u0003K\u0011Qa\u00117bgN\u0004B!!\u000f\u0002<1\u0001AaBA\u001f-\t\u0007\u0011q\b\u0002\u0002)F!\u0011\u0011IA$!\r\t\u00131I\u0005\u0004\u0003\u000b\u0012#a\u0002(pi\"Lgn\u001a\t\u0004C\u0005%\u0013bAA&E\t\u0019\u0011I\\=\u0002\u00195|gn\u001c;p]&\u001c7+Z9\u0015\r\u0005E\u0013QLA1!\u0015\t\u0019&!\u0017:\u001b\t\t)FC\u0002\u0002X\t\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY&!\u0016\u0003\u0007M+\u0017\u000f\u0003\u0004\u0002`]\u0001\r!O\u0001\u0005E\u0006\u001cX\r\u0003\u0004\u0002d]\u0001\r!O\u0001\u0004Y\u0016t\u0017a\u00058p]\u0016C\u0018n\u001d;f]R$V-\u001c9GS2,GCAA5!\u0011\tY'!\u001e\u000e\u0005\u00055$\u0002BA8\u0003c\n!![8\u000b\u0005\u0005M\u0014\u0001\u00026bm\u0006LA!a\u001e\u0002n\t!a)\u001b7f\u0001")
public class OffsetIndexTest {
    private OffsetIndex idx = null;
    private final int maxEntries;
    private final long baseOffset;

    public OffsetIndex idx() {
        return this.idx;
    }

    public void idx_$eq(OffsetIndex x$1) {
        this.idx = x$1;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    @Before
    public void setup() {
        this.idx_$eq(new OffsetIndex(this.nonExistentTempFile(), this.baseOffset(), 240, OffsetIndex$.MODULE$.$lessinit$greater$default$4()));
    }

    @After
    public void teardown() {
        if (this.idx() != null) {
            this.idx().file().delete();
        }
    }

    @Test
    public void randomLookupTest() {
        Assert.assertEquals((String)"Not present value should return physical offset 0.", (Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(92L));
        int base = (int)this.idx().baseOffset() + 1;
        int size = this.idx().maxEntries();
        Seq vals = (Seq)((IterableLike)this.monotonicSeq(base, size).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)x$1 -> x$1, Seq$.MODULE$.canBuildFrom())).zip(this.monotonicSeq(0, size), Seq$.MODULE$.canBuildFrom());
        vals.foreach((Function1 & Serializable & scala.Serializable)x -> {
            OffsetIndexTest.$anonfun$randomLookupTest$2(this, x);
            return BoxedUnit.UNIT;
        });
        vals.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            OffsetIndexTest.$anonfun$randomLookupTest$4(this, x$2);
            return BoxedUnit.UNIT;
        });
        TreeMap valMap = new TreeMap((Ordering)Ordering.Long$.MODULE$).$plus$plus((GenTraversableOnce)vals.map((Function1 & Serializable & scala.Serializable)p -> new Tuple2((Object)BoxesRunTime.boxToLong((long)p._1$mcJ$sp()), p), Seq$.MODULE$.canBuildFrom()));
        long l = this.idx().baseOffset();
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        long[] offsets = (long[])new RichLong(l).until((Object)BoxesRunTime.boxToLong((long)((int)((Tuple2)vals.last())._1$mcJ$sp()))).toArray(ClassTag$.MODULE$.Long());
        Collections.shuffle(Arrays.asList((Object[])new long[][]{offsets}));
        ArrayOps.ofLong foreach_this = new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(offsets)).take(30)));
        int foreach_len = foreach_this.length();
        for (int foreach_i = 0; foreach_i < foreach_len; ++foreach_i) {
            long l2 = BoxesRunTime.unboxToLong((Object)foreach_this.apply(foreach_i));
            OffsetIndexTest.$anonfun$randomLookupTest$6(this, valMap, l2);
        }
    }

    @Test
    public void lookupExtremeCases() {
        Assert.assertEquals((String)"Lookup on empty file", (Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()));
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, this.idx().maxEntries());
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                OffsetIndexTest.$anonfun$lookupExtremeCases$1(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Assert.assertEquals((Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()));
        Assert.assertEquals((Object)new OffsetPosition(this.idx().baseOffset() + (long)this.idx().maxEntries(), this.idx().maxEntries() - 1), (Object)this.idx().lookup(this.idx().baseOffset() + (long)this.idx().maxEntries()));
    }

    @Test
    public void testEntry() {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, this.idx().maxEntries());
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                OffsetIndexTest.$anonfun$testEntry$1(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        int n2 = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range2 = RichInt$.MODULE$.until$extension0(n2, this.idx().maxEntries());
        if (range2 == null) {
            throw null;
        }
        Range foreach$mVc$sp_this2 = range2;
        if (!foreach$mVc$sp_this2.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this2.start();
            while (true) {
                OffsetIndexTest.$anonfun$testEntry$2(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this2.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this2.step();
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEntryOverflow() {
        this.idx().entry(0);
    }

    @Test
    public void appendTooMany() {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, this.idx().maxEntries());
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                OffsetIndexTest.$anonfun$appendTooMany$1(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        this.assertWriteFails("Append should fail on a full index", this.idx(), this.idx().maxEntries() + 1, IllegalArgumentException.class);
    }

    @Test(expected=InvalidOffsetException.class)
    public void appendOutOfOrder() {
        this.idx().append(51L, 0);
        this.idx().append(50L, 1);
    }

    @Test
    public void testFetchUpperBoundOffset() {
        OffsetPosition first = new OffsetPosition(this.baseOffset() + 0L, 0);
        OffsetPosition second = new OffsetPosition(this.baseOffset() + 1L, 10);
        OffsetPosition third = new OffsetPosition(this.baseOffset() + 2L, 23);
        OffsetPosition fourth = new OffsetPosition(this.baseOffset() + 3L, 37);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(first, 5));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OffsetPosition[]{first, second, third, fourth}))).foreach((Function1 & Serializable & scala.Serializable)offsetPosition -> {
            OffsetIndexTest.$anonfun$testFetchUpperBoundOffset$1(this, offsetPosition);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)new Some((Object)second), (Object)this.idx().fetchUpperBoundOffset(first, 5));
        Assert.assertEquals((Object)new Some((Object)second), (Object)this.idx().fetchUpperBoundOffset(first, 10));
        Assert.assertEquals((Object)new Some((Object)third), (Object)this.idx().fetchUpperBoundOffset(first, 23));
        Assert.assertEquals((Object)new Some((Object)third), (Object)this.idx().fetchUpperBoundOffset(first, 22));
        Assert.assertEquals((Object)new Some((Object)fourth), (Object)this.idx().fetchUpperBoundOffset(second, 24));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(fourth, 1));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(first, 200));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(second, 200));
    }

    @Test
    public void testReopen() {
        OffsetPosition first = new OffsetPosition(51L, 0);
        OffsetPosition sec = new OffsetPosition(52L, 1);
        this.idx().append(first.offset(), first.position());
        this.idx().append(sec.offset(), sec.position());
        this.idx().close();
        OffsetIndex idxRo = new OffsetIndex(this.idx().file(), this.idx().baseOffset(), OffsetIndex$.MODULE$.$lessinit$greater$default$3(), OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        Assert.assertEquals((Object)first, (Object)idxRo.lookup(first.offset()));
        Assert.assertEquals((Object)sec, (Object)idxRo.lookup(sec.offset()));
        Assert.assertEquals((long)sec.offset(), (long)idxRo.lastOffset());
        Assert.assertEquals((long)2L, (long)idxRo.entries());
        this.assertWriteFails("Append should fail on read-only index", idxRo, 53, IllegalArgumentException.class);
    }

    @Test
    public void truncate() {
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), 0L, 80, OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        idx.truncate();
        int n = 1;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, 10);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                idx.append((long)foreach$mVc$sp_i, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        idx.truncateTo(12L);
        Assert.assertEquals((String)"Index should be unchanged by truncate past the end", (Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"9 should be the last entry in the index", (long)9L, (long)idx.lastOffset());
        idx.append(10L, 10);
        idx.truncateTo(10L);
        Assert.assertEquals((String)"Index should be unchanged by truncate at the end", (Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"9 should be the last entry in the index", (long)9L, (long)idx.lastOffset());
        idx.append(10L, 10);
        idx.truncateTo(9L);
        Assert.assertEquals((String)"Index should truncate off last entry", (Object)new OffsetPosition(8L, 8), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"8 should be the last entry in the index", (long)8L, (long)idx.lastOffset());
        idx.append(9L, 9);
        idx.truncateTo(5L);
        Assert.assertEquals((String)"4 should be the last entry in the index", (Object)new OffsetPosition(4L, 4), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"4 should be the last entry in the index", (long)4L, (long)idx.lastOffset());
        idx.append(5L, 5);
        idx.truncate();
        Assert.assertEquals((String)"Full truncation should leave no entries", (long)0L, (long)idx.entries());
        idx.append(0L, 0);
    }

    @Test
    public void forceUnmapTest() {
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), 0L, 80, OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        idx.forceUnmap();
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> idx.lookup(1L), ClassTag$.MODULE$.apply(NullPointerException.class), new Position("OffsetIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
    }

    @Test
    public void testSanityLastOffsetEqualToBaseOffset() {
        long baseOffset = 20L;
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), baseOffset, 80, OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        idx.append(baseOffset, 0);
        idx.sanityCheck();
    }

    public <T> void assertWriteFails(String message, OffsetIndex idx, int offset, Class<T> klass) {
        try {
            idx.append((long)offset, 1);
            Assert.fail((String)message);
            return;
        }
        catch (Exception e) {
            Assert.assertEquals((String)"Got an unexpected exception.", klass, e.getClass());
            return;
        }
    }

    public Seq<Object> monotonicSeq(int base, int len) {
        Random rand = new Random(1L);
        ArrayBuffer vals = new ArrayBuffer(len);
        IntRef last = IntRef.create((int)base);
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, len);
        if (range == null) {
            throw null;
        }
        Range foreach_this = range;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                OffsetIndexTest.$anonfun$monotonicSeq$1(last, rand, vals, foreach_i);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
        return vals;
    }

    /*
     * WARNING - void declaration
     */
    public File nonExistentTempFile() {
        void var1_1;
        File file = TestUtils$.MODULE$.tempFile();
        Files.delete(file.toPath());
        return var1_1;
    }

    public static final /* synthetic */ void $anonfun$randomLookupTest$2(OffsetIndexTest $this, Tuple2 x) {
        $this.idx().append(x._1$mcJ$sp(), x._2$mcI$sp());
    }

    public static final /* synthetic */ void $anonfun$randomLookupTest$4(OffsetIndexTest $this, Tuple2 x$2) {
        if (x$2 != null) {
            long logical = x$2._1$mcJ$sp();
            int physical = x$2._2$mcI$sp();
            Assert.assertEquals((String)"Should be able to find values that are present.", (Object)new OffsetPosition(logical, physical), (Object)$this.idx().lookup(logical));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$randomLookupTest$6(OffsetIndexTest $this, TreeMap valMap$1, long offset) {
        OffsetPosition rightAnswer = offset < BoxesRunTime.unboxToLong((Object)valMap$1.firstKey()) ? new OffsetPosition($this.idx().baseOffset(), 0) : new OffsetPosition(valMap$1.to((Object)BoxesRunTime.boxToLong((long)offset)).last()._1$mcJ$sp(), ((Tuple2)valMap$1.to((Object)BoxesRunTime.boxToLong((long)offset)).last()._2())._2$mcI$sp());
        Assert.assertEquals((String)"The index should give the same answer as the sorted map", (Object)rightAnswer, (Object)$this.idx().lookup(offset));
    }

    public static final /* synthetic */ void $anonfun$lookupExtremeCases$1(OffsetIndexTest $this, int i) {
        $this.idx().append($this.idx().baseOffset() + (long)i + 1L, i);
    }

    public static final /* synthetic */ void $anonfun$testEntry$1(OffsetIndexTest $this, int i) {
        $this.idx().append($this.idx().baseOffset() + (long)i + 1L, i);
    }

    public static final /* synthetic */ void $anonfun$testEntry$2(OffsetIndexTest $this, int i) {
        Assert.assertEquals((Object)new OffsetPosition($this.idx().baseOffset() + (long)i + 1L, i), (Object)$this.idx().entry(i));
    }

    public static final /* synthetic */ void $anonfun$appendTooMany$1(OffsetIndexTest $this, int i) {
        long offset = $this.idx().baseOffset() + (long)i + 1L;
        $this.idx().append(offset, i);
    }

    public static final /* synthetic */ void $anonfun$testFetchUpperBoundOffset$1(OffsetIndexTest $this, OffsetPosition offsetPosition) {
        $this.idx().append(offsetPosition.offset(), offsetPosition.position());
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$monotonicSeq$1(IntRef last$1, Random rand$1, ArrayBuffer vals$1, int _) {
        last$1.elem += rand$1.nextInt(15) + 1;
        return vals$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)last$1.elem));
    }

    public OffsetIndexTest() {
        this.maxEntries = 30;
        this.baseOffset = 45L;
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$monotonicSeq$1$adapted(IntRef last$1, Random rand$1, ArrayBuffer vals$1, Object _) {
        return OffsetIndexTest.$anonfun$monotonicSeq$1(last$1, rand$1, vals$1, BoxesRunTime.unboxToInt((Object)_));
    }
}

