/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricPredicate;
import java.io.Serializable;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.metrics.KafkaMetricsGroup$;
import kafka.server.BrokerTopicStats$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001\u0002\f\u0018\u0001qAQ!\u000b\u0001\u0005\u0002)Bq!\f\u0001C\u0002\u0013\u0005a\u0006\u0003\u00046\u0001\u0001\u0006Ia\f\u0005\bm\u0001\u0011\r\u0011\"\u0001/\u0011\u00199\u0004\u0001)A\u0005_!9\u0001\b\u0001b\u0001\n\u0003I\u0004B\u0002\"\u0001A\u0003%!\bC\u0003D\u0001\u0011\u0005A\tC\u0004R\u0001\t\u0007I\u0011\u0001\u0018\t\rI\u0003\u0001\u0015!\u00030\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u0015\t\u0007\u0001\"\u0001U\u0011\u0015\u0019\u0007\u0001\"\u0001U\u0011\u0015)\u0007\u0001\"\u0001U\u0011\u00159\u0007\u0001\"\u0001U\u0011\u0015I\u0007\u0001\"\u0001U\u0011\u0015Y\u0007\u0001\"\u0001U\u0011\u0015i\u0007\u0001\"\u0001U\u0011\u0015y\u0007\u0001\"\u0003q\u0011\u001d\tI\u0001\u0001C\u0005\u0003\u0017Aq!a\u0004\u0001\t\u0013\t\tBA\u0006NKR\u0014\u0018nY:UKN$(B\u0001\r\u001a\u0003\u001diW\r\u001e:jGNT\u0011AG\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001Qd\t\t\u0003=\u0005j\u0011a\b\u0006\u0003Ae\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]&\u0011!e\b\u0002\u0017\u0017\u000647.Y*feZ,'\u000fV3ti\"\u000b'O\\3tgB\u0011AeJ\u0007\u0002K)\u0011a%G\u0001\u0006kRLGn]\u0005\u0003Q\u0015\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002WA\u0011A\u0006A\u0007\u0002/\u0005Aa.^7O_\u0012,7/F\u00010!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\rIe\u000e^\u0001\n]Vlgj\u001c3fg\u0002\n\u0001B\\;n!\u0006\u0014Ho]\u0001\n]Vl\u0007+\u0019:ug\u0002\nqb\u001c<feJLG-\u001b8h!J|\u0007o]\u000b\u0002uA\u00111\bQ\u0007\u0002y)\u0011QHP\u0001\u0005kRLGNC\u0001@\u0003\u0011Q\u0017M^1\n\u0005\u0005c$A\u0003)s_B,'\u000f^5fg\u0006\u0001rN^3se&$\u0017N\\4Qe>\u00048\u000fI\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\tQ\tE\u0002G\u0013.k\u0011a\u0012\u0006\u0003\u0011F\n!bY8mY\u0016\u001cG/[8o\u0013\tQuIA\u0002TKF\u0004\"\u0001T(\u000e\u00035S!AT\r\u0002\rM,'O^3s\u0013\t\u0001VJA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!\u00038NKN\u001c\u0018mZ3t\u0003)qW*Z:tC\u001e,7\u000fI\u0001&i\u0016\u001cH/T3ue&\u001c7OU3q_J$XM]!gi\u0016\u0014H)\u001a7fi&tw\rV8qS\u000e$\u0012!\u0016\t\u0003aYK!aV\u0019\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0017e\u0003\"AW0\u000e\u0003mS!\u0001X/\u0002\u000b),h.\u001b;\u000b\u0003y\u000b1a\u001c:h\u0013\t\u00017L\u0001\u0003UKN$\u0018\u0001\u000e;fgR\u0014%o\\6feR{\u0007/[2NKR\u0014\u0018nY:V]J,w-[:uKJ,G-\u00114uKJ$U\r\\3uS:<Gk\u001c9jG\"\u0012A\"W\u0001\u0014i\u0016\u001cHo\u00117vgR,'/\u00133NKR\u0014\u0018n\u0019\u0015\u0003\u001be\u000b!\u0007^3ti\u001e+g.\u001a:bY\n\u0013xn[3s)>\u0004\u0018nY'fiJL7m]!sK\u001e\u0013X-\u001a3jYf\u0014VmZ5ti\u0016\u0014X\r\u001a\u0015\u0003\u001de\u000b\u0001\u0004^3ti^Kg\u000eZ8xgN#\u0018\u0010\\3UC\u001et\u0015-\\3tQ\ty\u0011,\u0001\u0011uKN$(I]8lKJ$v\u000e]5d\u001b\u0016$(/[2t\u0005f$Xm]%o\u001fV$\bF\u0001\tZ\u0003U!Xm\u001d;D_:$(o\u001c7mKJlU\r\u001e:jGND#!E-\u0002AQ,7\u000f^*fgNLwN\\#ya&\u0014X\rT5ti\u0016tWM]'fiJL7m\u001d\u0015\u0003%e\u000bA\u0002^8qS\u000elU\r\u001e:jGN$\"!]@\u0011\u0007\u0019\u0013H/\u0003\u0002t\u000f\n\u00191+\u001a;\u0011\u0005UdhB\u0001<{!\t9\u0018'D\u0001y\u0015\tI8$\u0001\u0004=e>|GOP\u0005\u0003wF\na\u0001\u0015:fI\u00164\u0017BA?\u007f\u0005\u0019\u0019FO]5oO*\u001110\r\u0005\b\u0003\u0003\u0019\u0002\u0019AA\u0002\u0003\u0015!x\u000e]5d!\u0011\u0001\u0014Q\u0001;\n\u0007\u0005\u001d\u0011G\u0001\u0004PaRLwN\\\u0001\u0012i>\u0004\u0018nY'fiJL7m\u0012:pkB\u001cHcA9\u0002\u000e!1\u0011\u0011\u0001\u000bA\u0002Q\f\u0001DZ5mi\u0016\u0014()\u001f+pa&\u001cW*\u001a;sS\u000e\u0014VmZ3y)\u0015\t\u00181CA\u000b\u0011\u0015AR\u00031\u0001r\u0011\u001d\t\t!\u0006a\u0001\u0003\u0007\u0001")
public class MetricsTest
extends KafkaServerTestHarness {
    private final int numNodes;
    private final int numParts;
    private final Properties overridingProps = new Properties();
    private final int nMessages;

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numNodes(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    public int nMessages() {
        return this.nMessages;
    }

    @Test
    public void testMetricsReporterAfterDeletingTopic() {
        String topic = "test-topic-metric";
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, (Seq<KafkaServer>)this.servers());
        Assert.assertEquals((String)"Topic metrics exists after deleteTopic", (Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic));
    }

    @Test
    public void testBrokerTopicMetricsUnregisteredAfterDeletingTopic() {
        String topic = "test-broker-topic-metric";
        this.createTopic(topic, 2, 1, this.createTopic$default$4());
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        Assert.assertTrue((String)"Topic metrics don't exist", (boolean)this.topicMetricGroups(topic).nonEmpty());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsUnregisteredAfterDeletingTopic$1(topic, s);
            return BoxedUnit.UNIT;
        });
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, (Seq<KafkaServer>)this.servers());
        Assert.assertEquals((String)"Topic metrics exists after deleteTopic", (Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic));
    }

    @Test
    public void testClusterIdMetric() {
        java.util.Map metrics = Metrics.defaultRegistry().allMetrics();
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testClusterIdMetric$1(x$2))), (long)1L);
    }

    @Test
    public void testGeneralBrokerTopicMetricsAreGreedilyRegistered() {
        String topic = "test-broker-topic-metric";
        this.createTopic(topic, 2, 1, this.createTopic$default$4());
        Assert.assertTrue((String)"General topic metrics don't exist", (boolean)this.topicMetrics((Option<String>)None$.MODULE$).nonEmpty());
        Assert.assertEquals((long)((KafkaServer)this.servers().head()).brokerTopicStats().allTopicsStats().metricMap().size(), (long)this.topicMetrics((Option<String>)None$.MODULE$).size());
        Assert.assertTrue((String)"Topic metrics aren't lazily registered", (boolean)this.topicMetricGroups(topic).isEmpty());
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        Assert.assertTrue((String)"Topic metrics aren't registered", (boolean)this.topicMetricGroups(topic).nonEmpty());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testWindowsStyleTagNames() {
        void $minus$greater$extension_$this;
        String path = "C:\\windows-path\\kafka-logs";
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"dir");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)path);
        Map tags = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        String expectedMBeanName = ((TraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)tags.keySet().head(), ObjectName.quote(path)}))).mkString("=");
        MetricName metric = KafkaMetricsGroup$.MODULE$.metricName("test-metric", tags);
        Predef$.MODULE$.assert(metric.getMBeanName().endsWith(expectedMBeanName));
    }

    @Test
    public void testBrokerTopicMetricsBytesInOut() {
        String topic = "test-bytes-in-out";
        String replicationBytesIn = BrokerTopicStats$.MODULE$.ReplicationBytesInPerSec();
        String replicationBytesOut = BrokerTopicStats$.MODULE$.ReplicationBytesOutPerSec();
        String bytesIn = new StringBuilder(7).append(BrokerTopicStats$.MODULE$.BytesInPerSec()).append(",topic=").append(topic).toString();
        String bytesOut = new StringBuilder(7).append(BrokerTopicStats$.MODULE$.BytesOutPerSec()).append(",topic=").append(topic).toString();
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), "2");
        this.createTopic(topic, 1, this.numNodes(), topicConfig);
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsBytesInOut$1(topic, topicPartition, server);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.consumeTopicRecords((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.consumeTopicRecords$default$4(), TestUtils$.MODULE$.consumeTopicRecords$default$5(), TestUtils$.MODULE$.consumeTopicRecords$default$6(), TestUtils$.MODULE$.consumeTopicRecords$default$7());
        long initialReplicationBytesIn = TestUtils$.MODULE$.meterCount(replicationBytesIn);
        long initialReplicationBytesOut = TestUtils$.MODULE$.meterCount(replicationBytesOut);
        long initialBytesIn = TestUtils$.MODULE$.meterCount(bytesIn);
        long initialBytesOut = TestUtils$.MODULE$.meterCount(bytesOut);
        Assert.assertEquals((long)initialBytesOut, (long)TestUtils$.MODULE$.meterCount(bytesOut));
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        Assert.assertTrue((TestUtils$.MODULE$.meterCount(replicationBytesIn) > initialReplicationBytesIn ? 1 : 0) != 0);
        Assert.assertTrue((TestUtils$.MODULE$.meterCount(replicationBytesOut) > initialReplicationBytesOut ? 1 : 0) != 0);
        Assert.assertTrue((TestUtils$.MODULE$.meterCount(bytesIn) > initialBytesIn ? 1 : 0) != 0);
        TestUtils$.MODULE$.consumeTopicRecords((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.consumeTopicRecords$default$4(), TestUtils$.MODULE$.consumeTopicRecords$default$5(), TestUtils$.MODULE$.consumeTopicRecords$default$6(), TestUtils$.MODULE$.consumeTopicRecords$default$7());
        Assert.assertTrue((TestUtils$.MODULE$.meterCount(bytesOut) > initialBytesOut ? 1 : 0) != 0);
    }

    @Test
    public void testControllerMetrics() {
        java.util.Map metrics = Metrics.defaultRegistry().allMetrics();
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$1(x$5))), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$2(x$6))), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$3(x$7))), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$4(x$8))), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$5(x$9))), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$6(x$10))), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$7(x$11))), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$8(x$12))), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$9(x$13))), (long)1L);
    }

    @Test
    public void testSessionExpireListenerMetrics() {
        java.util.Map metrics = Metrics.defaultRegistry().allMetrics();
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$1(x$14))), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$2(x$15))), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$3(x$16))), (long)1L);
    }

    private Set<String> topicMetrics(Option<String> topic) {
        scala.collection.mutable.Set metricNames = (scala.collection.mutable.Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().allMetrics().keySet()).asScala()).map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.getMBeanName(), scala.collection.mutable.Set$.MODULE$.canBuildFrom());
        return this.filterByTopicMetricRegex((Set<String>)metricNames, topic);
    }

    private Set<String> topicMetricGroups(String topic) {
        scala.collection.mutable.Set metricGroups = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().groupedMetrics(MetricPredicate.ALL).keySet()).asScala();
        return this.filterByTopicMetricRegex((Set<String>)metricGroups, (Option<String>)new Some((Object)topic));
    }

    private Set<String> filterByTopicMetricRegex(Set<String> metrics, Option<String> topic) {
        if (topic == null) {
            throw null;
        }
        Object object = topic.isEmpty() ? None$.MODULE$ : new Some((Object)MetricsTest.$anonfun$filterByTopicMetricRegex$1((String)topic.get()));
        if (object == null) {
            throw null;
        }
        Object object2 = object.isEmpty() ? MetricsTest.$anonfun$filterByTopicMetricRegex$2() : object.get();
        String string = new StringBuilder(22).append(".*BrokerTopicMetrics.*").append(object2).toString();
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Pattern pattern = new StringOps(string).r().pattern();
        return (Set)metrics.filter((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$filterByTopicMetricRegex$3(pattern, x$18)));
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsUnregisteredAfterDeletingTopic$1(String topic$1, KafkaServer s) {
        Assert.assertNotNull((Object)s.brokerTopicStats().topicStats(topic$1));
    }

    public static final /* synthetic */ boolean $anonfun$testClusterIdMetric$1(MetricName x$2) {
        String string = x$2.getMBeanName();
        String string2 = "kafka.server:type=KafkaServer,name=ClusterId";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerTopicMetricsBytesInOut$3(long x$4) {
        return x$4 > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerTopicMetricsBytesInOut$4() {
        return false;
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsBytesInOut$1(String topic$2, TopicPartition topicPartition$1, KafkaServer server) {
        LogManager qual$1 = server.logManager();
        TopicPartition x$1 = new TopicPartition(topic$2, 0);
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(x$1, x$2);
        int brokerId = server.config().brokerId();
        if (log == null) {
            throw null;
        }
        Object object = log.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)((Log)log.get()).size()));
        if (object == null) {
            throw null;
        }
        Object object2 = object.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testBrokerTopicMetricsBytesInOut$3(BoxesRunTime.unboxToLong((Object)object.get()))));
        if (object2 == null) {
            throw null;
        }
        Object object3 = object2.isEmpty() ? BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testBrokerTopicMetricsBytesInOut$4()) : object2.get();
        Assert.assertTrue((String)new StringBuilder(64).append("Expected broker ").append(brokerId).append(" to have a Log for ").append(topicPartition$1).append(" with positive size, actual: ").append(object).toString(), (boolean)BoxesRunTime.unboxToBoolean((Object)object3));
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$1(MetricName x$5) {
        String string = x$5.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ActiveControllerCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$2(MetricName x$6) {
        String string = x$6.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=OfflinePartitionsCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$3(MetricName x$7) {
        String string = x$7.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=PreferredReplicaImbalanceCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$4(MetricName x$8) {
        String string = x$8.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=GlobalTopicCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$5(MetricName x$9) {
        String string = x$9.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=GlobalPartitionCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$6(MetricName x$10) {
        String string = x$10.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=TopicsToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$7(MetricName x$11) {
        String string = x$11.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ReplicasToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$8(MetricName x$12) {
        String string = x$12.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=TopicsIneligibleToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$9(MetricName x$13) {
        String string = x$13.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ReplicasIneligibleToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$1(MetricName x$14) {
        String string = x$14.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=SessionState";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$2(MetricName x$15) {
        String string = x$15.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=ZooKeeperExpiresPerSec";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$3(MetricName x$16) {
        String string = x$16.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=ZooKeeperDisconnectsPerSec";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ String $anonfun$filterByTopicMetricRegex$1(String t) {
        return new StringBuilder(3).append("(").append(t).append(")$").toString();
    }

    public static final /* synthetic */ String $anonfun$filterByTopicMetricRegex$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$filterByTopicMetricRegex$3(Pattern pattern$1, String x$18) {
        return pattern$1.matcher(x$18).matches();
    }

    public MetricsTest() {
        this.numNodes = 2;
        this.numParts = 2;
        this.overridingProps().put(KafkaConfig$.MODULE$.NumPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.numParts())).toString());
        this.nMessages = 2;
    }

    public static final /* synthetic */ Object $anonfun$testBrokerTopicMetricsBytesInOut$2$adapted(Log x$3) {
        return BoxesRunTime.boxToLong((long)x$3.size());
    }
}

