/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import kafka.server.LogDirFailureChannel;
import kafka.server.PartitionMetadata;
import kafka.server.PartitionMetadataFile$;
import kafka.server.PartitionMetadataFile$PartitionMetadataFileFormatter$;
import kafka.utils.Logging;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005mu!B\u0013'\u0011\u0003Yc!B\u0017'\u0011\u0003q\u0003\"B\u001b\u0002\t\u00031\u0004bB\u001c\u0002\u0005\u0004%I\u0001\u000f\u0005\u0007\u0003\u0006\u0001\u000b\u0011B\u001d\t\u000f\t\u000b!\u0019!C\u0005\u0007\"1A*\u0001Q\u0001\n\u0011Cq!T\u0001C\u0002\u0013%a\n\u0003\u0004S\u0003\u0001\u0006Ia\u0014\u0005\u0006'\u0006!\t\u0001V\u0004\u0006;\u0006A\tA\u0018\u0004\u0006A\u0006A\t!\u0019\u0005\u0006k-!\tA\u0019\u0005\u0006G.!\t\u0001\u001a\u0004\u0005i\u0006\u0001Q\u000f\u0003\u0005~\u001d\t\u0005\t\u0015!\u0003f\u0011!qhB!A!\u0002\u0013y\b\"CA\u0003\u001d\t\u0005\t\u0015!\u0003P\u0011\u0019)d\u0002\"\u0001\u0002\b!9\u0011q\u0005\b\u0005\u0002\u0005%b!B\u0017'\u0001\u0005-\u0002BCA\u0017)\t\u0015\r\u0011\"\u0001\u00020!I\u0011\u0011\u0007\u000b\u0003\u0002\u0003\u0006I!\u0016\u0005\u000b\u0003g!\"\u0011!Q\u0001\n\u0005U\u0002BB\u001b\u0015\t\u0003\tY\u0004C\u0005\u0002DQ\u0011\r\u0011\"\u0003\u0002F!A\u0011Q\u000b\u000b!\u0002\u0013\t9\u0005C\u0005\u0002XQ\u0011\r\u0011\"\u0003\u0002F!A\u0011\u0011\f\u000b!\u0002\u0013\t9\u0005C\u0005\u0002\\Q\u0011\r\u0011\"\u0003\u0002^!A\u0011Q\r\u000b!\u0002\u0013\ty\u0006\u0003\u0005\u0002hQ\u0011\r\u0011\"\u00039\u0011\u001d\tI\u0007\u0006Q\u0001\neBq!a\u001b\u0015\t\u0003\ti\u0007C\u0004\u0002(Q!\t!!\u000b\t\u000f\u0005=E\u0003\"\u0001\u0002\u0012\"9\u0011\u0011\u0014\u000b\u0005\u0002\u0005E\u0015!\u0006)beRLG/[8o\u001b\u0016$\u0018\rZ1uC\u001aKG.\u001a\u0006\u0003O!\naa]3sm\u0016\u0014(\"A\u0015\u0002\u000b-\fgm[1\u0004\u0001A\u0011A&A\u0007\u0002M\t)\u0002+\u0019:uSRLwN\\'fi\u0006$\u0017\r^1GS2,7CA\u00010!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012aK\u0001\u001a!\u0006\u0014H/\u001b;j_:lU\r^1eCR\fg)\u001b7f]\u0006lW-F\u0001:!\tQt(D\u0001<\u0015\taT(\u0001\u0003mC:<'\"\u0001 \u0002\t)\fg/Y\u0005\u0003\u0001n\u0012aa\u0015;sS:<\u0017A\u0007)beRLG/[8o\u001b\u0016$\u0018\rZ1uC\u001aKG.\u001a8b[\u0016\u0004\u0013AE,iSR,7\u000b]1dKN\u0004\u0016\r\u001e;fe:,\u0012\u0001\u0012\t\u0003\u000b*k\u0011A\u0012\u0006\u0003\u000f\"\u000bQA]3hKbT!!S\u001f\u0002\tU$\u0018\u000e\\\u0005\u0003\u0017\u001a\u0013q\u0001U1ui\u0016\u0014h.A\nXQ&$Xm\u00159bG\u0016\u001c\b+\u0019;uKJt\u0007%\u0001\bDkJ\u0014XM\u001c;WKJ\u001c\u0018n\u001c8\u0016\u0003=\u0003\"\u0001\r)\n\u0005E\u000b$aA%oi\u0006y1)\u001e:sK:$h+\u001a:tS>t\u0007%A\u0004oK^4\u0015\u000e\\3\u0015\u0005U[\u0006C\u0001,Z\u001b\u00059&B\u0001->\u0003\tIw.\u0003\u0002[/\n!a)\u001b7f\u0011\u0015a\u0016\u00021\u0001V\u0003\r!\u0017N]\u0001\u001f!\u0006\u0014H/\u001b;j_:lU\r^1eCR\fg)\u001b7f\r>\u0014X.\u0019;uKJ\u0004\"aX\u0006\u000e\u0003\u0005\u0011a\u0004U1si&$\u0018n\u001c8NKR\fG-\u0019;b\r&dWMR8s[\u0006$H/\u001a:\u0014\u0005-yC#\u00010\u0002\rQ|g)\u001b7f)\t)w\u000e\u0005\u0002g[:\u0011qm\u001b\t\u0003QFj\u0011!\u001b\u0006\u0003U*\na\u0001\u0010:p_Rt\u0014B\u000172\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001I\u001c\u0006\u0003YFBQ\u0001]\u0007A\u0002E\fA\u0001Z1uCB\u0011AF]\u0005\u0003g\u001a\u0012\u0011\u0003U1si&$\u0018n\u001c8NKR\fG-\u0019;b\u0005m\u0001\u0016M\u001d;ji&|g.T3uC\u0012\fG/\u0019*fC\u0012\u0014UO\u001a4feV\u0019a/a\u0004\u0014\u00079ys\u000f\u0005\u0002yw6\t\u0011P\u0003\u0002{Q\u0005)Q\u000f^5mg&\u0011A0\u001f\u0002\b\u0019><w-\u001b8h\u0003!awnY1uS>t\u0017A\u0002:fC\u0012,'\u000fE\u0002W\u0003\u0003I1!a\u0001X\u00059\u0011UO\u001a4fe\u0016$'+Z1eKJ\fqA^3sg&|g\u000e\u0006\u0005\u0002\n\u0005\u0005\u00121EA\u0013!\u0011yf\"a\u0003\u0011\t\u00055\u0011q\u0002\u0007\u0001\t\u001d\t\tB\u0004b\u0001\u0003'\u0011\u0011\u0001V\t\u0005\u0003+\tY\u0002E\u00021\u0003/I1!!\u00072\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001MA\u000f\u0013\r\ty\"\r\u0002\u0004\u0003:L\b\"B?\u0013\u0001\u0004)\u0007\"\u0002@\u0013\u0001\u0004y\bBBA\u0003%\u0001\u0007q*\u0001\u0003sK\u0006$G#A9\u0014\u0007Qys/\u0001\u0003gS2,W#A+\u0002\u000b\u0019LG.\u001a\u0011\u0002)1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m!\ra\u0013qG\u0005\u0004\u0003s1#\u0001\u0006'pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G\u000e\u0006\u0004\u0002>\u0005}\u0012\u0011\t\t\u0003YQAa!!\f\u0019\u0001\u0004)\u0006bBA\u001a1\u0001\u0007\u0011QG\u0001\u0005a\u0006$\b.\u0006\u0002\u0002HA!\u0011\u0011JA)\u001b\t\tYE\u0003\u0003\u0002.\u00055#bAA({\u0005\u0019a.[8\n\t\u0005M\u00131\n\u0002\u0005!\u0006$\b.A\u0003qCRD\u0007%\u0001\u0005uK6\u0004\b+\u0019;i\u0003%!X-\u001c9QCRD\u0007%\u0001\u0003m_\u000e\\WCAA0!\rQ\u0014\u0011M\u0005\u0004\u0003GZ$AB(cU\u0016\u001cG/A\u0003m_\u000e\\\u0007%\u0001\u0004m_\u001e$\u0015N]\u0001\bY><G)\u001b:!\u0003\u00159(/\u001b;f)\u0011\ty'!\u001e\u0011\u0007A\n\t(C\u0002\u0002tE\u0012A!\u00168ji\"9\u0011qO\u0011A\u0002\u0005e\u0014a\u0002;pa&\u001c\u0017\n\u001a\t\u0005\u0003w\nY)\u0004\u0002\u0002~)!\u0011qPAA\u0003\u0019\u0019w.\\7p]*\u0019\u0011&a!\u000b\t\u0005\u0015\u0015qQ\u0001\u0007CB\f7\r[3\u000b\u0005\u0005%\u0015aA8sO&!\u0011QRA?\u0005\u0011)V/\u001b3\u0002\r\u0015D\u0018n\u001d;t)\t\t\u0019\nE\u00021\u0003+K1!a&2\u0005\u001d\u0011un\u001c7fC:\fa\u0001Z3mKR,\u0007")
public class PartitionMetadataFile
implements Logging {
    private final File file;
    private final LogDirFailureChannel logDirFailureChannel;
    private final Path path;
    private final Path tempPath;
    private final Object lock;
    private final String logDir;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static File newFile(File file) {
        return PartitionMetadataFile$.MODULE$.newFile(file);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File file() {
        return this.file;
    }

    private Path path() {
        return this.path;
    }

    private Path tempPath() {
        return this.tempPath;
    }

    private Object lock() {
        return this.lock;
    }

    private String logDir() {
        return this.logDir;
    }

    public void write(Uuid topicId) {
        Object object = this.lock();
        synchronized (object) {
            this.liftedTree1$1(topicId);
            return;
        }
    }

    public PartitionMetadata read() {
        Object object = this.lock();
        synchronized (object) {
            PartitionMetadata partitionMetadata = this.liftedTree2$1();
            return partitionMetadata;
        }
    }

    public boolean exists() {
        return this.file().exists();
    }

    public boolean delete() {
        return this.file().delete();
    }

    private final /* synthetic */ void liftedTree1$1(Uuid topicId$1) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.tempPath().toFile());
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8));){
                writer.write(PartitionMetadataFile$PartitionMetadataFileFormatter$.MODULE$.toFile(new PartitionMetadata(PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$CurrentVersion(), topicId$1)));
                writer.flush();
                fileOutputStream.getFD().sync();
            }
            Utils.atomicMoveWithFallback((Path)this.tempPath(), (Path)this.path());
            return;
        }
        catch (IOException e) {
            String msg = new StringBuilder(47).append("Error while writing to partition metadata file ").append(this.file().getAbsolutePath()).toString();
            this.logDirFailureChannel.maybeAddOfflineLogDir(this.logDir(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg, e);
            throw new KafkaStorageException(msg, (Throwable)e);
        }
    }

    private final /* synthetic */ PartitionMetadata liftedTree2$1() {
        try {
            PartitionMetadata partitionMetadata;
            try (BufferedReader reader = Files.newBufferedReader(this.path());){
                partitionMetadata = new PartitionMetadataReadBuffer(this.file().getAbsolutePath(), reader, PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$CurrentVersion()).read();
            }
            return partitionMetadata;
        }
        catch (IOException e) {
            String msg = new StringBuilder(44).append("Error while reading partition metadata file ").append(this.file().getAbsolutePath()).toString();
            this.logDirFailureChannel.maybeAddOfflineLogDir(this.logDir(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg, e);
            throw new KafkaStorageException(msg, (Throwable)e);
        }
    }

    public PartitionMetadataFile(File file, LogDirFailureChannel logDirFailureChannel) {
        this.file = file;
        this.logDirFailureChannel = logDirFailureChannel;
        Logging.$init$(this);
        this.path = file.toPath().toAbsolutePath();
        this.tempPath = Paths.get(new StringBuilder(4).append(((Object)this.path()).toString()).append(".tmp").toString(), new String[0]);
        this.lock = new Object();
        this.logDir = file.getParentFile().getParent();
    }

    public static class PartitionMetadataReadBuffer<T>
    implements Logging {
        private final String location;
        private final BufferedReader reader;
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return Logging.loggerName$(this);
        }

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public PartitionMetadata read() {
            String line = null;
            try {
                line = this.reader.readLine();
                String[] stringArray = PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$WhiteSpacesPattern().split(line);
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (option.isEmpty()) throw this.malformedLineException$1(line);
                if (option.get() == null) throw this.malformedLineException$1(line);
                if (((SeqLike)option.get()).lengthCompare(2) != 0) throw this.malformedLineException$1(line);
                String version = (String)((SeqLike)option.get()).apply(1);
                if (new StringOps(Predef$.MODULE$.augmentString(version)).toInt() != PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$CurrentVersion()) throw new IOException(new StringBuilder(52).append("Unrecognized version of partition metadata file (").append(this.location).append("): ").append(version).toString());
                line = this.reader.readLine();
                String[] stringArray2 = PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$WhiteSpacesPattern().split(line);
                Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray2);
                if (option2.isEmpty()) throw this.malformedLineException$1(line);
                if (option2.get() == null) throw this.malformedLineException$1(line);
                if (((SeqLike)option2.get()).lengthCompare(2) != 0) throw this.malformedLineException$1(line);
                Uuid metadataTopicId = Uuid.fromString((String)((String)((SeqLike)option2.get()).apply(1)));
                if (!metadataTopicId.equals((Object)Uuid.ZERO_UUID)) return new PartitionMetadata(PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$CurrentVersion(), metadataTopicId);
                throw new IOException(new StringBuilder(46).append("Invalid topic ID in partition metadata file (").append(this.location).append(")").toString());
            }
            catch (NumberFormatException numberFormatException) {
                throw this.malformedLineException$1(line);
            }
        }

        private final IOException malformedLineException$1(String line) {
            return new IOException(new StringBuilder(40).append("Malformed line in checkpoint file (").append(this.location).append("): '").append(line).append("'").toString());
        }

        public PartitionMetadataReadBuffer(String location, BufferedReader reader, int version) {
            this.location = location;
            this.reader = reader;
            Logging.$init$(this);
        }
    }
}

