/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.ToolsUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import scala.;
import scala.$less$colon$less$;
import scala.Console$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class GetOffsetShell$ {
    public static final GetOffsetShell$ MODULE$ = new GetOffsetShell$();

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        void sortBy$extension_ord;
        scala.collection.mutable.Map map;
        Set set;
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec brokerListOpt = parser.accepts("broker-list", "REQUIRED: The list of hostname and port of the server to connect to.").withRequiredArg().describedAs("hostname:port,...,hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec topicOpt = parser.accepts("topic", "REQUIRED: The topic to get offset from.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec partitionOpt = parser.accepts("partitions", "comma separated list of partition ids. If not specified, it will find offsets for all partitions").withRequiredArg().describedAs("partition ids").ofType(String.class).defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec timeOpt = parser.accepts("time", "timestamp of the offsets before that. [Note: No offset is returned, if the timestamp greater than recently commited record timestamp is given.]").withRequiredArg().describedAs("timestamp/-1(latest)/-2(earliest)").ofType(Long.class).defaultsTo((Object)-1L, (Object[])new Long[0]);
        parser.accepts("offsets", "DEPRECATED AND IGNORED: number of offsets returned").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)1, (Object[])new Integer[0]);
        parser.accepts("max-wait-ms", "DEPRECATED AND IGNORED: The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)1000, (Object[])new Integer[0]);
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "An interactive shell for getting topic offsets.");
        }
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (scala.collection.immutable.Seq<OptionSpec<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{brokerListOpt, topicOpt}));
        String clientId = "GetOffsetShell";
        String brokerList = (String)options.valueOf((OptionSpec)brokerListOpt);
        ToolsUtils$.MODULE$.validatePortOrDie(parser, brokerList);
        String topic = (String)options.valueOf((OptionSpec)topicOpt);
        String partitionsString = (String)options.valueOf((OptionSpec)partitionOpt);
        if (partitionsString.isEmpty()) {
            set = Predef$.MODULE$.Set().empty();
        } else {
            Set set2;
            Object var28_16;
            int[] nArray;
            int[] nArray2;
            String[] map$extension_$this = partitionsString.split(",");
            int n = map$extension_$this.length;
            int[] nArray3 = nArray2 = new int[n];
            nArray2 = null;
            int[] nArray4 = nArray = nArray3;
            nArray = null;
            int[] map$extension_ys = nArray4;
            if (n > 0) {
                for (int map$extension_i = 0; map$extension_i < n; ++map$extension_i) {
                    int n2;
                    String string = map$extension_$this[map$extension_i];
                    map$extension_ys[map$extension_i] = n2 = GetOffsetShell$.$anonfun$main$1(partitionsString, string);
                }
            }
            void v3 = var28_16;
            Object var27_12 = null;
            var28_16 = null;
            ArraySeq.ofInt ofInt2 = Predef$.MODULE$.wrapIntArray((int[])v3);
            if (ofInt2 == null) {
                throw null;
            }
            ArraySeq.ofInt toSet_this = ofInt2;
            set = set2 = IterableOnceOps.toSet$((IterableOnceOps)toSet_this);
            Object var25_20 = null;
            set2 = null;
        }
        Set partitionIdsRequested = set;
        long listOffsetsTimestamp = (Long)options.valueOf((OptionSpec)timeOpt);
        Properties config = new Properties();
        config.setProperty("bootstrap.servers", brokerList);
        config.setProperty("client.id", clientId);
        KafkaConsumer consumer = new KafkaConsumer(config, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        boolean bl = false;
        Some some = null;
        Option<Seq<PartitionInfo>> option = this.listPartitionInfos(consumer, topic, (Set<Object>)partitionIdsRequested);
        if (None$.MODULE$.equals(option)) {
            System.err.println(new StringBuilder(21).append("Topic ").append(topic).append(" does not exist").toString());
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            if (((Seq)some.value()).isEmpty()) {
                if (partitionIdsRequested.isEmpty()) {
                    System.err.println(new StringBuilder(23).append("Topic ").append(topic).append(" has 0 partitions").toString());
                } else {
                    String mkString_sep = ",";
                    Object var24_29 = null;
                    System.err.println(new StringBuilder(53).append("Topic ").append(topic).append(" does not have any of the requested partitions ").append(partitionIdsRequested.mkString("", mkString_sep, "")).toString());
                }
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
        }
        if (!bl) {
            throw new MatchError(option);
        }
        Seq seq = (Seq)some.value();
        if (partitionIdsRequested.nonEmpty()) {
            partitionIdsRequested.$minus$minus((IterableOnce)seq.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.partition()))).foreach((Function1)(JFunction1.mcVI.sp & Serializable)partitionId -> System.err.println(new StringBuilder(32).append("Error: partition ").append(partitionId).append(" does not exist").toString()));
        }
        Seq topicPartitions = (Seq)((IterableOps)seq.sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.partition()), (Ordering)Ordering.Int$.MODULE$)).flatMap((Function1 & Serializable)p -> {
            if (p.leader() == null) {
                System.err.println(new StringBuilder(62).append("Error: partition ").append(p.partition()).append(" does not have a leader. Skip getting offsets").toString());
                return None$.MODULE$;
            }
            return new Some((Object)new TopicPartition(p.topic(), p.partition()));
        });
        if (-2L == listOffsetsTimestamp) {
            map = AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)consumer.beginningOffsets((Collection)AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)topicPartitions).asJava())).asScala();
        } else if (-1L == listOffsetsTimestamp) {
            map = AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)consumer.endOffsets((Collection)AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)topicPartitions).asJava())).asScala();
        } else {
            java.util.Map timestampsToSearch = AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((IterableOnceOps)topicPartitions.map((Function1 & Serializable)tp -> {
                Long l;
                Long l2 = l = Long.valueOf(listOffsetsTimestamp);
                l = null;
                Long $minus$greater$extension_y = l2;
                return new Tuple2(tp, (Object)$minus$greater$extension_y);
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
            map = (Map)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)consumer.offsetsForTimes(timestampsToSearch)).asScala().map((Function1 & Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                TopicPartition k = (TopicPartition)x0$1._1();
                OffsetAndTimestamp x = (OffsetAndTimestamp)x0$1._2();
                Tuple2 tuple2 = x == null ? new Tuple2((Object)k, null) : new Tuple2((Object)k, (Object)x.offset());
                return tuple2;
            });
        }
        Ordering.Int$ int$ = Ordering.Int$.MODULE$;
        Function1 & Serializable sortBy$extension_f = (Function1 & Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)GetOffsetShell$.$anonfun$main$8(x0$2));
        Object var31_35 = null;
        int$ = null;
        Object[] foreach$extension_$this = (Object[])ArrayOps$.MODULE$.sorted$extension((Object)((Object[])map.toArray(ClassTag$.MODULE$.apply(Tuple2.class))), (Ordering)new /* Unavailable Anonymous Inner Class!! */);
        int n = foreach$extension_$this.length;
        for (int foreach$extension_i = 0; foreach$extension_i < n; ++foreach$extension_i) {
            Tuple2 tuple2 = (Tuple2)foreach$extension_$this[foreach$extension_i];
            GetOffsetShell$.$anonfun$main$9(topic, tuple2);
        }
    }

    private Option<Seq<PartitionInfo>> listPartitionInfos(KafkaConsumer<?, ?> consumer, String topic, Set<Object> partitionIds) {
        IterableOnceOps iterableOnceOps = (IterableOnceOps)((MapOps)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)consumer.listTopics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)GetOffsetShell$.$anonfun$listPartitionInfos$1(topic, x0$1)))).values().flatMap((Function1 & Serializable)x$3 -> AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (List)x$3).asScala());
        if (iterableOnceOps == null) {
            throw null;
        }
        IterableOnceOps toBuffer_this = iterableOnceOps;
        Object var5_4 = null;
        Buffer partitionInfos = (Buffer)Buffer$.MODULE$.from((IterableOnce)toBuffer_this);
        if (partitionInfos.isEmpty()) {
            return None$.MODULE$;
        }
        if (partitionIds.isEmpty()) {
            return new Some((Object)partitionInfos);
        }
        return new Some(partitionInfos.filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)partitionIds.contains((Object)p.partition()))));
    }

    public static final /* synthetic */ int $anonfun$main$1(String partitionsString$1, String partitionString) {
        try {
            return Integer.parseInt(partitionString);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(new StringBuilder(84).append("--partitions expects a comma separated list of numeric partition ids, but received: ").append(partitionsString$1).toString());
            throw Exit$.MODULE$.exit(1, (Option<String>)None$.MODULE$);
        }
    }

    public static final /* synthetic */ int $anonfun$main$8(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        int n = ((TopicPartition)x0$2._1()).partition();
        return n;
    }

    public static final /* synthetic */ String $anonfun$main$10() {
        return "";
    }

    public static final /* synthetic */ void $anonfun$main$9(String topic$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            Object object;
            TopicPartition tp = (TopicPartition)x0$3._1();
            Long offset = (Long)x0$3._2();
            StringBuilder stringBuilder = new StringBuilder(2).append(topic$1).append(":").append(tp.partition()).append(":");
            Option option = Option$.MODULE$.apply((Object)offset);
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            if (getOrElse_this.isEmpty()) {
                String string;
                String string2 = string = "";
                string = null;
                object = string2;
            } else {
                object = getOrElse_this.get();
            }
            Object object2 = object;
            Object var4_4 = null;
            object = null;
            String println_x = stringBuilder.append(object2).toString();
            Console$.MODULE$.println((Object)println_x);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$listPartitionInfos$1(String topic$2, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String string = (String)x0$1._1();
        boolean bl = !(string != null ? !string.equals(topic$2) : topic$2 != null);
        return bl;
    }

    private GetOffsetShell$() {
    }

    public static final /* synthetic */ Object $anonfun$main$1$adapted(String partitionsString$1, String partitionString) {
        return BoxesRunTime.boxToInteger((int)GetOffsetShell$.$anonfun$main$1(partitionsString$1, partitionString));
    }

    public static final /* synthetic */ Object $anonfun$main$9$adapted(String topic$1, Tuple2 x0$3) {
        GetOffsetShell$.$anonfun$main$9(topic$1, x0$3);
        return BoxedUnit.UNIT;
    }
}

