/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import kafka.api.IntegrationTestHarness;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005E2Aa\u0002\u0005\u0001\u001b!)!\u0003\u0001C\u0001'!9Q\u0003\u0001b\u0001\n\u00031\u0002BB\u000f\u0001A\u0003%q\u0003C\u0004\u001f\u0001\t\u0007I\u0011\u0001\f\t\r}\u0001\u0001\u0015!\u0003\u0018\u0011\u0015\u0001\u0003\u0001\"\u0001\"\u0005u\u0001&o\u001c3vG\u0016\u00148+\u001a8e/\"LG.\u001a#fY\u0016$\u0018n\u001c8UKN$(BA\u0005\u000b\u0003\r\t\u0007/\u001b\u0006\u0002\u0017\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u000f!\ty\u0001#D\u0001\t\u0013\t\t\u0002B\u0001\fJ]R,wM]1uS>tG+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\tA\u0003\u0005\u0002\u0010\u0001\u0005i\u0001O]8ek\u000e,'oQ8v]R,\u0012a\u0006\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8-\u001a:D_VtG\u000fI\u0001\fEJ|7.\u001a:D_VtG/\u0001\u0007ce>\\WM]\"pk:$\b%A\u0010uKN$8+\u001a8e/&$\b\u000eV8qS\u000e$U\r\\3uS>tW*\u001b3XCf$\u0012A\t\t\u00031\rJ!\u0001J\r\u0003\tUs\u0017\u000e\u001e\u0015\u0003\r\u0019\u0002\"aJ\u0018\u000e\u0003!R!!C\u0015\u000b\u0005)Z\u0013a\u00026va&$XM\u001d\u0006\u0003Y5\nQA[;oSRT\u0011AL\u0001\u0004_J<\u0017B\u0001\u0019)\u0005\u0011!Vm\u001d;")
public class ProducerSendWhileDeletionTest
extends IntegrationTestHarness {
    private final int producerCount;
    private final int brokerCount;

    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    @Test
    public void testSendWithTopicDeletionMidWay() {
        int numRecords = 10;
        String topic = "topic";
        this.createTopic(topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})))}))));
        scala.collection.immutable.Map reassignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, 0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, 1)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0})))}));
        this.zkClient().createPartitionReassignment((Map)reassignment);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ProducerSendWhileDeletionTest.$anonfun$testSendWithTopicDeletionMidWay$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"failed to remove reassign partitions path after completion");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            RecordMetadata resp = (RecordMetadata)producer.send(new ProducerRecord(topic, null, (Object)new StringBuilder(5).append("value").append(i).toString().getBytes(StandardCharsets.UTF_8))).get();
            Assertions.assertEquals((Object)topic, (Object)resp.topic());
        });
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 2, (Seq<KafkaServer>)this.servers());
        Assertions.assertEquals((Object)topic, (Object)((RecordMetadata)producer.send(new ProducerRecord(topic, null, (Object)"value".getBytes(StandardCharsets.UTF_8))).get()).topic());
    }

    public static final /* synthetic */ boolean $anonfun$testSendWithTopicDeletionMidWay$1(ProducerSendWhileDeletionTest $this) {
        return !$this.zkClient().reassignPartitionsInProgress();
    }

    public static final /* synthetic */ String $anonfun$testSendWithTopicDeletionMidWay$2() {
        return "failed to remove reassign partitions path after completion";
    }

    public ProducerSendWhileDeletionTest() {
        this.producerCount = 1;
        this.brokerCount = 2;
        this.serverConfig().put(KafkaConfig$.MODULE$.NumPartitionsProp(), Integer.toString(2));
        this.serverConfig().put(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), Integer.toString(2));
        this.serverConfig().put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), Boolean.toString(false));
        this.producerConfig().put("max.block.ms", Long.toString(5000L));
        this.producerConfig().put("request.timeout.ms", Integer.toString(10000));
        this.producerConfig().put("delivery.timeout.ms", Integer.toString(10000));
    }
}

