/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.auth;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import javax.security.auth.login.Configuration;
import kafka.admin.ZkSecurityMigrator$;
import kafka.api.ApiVersion$;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.controller.ReplicaAssignment;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.BrokerInfo;
import kafka.zk.BrokerInfo$;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import kafka.zk.TopicZNode$;
import kafka.zk.ZkData$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015g\u0001\u0002\r\u001a\u0001\u0001BQ!\f\u0001\u0005\u00029Bq!\r\u0001C\u0002\u0013\u0005!\u0007\u0003\u0004<\u0001\u0001\u0006Ia\r\u0005\by\u0001\u0011\r\u0011\"\u0001>\u0011\u0019!\u0005\u0001)A\u0005}!)Q\t\u0001C!\r\")!\f\u0001C!\r\")q\f\u0001C\u0001\r\")A\r\u0001C\u0001\r\")a\r\u0001C\u0005O\"I\u0011\u0011\u0005\u0001\u0012\u0002\u0013%\u00111\u0005\u0005\b\u0003s\u0001A\u0011BA\u001e\u0011\u0019\t\t\u0006\u0001C\u0001\r\"1\u0011Q\u000b\u0001\u0005\u0002\u0019Ca!!\u0017\u0001\t\u00031\u0005BBA/\u0001\u0011\u0005a\t\u0003\u0004\u0002b\u0001!\tA\u0012\u0005\b\u0003K\u0002A\u0011BA4\u0011\u001d\t)\b\u0001C\u0005\u0003oBq!! \u0001\t\u0013\ty\b\u0003\u0004\u0002*\u0002!IA\u0012\u0005\b\u0003W\u0003A\u0011BAW\u0011\u0019\t\t\r\u0001C\u0001\r\n\u0019\"l[!vi\"|'/\u001b>bi&|g\u000eV3ti*\u0011!dG\u0001\u0005CV$\bN\u0003\u0002\u001d;\u0005A1/Z2ve&$\u0018PC\u0001\u001f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\u0011(!\t\u0011S%D\u0001$\u0015\t!S$\u0001\u0002{W&\u0011ae\t\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0011\u0005!ZS\"A\u0015\u000b\u0005)j\u0012!B;uS2\u001c\u0018B\u0001\u0017*\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A\u0018\u0011\u0005A\u0002Q\"A\r\u0002\u0011)\f\u0017m\u001d$jY\u0016,\u0012a\r\t\u0003iej\u0011!\u000e\u0006\u0003m]\n!![8\u000b\u0003a\nAA[1wC&\u0011!(\u000e\u0002\u0005\r&dW-A\u0005kC\u0006\u001ch)\u001b7fA\u0005a\u0011-\u001e;i!J|g/\u001b3feV\ta\b\u0005\u0002@\u00056\t\u0001I\u0003\u0002Bo\u0005!A.\u00198h\u0013\t\u0019\u0005I\u0001\u0004TiJLgnZ\u0001\u000eCV$\b\u000e\u0015:pm&$WM\u001d\u0011\u0002\u000bM,G/\u00169\u0015\u0003\u001d\u0003\"\u0001S&\u000e\u0003%S\u0011AS\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0019&\u0013A!\u00168ji\"\u0012aA\u0014\t\u0003\u001fbk\u0011\u0001\u0015\u0006\u0003#J\u000b1!\u00199j\u0015\t\u0019F+A\u0004kkBLG/\u001a:\u000b\u0005U3\u0016!\u00026v]&$(\"A,\u0002\u0007=\u0014x-\u0003\u0002Z!\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D#a\u0002/\u0011\u0005=k\u0016B\u00010Q\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\fuKN$\u0018j\u001d.l'\u0016\u001cWO]5us\u0016s\u0017M\u00197fI\"\u0012\u0001\"\u0019\t\u0003\u001f\nL!a\u0019)\u0003\tQ+7\u000f^\u0001\u0012i\u0016\u001cHoS1gW\u0006T6n\u00117jK:$\bFA\u0005b\u0003A\u0019'/Z1uK\n\u0013xn[3s\u0013:4w\u000eF\u0004iWBdh0a\u0006\u0011\u0005\tJ\u0017B\u00016$\u0005)\u0011%o\\6fe&sgm\u001c\u0005\u0006Y*\u0001\r!\\\u0001\u0003S\u0012\u0004\"\u0001\u00138\n\u0005=L%aA%oi\")\u0011O\u0003a\u0001e\u0006!\u0001n\\:u!\t\u0019(P\u0004\u0002uqB\u0011Q/S\u0007\u0002m*\u0011qoH\u0001\u0007yI|w\u000e\u001e \n\u0005eL\u0015A\u0002)sK\u0012,g-\u0003\u0002Dw*\u0011\u00110\u0013\u0005\u0006{*\u0001\r!\\\u0001\u0005a>\u0014H\u000f\u0003\u0004\u0000\u0015\u0001\u0007\u0011\u0011A\u0001\u0011g\u0016\u001cWO]5usB\u0013x\u000e^8d_2\u0004B!a\u0001\u0002\u00145\u0011\u0011Q\u0001\u0006\u00045\u0005\u001d!b\u0001\u000f\u0002\n)!\u00111BA\u0007\u0003\u0019\u0019w.\\7p]*\u0019a$a\u0004\u000b\u0007\u0005Ea+\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003+\t)A\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\"I\u0011\u0011\u0004\u0006\u0011\u0002\u0003\u0007\u00111D\u0001\u0005e\u0006\u001c7\u000e\u0005\u0003I\u0003;\u0011\u0018bAA\u0010\u0013\n1q\n\u001d;j_:\f!d\u0019:fCR,'I]8lKJLeNZ8%I\u00164\u0017-\u001e7uIU*\"!!\n+\t\u0005m\u0011qE\u0016\u0003\u0003S\u0001B!a\u000b\u000265\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$A\u0005v]\u000eDWmY6fI*\u0019\u00111G%\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00028\u00055\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0001b.Z<LC\u001a\\\u0017MW6DY&,g\u000e\u001e\u000b\u0007\u0003{\t\u0019%a\u0012\u0011\u0007\t\ny$C\u0002\u0002B\r\u0012QbS1gW\u0006T6n\u00117jK:$\bBBA#\u0019\u0001\u0007!/\u0001\td_:tWm\u0019;j_:\u001cFO]5oO\"9\u0011\u0011\n\u0007A\u0002\u0005-\u0013\u0001C5t'\u0016\u001cWO]3\u0011\u0007!\u000bi%C\u0002\u0002P%\u0013qAQ8pY\u0016\fg.A\buKN$(l['jOJ\fG/[8oQ\ti\u0011-A\nuKN$(l[!oi&l\u0015n\u001a:bi&|g\u000e\u000b\u0002\u000fC\u0006QA/Z:u\t\u0016dW\r^3)\u0005=\t\u0017a\u0005;fgR$U\r\\3uKJ+7-\u001e:tSZ,\u0007F\u0001\tb\u0003)!Xm\u001d;DQJ|w\u000e\u001e\u0015\u0003#\u0005\fQ\u0002^3ti6KwM]1uS>tGcB$\u0002j\u00055\u0014\u0011\u000f\u0005\u0007\u0003W\u0012\u0002\u0019\u0001:\u0002\u000bi\\WK\u001d7\t\u000f\u0005=$\u00031\u0001\u0002>\u00059a-\u001b:tij[\u0007bBA:%\u0001\u0007\u0011QH\u0001\tg\u0016\u001cwN\u001c3[W\u00061a/\u001a:jMf$2aRA=\u0011\u0019\tYh\u0005a\u0001e\u0006!\u0001/\u0019;i\u00031I7/Q2m\u0007>\u0014(/Z2u)!\tY%!!\u0002\"\u0006\u0015\u0006bBAB)\u0001\u0007\u0011QQ\u0001\u0005Y&\u001cH\u000f\u0005\u0004\u0002\b\u00065\u0015\u0011S\u0007\u0003\u0003\u0013S1!a#J\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001f\u000bIIA\u0002TKF\u0004B!a%\u0002\u001e6\u0011\u0011Q\u0013\u0006\u0005\u0003/\u000bI*\u0001\u0003eCR\f'\u0002BAN\u0003\u001f\t\u0011B_8pW\u0016,\u0007/\u001a:\n\t\u0005}\u0015Q\u0013\u0002\u0004\u0003\u000ec\u0005bBAR)\u0001\u0007\u00111J\u0001\u0007g\u0016\u001cWO]3\t\u000f\u0005\u001dF\u00031\u0001\u0002L\u0005I1/\u001a8tSRLg/Z\u0001\u0012I\u0016dW\r^3BY2,fn]3dkJ,\u0017a\u00043fY\u0016$XMU3dkJ\u001c\u0018N^3\u0015\r\u0005=\u00161XA`!\u0019\t\t,a.\u0002L5\u0011\u00111\u0017\u0006\u0004\u0003kK\u0015\u0001B;uS2LA!!/\u00024\n\u0019AK]=\t\u000f\u0005uf\u00031\u0001\u0002>\u0005A!p[\"mS\u0016tG\u000f\u0003\u0004\u0002|Y\u0001\rA]\u0001\u001bi\u0016\u001cHoQ8ogVlWM](gMN,G\u000fU1uQ\u0006\u001bGn\u001d\u0015\u0003/\u0005\u0004")
public class ZkAuthorizationTest
extends ZooKeeperTestHarness {
    private final File jaasFile = JaasTestUtils$.MODULE$.writeJaasContextsToFile(JaasTestUtils$.MODULE$.zkSections());
    private final String authProvider;

    public File jaasFile() {
        return this.jaasFile;
    }

    public String authProvider() {
        return this.authProvider;
    }

    @Override
    @BeforeEach
    public void setUp() {
        System.setProperty("java.security.auth.login.config", this.jaasFile().getAbsolutePath());
        Configuration.setConfiguration(null);
        System.setProperty(this.authProvider(), "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        System.clearProperty("java.security.auth.login.config");
        System.clearProperty(this.authProvider());
        Configuration.setConfiguration(null);
    }

    @Test
    public void testIsZkSecurityEnabled() {
        Assertions.assertTrue((boolean)JaasUtils.isZkSaslEnabled());
        Configuration.setConfiguration(null);
        System.clearProperty("java.security.auth.login.config");
        Assertions.assertFalse((boolean)JaasUtils.isZkSaslEnabled());
        Configuration.setConfiguration(null);
        System.setProperty("java.security.auth.login.config", "no-such-file-exists.conf");
        Assertions.assertThrows(KafkaException.class, () -> JaasUtils.isZkSaslEnabled());
    }

    @Test
    public void testKafkaZkClient() {
        Assertions.assertTrue((boolean)this.zkClient().secure());
        ZkData$.MODULE$.PersistentZkPaths().foreach((Function1 & Serializable)path -> {
            ZkAuthorizationTest.$anonfun$testKafkaZkClient$1(this, path);
            return BoxedUnit.UNIT;
        });
        BrokerInfo brokerInfo = this.createBrokerInfo(1, "test.host", 9999, SecurityProtocol.PLAINTEXT, (Option<String>)None$.MODULE$);
        this.zkClient().registerBroker(brokerInfo);
        this.verify(brokerInfo.path());
        String topic1 = "topic1";
        Some topicId = new Some((Object)Uuid.randomUuid());
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic1, 0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic1, 1)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic1, 2)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}));
        this.zkClient().createTopicAssignment(topic1, (Option)topicId, (Map)assignment);
        this.verify(TopicZNode$.MODULE$.path(topic1));
        String seqPath = this.zkClient().createSequentialPersistentPath("/c", "".getBytes(StandardCharsets.UTF_8));
        this.verify(seqPath);
        BrokerInfo updatedBrokerInfo = this.createBrokerInfo(1, "test.host2", 9995, SecurityProtocol.SSL, (Option<String>)None$.MODULE$);
        this.zkClient().updateBrokerInfo(updatedBrokerInfo);
        Assertions.assertEquals((Object)new Some((Object)updatedBrokerInfo.broker()), (Object)this.zkClient().getBroker(1));
        scala.collection.immutable.Map updatedAssignment = (scala.collection.immutable.Map)assignment.$minus((Object)new TopicPartition(topic1, 2));
        KafkaZkClient qual$1 = this.zkClient();
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)updatedAssignment.map((Function1 & Serializable)x0$1 -> {
            void apply_removingReplicas;
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$1._1();
            Seq v = (Seq)x0$1._2();
            Seq seq = (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
            Seq apply_addingReplicas = (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
            Object var4_4 = null;
            seq = null;
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)new ReplicaAssignment(v, apply_addingReplicas, (Seq)apply_removingReplicas));
            return tuple2;
        });
        int x$4 = qual$1.setTopicAssignment$default$4();
        qual$1.setTopicAssignment(topic1, (Option)topicId, (Map)x$3, x$4);
        Assertions.assertEquals((int)updatedAssignment.size(), (int)BoxesRunTime.unboxToInt((Object)this.zkClient().getTopicPartitionCount(topic1).get()));
    }

    private BrokerInfo createBrokerInfo(int id, String host, int port, SecurityProtocol securityProtocol, Option<String> rack) {
        return BrokerInfo$.MODULE$.apply(Broker$.MODULE$.apply(id, (Seq)new .colon.colon((Object)new EndPoint(host, port, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol), (List)Nil$.MODULE$), rack), ApiVersion$.MODULE$.latestVersion(), port + 10);
    }

    private Option<String> createBrokerInfo$default$5() {
        return None$.MODULE$;
    }

    private KafkaZkClient newKafkaZkClient(String connectionString, boolean isSecure) {
        return KafkaZkClient$.MODULE$.apply(connectionString, isSecure, 6000, 6000, Integer.MAX_VALUE, Time.SYSTEM, "ZkAuthorizationTest", new ZKClientConfig(), "kafka.server", "SessionExpireListener", false);
    }

    @Test
    public void testZkMigration() {
        try (KafkaZkClient unsecureZkClient = this.newKafkaZkClient(this.zkConnect(), false);){
            this.testMigration(this.zkConnect(), unsecureZkClient, this.zkClient());
        }
    }

    @Test
    public void testZkAntiMigration() {
        try (KafkaZkClient unsecureZkClient = this.newKafkaZkClient(this.zkConnect(), false);){
            this.testMigration(this.zkConnect(), this.zkClient(), unsecureZkClient);
        }
    }

    @Test
    public void testDelete() {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(18).append("zkConnect string: ").append(this.zkConnect()).toString());
        ZkSecurityMigrator$.MODULE$.run(new String[]{"--zookeeper.acl=secure", new StringBuilder(20).append("--zookeeper.connect=").append(this.zkConnect()).toString()});
        this.deleteAllUnsecure();
    }

    @Test
    public void testDeleteRecursive() {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(18).append("zkConnect string: ").append(this.zkConnect()).toString());
        ZkData$.MODULE$.SecureRootPaths().foreach((Function1 & Serializable)path -> {
            ZkAuthorizationTest.$anonfun$testDeleteRecursive$2(this, path);
            return BoxedUnit.UNIT;
        });
        this.zkClient().setAcl("/", this.zkClient().defaultAcls("/"));
        this.deleteAllUnsecure();
    }

    @Test
    public void testChroot() {
        String zkUrl = new StringBuilder(6).append(this.zkConnect()).append("/kafka").toString();
        KafkaZkClient qual$1 = this.zkClient();
        byte[] x$2 = qual$1.createRecursive$default$2();
        boolean x$3 = qual$1.createRecursive$default$3();
        qual$1.createRecursive("/kafka", x$2, x$3);
        KafkaZkClient unsecureZkClient = this.newKafkaZkClient(zkUrl, false);
        KafkaZkClient secureZkClient = this.newKafkaZkClient(zkUrl, true);
        try {
            this.testMigration(zkUrl, unsecureZkClient, secureZkClient);
        }
        finally {
            unsecureZkClient.close();
            secureZkClient.close();
        }
    }

    private void testMigration(String zkUrl, KafkaZkClient firstZk, KafkaZkClient secondZk) {
        String string;
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(18).append("zkConnect string: ").append(zkUrl).toString());
        ((IterableOnceOps)ZkData$.MODULE$.SecureRootPaths().$plus$plus((IterableOnce)ZkData$.MODULE$.SensitiveRootPaths())).foreach((Function1 & Serializable)path -> {
            ZkAuthorizationTest.$anonfun$testMigration$2(this, firstZk, path);
            return BoxedUnit.UNIT;
        });
        if (secondZk.secure()) {
            firstZk.createRecursive("/consumers", firstZk.createRecursive$default$2(), firstZk.createRecursive$default$3());
            string = "secure";
        } else {
            secondZk.createRecursive("/consumers", secondZk.createRecursive$default$2(), secondZk.createRecursive$default$3());
            string = "unsecure";
        }
        String secureOpt = string;
        ZkSecurityMigrator$.MODULE$.run(new String[]{new StringBuilder(16).append("--zookeeper.acl=").append(secureOpt).toString(), new StringBuilder(20).append("--zookeeper.connect=").append(zkUrl).toString()});
        this.info((Function0<String>)(Function0 & Serializable)() -> "Done with migration");
        ((IterableOnceOps)ZkData$.MODULE$.SecureRootPaths().$plus$plus((IterableOnce)ZkData$.MODULE$.SensitiveRootPaths())).foreach((Function1 & Serializable)path -> {
            ZkAuthorizationTest.$anonfun$testMigration$5(this, secondZk, path);
            return BoxedUnit.UNIT;
        });
        Seq consumersAcl = firstZk.getAcl("/consumers");
        Assertions.assertTrue((boolean)this.isAclCorrect((Seq<ACL>)consumersAcl, false, false), (String)"/consumers");
        Assertions.assertTrue((boolean)this.isAclCorrect((Seq<ACL>)firstZk.getAcl("/kafka-acl-extended"), secondZk.secure(), ZkData$.MODULE$.sensitivePath("/kafka-acl-extended")), (String)"/kafka-acl-extended");
    }

    private void verify(String path) {
        boolean sensitive = ZkData$.MODULE$.sensitivePath(path);
        Assertions.assertTrue((boolean)this.zkClient().getAcl(path).forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.MODULE$.isAclSecure(x$1, sensitive))));
    }

    private boolean isAclCorrect(Seq<ACL> list, boolean secure, boolean sensitive) {
        return (secure && !sensitive ? list.size() == 2 : list.size() == 1) && list.forall((Function1)(secure ? (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.MODULE$.isAclSecure(x$2, sensitive)) : (Function1 & Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.MODULE$.isAclUnsecure(acl))));
    }

    private void deleteAllUnsecure() {
        System.setProperty("zookeeper.sasl.client", "false");
        KafkaZkClient unsecureZkClient = this.newKafkaZkClient(this.zkConnect(), false);
        Try<Object> result = this.deleteRecursive(unsecureZkClient, "/");
        unsecureZkClient.close();
        System.clearProperty("zookeeper.sasl.client");
        if (result instanceof Success) {
            return;
        }
        if (result instanceof Failure) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)((Failure)result).exception().getMessage());
            return;
        }
        throw new MatchError(result);
    }

    private Try<Object> deleteRecursive(KafkaZkClient zkClient, String path) {
        Try try_;
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(9).append("Deleting ").append(path).toString());
        ObjectRef result = ObjectRef.create((Object)new Success((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        zkClient.getChildren(path).foreach((Function1 & Serializable)child -> {
            ZkAuthorizationTest.$anonfun$deleteRecursive$2(this, result, path, zkClient, child);
            return BoxedUnit.UNIT;
        });
        switch (path == null ? 0 : path.hashCode()) {
            case 47: {
                if ("/".equals(path)) {
                    try_ = (Try)result.elem;
                    break;
                }
            }
            default: {
                Try try_2;
                try {
                    int x$3 = zkClient.deletePath$default$2();
                    zkClient.deletePath(path, x$3, false);
                    try_2 = new Failure((Throwable)new Exception(new StringBuilder(25).append("Have been able to delete ").append(path).toString()));
                }
                catch (Exception exception) {
                    try_2 = (Try)result.elem;
                }
                try_ = try_2;
            }
        }
        return try_;
    }

    @Test
    public void testConsumerOffsetPathAcls() {
        this.zkClient().makeSurePersistentPathExists("/consumers");
        java.util.List consumerPathAcls = this.zkClient().currentZooKeeper().getACL("/consumers", new Stat());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(consumerPathAcls).asScala().forall((Function1 & Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.MODULE$.isAclUnsecure(acl))), (String)"old consumer znode path acls are not open");
    }

    public static final /* synthetic */ void $anonfun$testKafkaZkClient$2(ACL acl) {
        Assertions.assertTrue((boolean)TestUtils$.MODULE$.isAclSecure(acl, true));
    }

    public static final /* synthetic */ void $anonfun$testKafkaZkClient$3(ACL acl) {
        Assertions.assertTrue((boolean)TestUtils$.MODULE$.isAclSecure(acl, false));
    }

    public static final /* synthetic */ void $anonfun$testKafkaZkClient$1(ZkAuthorizationTest $this, String path) {
        $this.zkClient().makeSurePersistentPathExists(path);
        if (ZkData$.MODULE$.sensitivePath(path)) {
            Seq aclList = $this.zkClient().getAcl(path);
            Assertions.assertEquals((int)1, (int)aclList.size(), (String)new StringBuilder(29).append("Unexpected acl list size for ").append(path).toString());
            aclList.foreach((Function1 & Serializable)acl -> {
                ZkAuthorizationTest.$anonfun$testKafkaZkClient$2(acl);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (!path.equals("/consumers")) {
            Seq aclList = $this.zkClient().getAcl(path);
            Assertions.assertEquals((int)2, (int)aclList.size(), (String)new StringBuilder(29).append("Unexpected acl list size for ").append(path).toString());
            aclList.foreach((Function1 & Serializable)acl -> {
                ZkAuthorizationTest.$anonfun$testKafkaZkClient$3(acl);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$testDeleteRecursive$2(ZkAuthorizationTest $this, String path) {
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(9).append("Creating ").append(path).toString());
        $this.zkClient().makeSurePersistentPathExists(path);
        KafkaZkClient qual$1 = $this.zkClient();
        String x$1 = new StringBuilder(11).append(path).append("/fpjwashere").toString();
        byte[] x$2 = "".getBytes(StandardCharsets.UTF_8);
        boolean x$3 = qual$1.createRecursive$default$3();
        qual$1.createRecursive(x$1, x$2, x$3);
    }

    public static final /* synthetic */ void $anonfun$testMigration$2(ZkAuthorizationTest $this, KafkaZkClient firstZk$1, String path) {
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(9).append("Creating ").append(path).toString());
        firstZk$1.makeSurePersistentPathExists(path);
        firstZk$1.createRecursive(new StringBuilder(11).append(path).append("/fpjwashere").toString(), "".getBytes(StandardCharsets.UTF_8), firstZk$1.createRecursive$default$3());
    }

    public static final /* synthetic */ void $anonfun$testMigration$5(ZkAuthorizationTest $this, KafkaZkClient secondZk$1, String path) {
        boolean sensitive = ZkData$.MODULE$.sensitivePath(path);
        Seq listParent = secondZk$1.getAcl(path);
        Assertions.assertTrue((boolean)$this.isAclCorrect((Seq<ACL>)listParent, secondZk$1.secure(), sensitive), (String)path);
        String childPath = new StringBuilder(11).append(path).append("/fpjwashere").toString();
        Seq listChild = secondZk$1.getAcl(childPath);
        Assertions.assertTrue((boolean)$this.isAclCorrect((Seq<ACL>)listChild, secondZk$1.secure(), sensitive), (String)childPath);
    }

    public static final /* synthetic */ void $anonfun$deleteRecursive$2(ZkAuthorizationTest $this, ObjectRef result$1, String path$3, KafkaZkClient zkClient$1, String child) {
        Try try_;
        Try<Object> try_2;
        switch (path$3 == null ? 0 : path$3.hashCode()) {
            case 47: {
                if ("/".equals(path$3)) {
                    try_2 = $this.deleteRecursive(zkClient$1, new StringBuilder(1).append("/").append(child).toString());
                    break;
                }
            }
            default: {
                try_2 = $this.deleteRecursive(zkClient$1, new StringBuilder(1).append(path$3).append("/").append(child).toString());
            }
        }
        if (try_2 instanceof Success) {
            try_ = (Try)result$1.elem;
        } else if (try_2 instanceof Failure) {
            Throwable e = ((Failure)try_2).exception();
            try_ = new Failure(e);
        } else {
            throw new MatchError(try_2);
        }
        result$1.elem = try_;
    }

    public ZkAuthorizationTest() {
        this.authProvider = "zookeeper.authProvider.1";
    }
}

