/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.AbstractApiVersionsRequestTest;
import kafka.test.ClusterConfig;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.junit.ClusterTestExtensions;
import org.apache.kafka.common.message.ApiVersionsRequestData;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.reflect.ScalaSignature;

@ExtendWith(value={ClusterTestExtensions.class})
@ScalaSignature(bytes="\u0006\u0005q3AAC\u0006\u0001!!AQ\u0003\u0001B\u0001B\u0003%a\u0003C\u0003\u001d\u0001\u0011\u0005Q\u0004C\u0003!\u0001\u0011\u0005\u0011\u0005C\u0003;\u0001\u0011\u00051\bC\u0003D\u0001\u0011\u00051\bC\u0003F\u0001\u0011\u00051\bC\u0003H\u0001\u0011\u00051\bC\u0003J\u0001\u0011\u00051\bC\u0003L\u0001\u0011\u00051H\u0001\fBa&4VM]:j_:\u001c(+Z9vKN$H+Z:u\u0015\taQ\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u001d\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0012!\t\u00112#D\u0001\f\u0013\t!2B\u0001\u0010BEN$(/Y2u\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cH\u000fV3ti\u000691\r\\;ti\u0016\u0014\bCA\f\u001b\u001b\u0005A\"BA\r\u000e\u0003\u0011!Xm\u001d;\n\u0005mA\"aD\"mkN$XM]%ogR\fgnY3\u0002\rqJg.\u001b;?)\tqr\u0004\u0005\u0002\u0013\u0001!)QC\u0001a\u0001-\u0005)1/\u001a;vaR\u0011!\u0005\u000b\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0005+:LG\u000fC\u0003*\u0007\u0001\u0007!&\u0001\u0004d_:4\u0017n\u001a\t\u0003/-J!\u0001\f\r\u0003\u001b\rcWo\u001d;fe\u000e{gNZ5hQ\t\u0019a\u0006\u0005\u00020q5\t\u0001G\u0003\u00022e\u0005\u0019\u0011\r]5\u000b\u0005M\"\u0014a\u00026va&$XM\u001d\u0006\u0003kY\nQA[;oSRT\u0011aN\u0001\u0004_J<\u0017BA\u001d1\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u0017i\u0016\u001cH/\u00119j-\u0016\u00148/[8ogJ+\u0017/^3tiR\t!\u0005\u000b\u0002\u0005{A\u0011a(Q\u0007\u0002\u007f)\u0011\u0001\tG\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001\"@\u0005-\u0019E.^:uKJ$Vm\u001d;\u0002cQ,7\u000f^!qSZ+'o]5p]N\u0014V-];fgR$\u0006N]8vO\"\u001cuN\u001c;s_2\u0004F.\u00198f\u0019&\u001cH/\u001a8fe\"\u0012Q!P\u0001-i\u0016\u001cH/\u00119j-\u0016\u00148/[8ogJ+\u0017/^3ti^KG\u000f[+ogV\u0004\bo\u001c:uK\u00124VM]:j_:D#AB\u001f\u0002EQ,7\u000f^!qSZ+'o]5p]N\u0014V-];fgR4\u0016\r\\5eCRLwN\u001c,1Q\t9Q(A\u001fuKN$\u0018\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u-\u0006d\u0017\u000eZ1uS>tg\u000b\r+ie>,x\r[\"p]R\u0014x\u000e\u001c)mC:,G*[:uK:,'\u000f\u000b\u0002\t{\u0005\u0011C/Z:u\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cHOV1mS\u0012\fG/[8o-NB#!C\u001f)\t\u0001qE+\u0016\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#B\n\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\u0005M\u0003&AC#yi\u0016tGmV5uQ\u0006)a/\u00197vK2\nakI\u0001X!\tA&,D\u0001Z\u0015\t)\u0004$\u0003\u0002\\3\n)2\t\\;ti\u0016\u0014H+Z:u\u000bb$XM\\:j_:\u001c\b")
public class ApiVersionsRequestTest
extends AbstractApiVersionsRequestTest {
    private final ClusterInstance cluster;

    @BeforeEach
    public void setup(ClusterConfig config) {
        super.brokerPropertyOverrides(config.serverProperties());
    }

    @ClusterTest
    public void testApiVersionsRequest() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, this.cluster.clientListener());
        this.validateApiVersionsResponse(apiVersionsResponse);
    }

    @ClusterTest
    public void testApiVersionsRequestThroughControlPlaneListener() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, super.controlPlaneListenerName());
        this.validateApiVersionsResponse(apiVersionsResponse);
    }

    @ClusterTest
    public void testApiVersionsRequestWithUnsupportedVersion() {
        ApiVersionsRequest apiVersionsRequest = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendUnsupportedApiVersionRequest(apiVersionsRequest);
        Assertions.assertEquals((short)Errors.UNSUPPORTED_VERSION.code(), (short)apiVersionsResponse.data().errorCode());
        Assertions.assertFalse((boolean)apiVersionsResponse.data().apiKeys().isEmpty());
        ApiVersionsResponseData.ApiVersion apiVersion = apiVersionsResponse.data().apiKeys().find(ApiKeys.API_VERSIONS.id);
        Assertions.assertEquals((short)ApiKeys.API_VERSIONS.id, (short)apiVersion.apiKey());
        Assertions.assertEquals((short)ApiKeys.API_VERSIONS.oldestVersion(), (short)apiVersion.minVersion());
        Assertions.assertEquals((short)ApiKeys.API_VERSIONS.latestVersion(), (short)apiVersion.maxVersion());
    }

    @ClusterTest
    public void testApiVersionsRequestValidationV0() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, this.cluster.clientListener());
        this.validateApiVersionsResponse(apiVersionsResponse);
    }

    @ClusterTest
    public void testApiVersionsRequestValidationV0ThroughControlPlaneListener() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, super.controlPlaneListenerName());
        this.validateApiVersionsResponse(apiVersionsResponse);
    }

    @ClusterTest
    public void testApiVersionsRequestValidationV3() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest(new ApiVersionsRequestData(), (short)3);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, this.cluster.clientListener());
        Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)apiVersionsResponse.data().errorCode());
    }

    public ApiVersionsRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
        super(cluster);
    }
}

