/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h\u0001\u0002\u0013&\u0001)BQa\f\u0001\u0005\u0002ABQA\r\u0001\u0005BMBqA\u000f\u0001C\u0002\u0013\u00051\b\u0003\u0004E\u0001\u0001\u0006I\u0001\u0010\u0005\b\u000b\u0002\u0011\r\u0011\"\u0001G\u0011\u0019Q\u0005\u0001)A\u0005\u000f\"91\n\u0001b\u0001\n\u0003a\u0005BB*\u0001A\u0003%Q\nC\u0004U\u0001\t\u0007I\u0011A+\t\re\u0003\u0001\u0015!\u0003W\u0011\u001dQ\u0006A1A\u0005\u0002UCaa\u0017\u0001!\u0002\u00131\u0006b\u0002/\u0001\u0005\u0004%\t!\u0016\u0005\u0007;\u0002\u0001\u000b\u0011\u0002,\t\u000fy\u0003!\u0019!C\u0001?\"11\u000f\u0001Q\u0001\n\u0001Dq\u0001\u001e\u0001C\u0002\u0013\u0005q\f\u0003\u0004v\u0001\u0001\u0006I\u0001\u0019\u0005\bm\u0002\u0011\r\u0011\"\u0001x\u0011\u001d\ti\u0001\u0001Q\u0001\naD\u0001\"a\u0004\u0001\u0005\u0004%\ta\u001e\u0005\b\u0003#\u0001\u0001\u0015!\u0003y\u0011!\t\u0019\u0002\u0001b\u0001\n\u00039\bbBA\u000b\u0001\u0001\u0006I\u0001\u001f\u0005\n\u0003/\u0001!\u0019!C\u0001\u00033A\u0001\"!\t\u0001A\u0003%\u00111\u0004\u0005\b\u0003G\u0001A\u0011IA\u0013\u0011\u001d\t9\u0004\u0001C!\u0003sAq!!\u0015\u0001\t\u0003\tI\u0004C\u0004\u0002\\\u0001!\t!!\u000f\t\u000f\u0005}\u0003\u0001\"\u0001\u0002:!9\u00111\r\u0001\u0005\n\u0005\u0015\u0004bBAG\u0001\u0011%\u0011q\u0012\u0005\b\u0003S\u0003A\u0011BAV\u0011\u001d\ti\u000e\u0001C\u0005\u0003?\u0014ac\u00144gg\u0016$h)\u001a;dQJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003M\u001d\naa]3sm\u0016\u0014(\"\u0001\u0015\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u000b\t\u0003Y5j\u0011!J\u0005\u0003]\u0015\u0012qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0002\"\u0001\f\u0001\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u0002iA\u0011Q\u0007O\u0007\u0002m)\tq'A\u0003tG\u0006d\u0017-\u0003\u0002:m\t\u0019\u0011J\u001c;\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012\u0001\u0010\t\u0003{\tk\u0011A\u0010\u0006\u0003\u007f\u0001\u000bA\u0001\\1oO*\t\u0011)\u0001\u0003kCZ\f\u0017BA\"?\u0005\u001dIe\u000e^3hKJ\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\r=4gm]3u+\u00059\u0005CA\u001bI\u0013\tIeG\u0001\u0003M_:<\u0017aB8gMN,G\u000fI\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007.F\u0001N!\rq\u0015\u000bP\u0007\u0002\u001f*\u0011\u0001\u000bQ\u0001\u0005kRLG.\u0003\u0002S\u001f\nAq\n\u001d;j_:\fG.\u0001\u0007mK\u0006$WM]#q_\u000eD\u0007%\u0001\u0005nKR\fG-\u0019;b+\u00051\u0006CA\u001fX\u0013\tAfH\u0001\u0004TiJLgnZ\u0001\n[\u0016$\u0018\rZ1uC\u0002\nQ\u0001^8qS\u000e\fa\u0001^8qS\u000e\u0004\u0013aB4s_V\u0004\u0018\nZ\u0001\tOJ|W\u000f]%eA\u00051qM]8vaN,\u0012\u0001\u0019\t\u0004C&dgB\u00012h\u001d\t\u0019g-D\u0001e\u0015\t)\u0017&\u0001\u0004=e>|GOP\u0005\u0002o%\u0011\u0001NN\u0001\ba\u0006\u001c7.Y4f\u0013\tQ7NA\u0002TKFT!\u0001\u001b\u001c\u0011\u00055\fhB\u00018p!\t\u0019g'\u0003\u0002qm\u00051\u0001K]3eK\u001aL!\u0001\u0017:\u000b\u0005A4\u0014aB4s_V\u00048\u000fI\u0001\u0007i>\u0004\u0018nY:\u0002\u000fQ|\u0007/[2tA\u0005QAo\u001c9jGFb\u0015n\u001d;\u0016\u0003a\u00042AT=|\u0013\tQxJ\u0001\u0003MSN$\bc\u0001?\u0002\n5\tQP\u0003\u0002\u007f\u007f\u000611m\\7n_:T1\u0001KA\u0001\u0015\u0011\t\u0019!!\u0002\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t9!A\u0002pe\u001eL1!a\u0003~\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f1\u0002^8qS\u000e\fD*[:uA\u0005qAo\u001c9jGF\ne\u000e\u001a\u001aMSN$\u0018a\u0004;pa&\u001c\u0017'\u00118ee1K7\u000f\u001e\u0011\u0002\u001b\u0005dG\u000eV8qS\u000e\u001cH*[:u\u00039\tG\u000e\u001c+pa&\u001c7\u000fT5ti\u0002\n1c\u001a:pkB$v\u000eU1si&$\u0018n\u001c8NCB,\"!a\u0007\u0011\u000b9\u000bi\u0002\u001c=\n\u0007\u0005}qJA\u0002NCB\fAc\u001a:pkB$v\u000eU1si&$\u0018n\u001c8NCB\u0004\u0013a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\u0011\t9#!\f\u0011\u0007U\nI#C\u0002\u0002,Y\u0012A!\u00168ji\"9\u0011qF\u000eA\u0002\u0005E\u0012A\u00039s_B,'\u000f^5fgB\u0019a*a\r\n\u0007\u0005UrJ\u0001\u0006Qe>\u0004XM\u001d;jKN\fQa]3u+B$\"!a\n)\u0007q\ti\u0004\u0005\u0003\u0002@\u00055SBAA!\u0015\u0011\t\u0019%!\u0012\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002H\u0005%\u0013a\u00026va&$XM\u001d\u0006\u0005\u0003\u0017\n)!A\u0003kk:LG/\u0003\u0003\u0002P\u0005\u0005#A\u0003\"fM>\u0014X-R1dQ\u0006\tC/Z:u\u001f\u001a47/\u001a;GKR\u001c\u0007NU3rk\u0016\u001cHoU5oO2,wI]8va\"\u001aQ$!\u0016\u0011\t\u0005}\u0012qK\u0005\u0005\u00033\n\tE\u0001\u0003UKN$\u0018\u0001\u000b;fgR|eMZ:fi\u001a+Go\u00195SKF,Xm\u001d;XSRDW*\u001e7uSBdWm\u0012:pkB\u001c\bf\u0001\u0010\u0002V\u0005iD/Z:u\u001f\u001a47/\u001a;GKR\u001c\u0007NU3rk\u0016\u001cHoV5uQ6+H\u000e^5qY\u0016<%o\\;qg^KG\u000f[(oK\u001e\u0013x.\u001e9SKB,\u0017\r^5oO\"\u001aq$!\u0016\u00023Y,'/\u001b4z'&tw\r\\3He>,\bOU3ta>t7/\u001a\u000b\u0013\u0003O\t9'!\u001d\u0002v\u0005e\u0014QPAA\u0003\u000b\u000bI\tC\u0004\u0002j\u0001\u0002\r!a\u001b\u0002\u000fY,'o]5p]B\u0019Q'!\u001c\n\u0007\u0005=dGA\u0003TQ>\u0014H\u000fC\u0004\u0002t\u0001\u0002\r!a\u001b\u0002\u001bI,7\u000f]8og\u0016,%O]8s\u0011\u001d\t9\b\ta\u0001\u0003W\na\u0002]1si&$\u0018n\u001c8FeJ|'\u000f\u0003\u0004\u0002|\u0001\u0002\r\u0001\\\u0001\ni>\u0004\u0018n\u0019(b[\u0016Da!a !\u0001\u0004a\u0014A\u00049beRLG/[8o\u0013:$W\r\u001f\u0005\u0007\u0003\u0007\u0003\u0003\u0019A$\u0002\u001f\r|W.\\5ui\u0016$wJ\u001a4tKRDa!a\"!\u0001\u0004a\u0014\u0001F2p[6LG\u000f^3e\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000e\u0003\u0004\u0002\f\u0002\u0002\r\u0001\\\u0001\u0012a\u0006\u0014H/\u001b;j_:lU\r^1eCR\f\u0017a\u0005<fe&4\u0017\u0010U1si&$\u0018n\u001c8ECR\fG\u0003BA\u0014\u0003#Cq!a%\"\u0001\u0004\t)*A\u0007qCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\t\u0005\u0003/\u000b\u0019K\u0004\u0003\u0002\u001a\u0006}UBAAN\u0015\r\ti*`\u0001\te\u0016\fX/Z:ug&!\u0011\u0011UAN\u0003MyeMZ:fi\u001a+Go\u00195SKN\u0004xN\\:f\u0013\u0011\t)+a*\u0003\u001bA\u000b'\u000f^5uS>tG)\u0019;b\u0015\u0011\t\t+a'\u0002\u001dY,'/\u001b4z%\u0016\u001c\bo\u001c8tKRA\u0011qEAW\u0003{\u000bI\u000eC\u0004\u00020\n\u0002\r!!-\u0002%\u001d\u0014x.\u001e9MKZ,GNU3ta>t7/\u001a\t\u0005\u0003g\u000bI,\u0004\u0002\u00026*\u0019\u0011qW?\u0002\u0011A\u0014x\u000e^8d_2LA!a/\u00026\n1QI\u001d:peNDq!a%#\u0001\u0004\ty\f\u0005\u0004O\u0003;Y\u0018\u0011\u0019\t\u0005\u0003\u0007\f\u0019K\u0004\u0003\u0002F\u0006}e\u0002BAd\u0003/tA!!3\u0002V:!\u00111ZAj\u001d\u0011\ti-!5\u000f\u0007\r\fy-\u0003\u0002\u0002\b%!\u00111AA\u0003\u0013\rA\u0013\u0011A\u0005\u0003}~L1!!(~\u0011\u0019\tYN\ta\u0001q\u0006IAo\u001c9jG2K7\u000f^\u0001\u000eG>lW.\u001b;PM\u001a\u001cX\r^:\u0015\t\u0005\u001d\u0012\u0011\u001d\u0005\u0007\u0003G\u001c\u0003\u0019\u0001=\u0002\rQ\u0004H*[:u\u0001")
public class OffsetFetchRequestTest
extends BaseRequestTest {
    private final Integer brokerId = Predef$.MODULE$.int2Integer(0);
    private final long offset;
    private final Optional<Integer> leaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(3));
    private final String metadata;
    private final String topic;
    private final String groupId;
    private final scala.collection.immutable.Seq<String> groups = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 5).map((Function1 & Serializable)i -> OffsetFetchRequestTest.$anonfun$groups$1(BoxesRunTime.unboxToInt((Object)i)));
    private final scala.collection.immutable.Seq<String> topics = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable)i -> OffsetFetchRequestTest.$anonfun$topics$1(BoxesRunTime.unboxToInt((Object)i)));
    private final List<TopicPartition> topic1List = Collections.singletonList(new TopicPartition((String)this.topics().apply(0), 0));
    private final List<TopicPartition> topic1And2List = Arrays.asList(new TopicPartition((String)this.topics().apply(0), 0), new TopicPartition((String)this.topics().apply(1), 0), new TopicPartition((String)this.topics().apply(1), 1));
    private final List<TopicPartition> allTopicsList = Arrays.asList(new TopicPartition((String)this.topics().apply(0), 0), new TopicPartition((String)this.topics().apply(1), 0), new TopicPartition((String)this.topics().apply(1), 1), new TopicPartition((String)this.topics().apply(2), 0), new TopicPartition((String)this.topics().apply(2), 1), new TopicPartition((String)this.topics().apply(2), 2));
    private final java.util.Map<String, List<TopicPartition>> groupToPartitionMap = new HashMap<String, List<TopicPartition>>();

    @Override
    public int brokerCount() {
        return 1;
    }

    public Integer brokerId() {
        return this.brokerId;
    }

    public long offset() {
        return this.offset;
    }

    public Optional<Integer> leaderEpoch() {
        return this.leaderEpoch;
    }

    public String metadata() {
        return this.metadata;
    }

    public String topic() {
        return this.topic;
    }

    public String groupId() {
        return this.groupId;
    }

    public scala.collection.immutable.Seq<String> groups() {
        return this.groups;
    }

    public scala.collection.immutable.Seq<String> topics() {
        return this.topics;
    }

    public List<TopicPartition> topic1List() {
        return this.topic1List;
    }

    public List<TopicPartition> topic1And2List() {
        return this.topic1And2List;
    }

    public List<TopicPartition> allTopicsList() {
        return this.allTopicsList;
    }

    public java.util.Map<String, List<TopicPartition>> groupToPartitionMap() {
        return this.groupToPartitionMap;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.BrokerIdProp(), this.brokerId().toString());
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "1");
        properties.put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), "1");
        properties.put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), "1");
        properties.put(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), "1");
    }

    @Override
    @BeforeEach
    public void setUp() {
        this.doSetup(false);
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
    }

    @Test
    public void testOffsetFetchRequestSingleGroup() {
        this.createTopic(this.topic(), this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        List<TopicPartition> tpList = Collections.singletonList(new TopicPartition(this.topic(), 0));
        this.consumerConfig().setProperty("group.id", this.groupId());
        this.commitOffsets(tpList);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), (int)ApiKeys.OFFSET_FETCH.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            if (version < 8) {
                OffsetFetchRequest request = version < 7 ? new OffsetFetchRequest.Builder(this.groupId(), false, tpList, false).build((short)version) : new OffsetFetchRequest.Builder(this.groupId(), false, tpList, true).build((short)version);
                OffsetFetchResponse response = (OffsetFetchResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(OffsetFetchResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
                OffsetFetchResponseData.OffsetFetchResponseTopic topicData = (OffsetFetchResponseData.OffsetFetchResponseTopic)response.data().topics().get(0);
                OffsetFetchResponseData.OffsetFetchResponsePartition partitionData = (OffsetFetchResponseData.OffsetFetchResponsePartition)topicData.partitions().get(0);
                if (version < 3) {
                    Assertions.assertEquals((int)0, (int)response.throttleTimeMs());
                }
                this.verifySingleGroupResponse((short)version, response.error().code(), partitionData.errorCode(), topicData.name(), Predef$.MODULE$.int2Integer(partitionData.partitionIndex()), partitionData.committedOffset(), Predef$.MODULE$.int2Integer(partitionData.committedLeaderEpoch()), partitionData.metadata());
                return;
            }
            OffsetFetchRequest request = new OffsetFetchRequest.Builder(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.groupId()), (Object)tpList)}))).asJava(), false, false).build((short)version);
            OffsetFetchResponseData.OffsetFetchResponseGroup groupData = (OffsetFetchResponseData.OffsetFetchResponseGroup)((OffsetFetchResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(OffsetFetchResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()))).data().groups().get(0);
            OffsetFetchResponseData.OffsetFetchResponseTopics topicData = (OffsetFetchResponseData.OffsetFetchResponseTopics)groupData.topics().get(0);
            OffsetFetchResponseData.OffsetFetchResponsePartitions partitionData = (OffsetFetchResponseData.OffsetFetchResponsePartitions)topicData.partitions().get(0);
            this.verifySingleGroupResponse((short)version, groupData.errorCode(), partitionData.errorCode(), topicData.name(), Predef$.MODULE$.int2Integer(partitionData.partitionIndex()), partitionData.committedOffset(), Predef$.MODULE$.int2Integer(partitionData.committedLeaderEpoch()), partitionData.metadata());
        });
    }

    @Test
    public void testOffsetFetchRequestWithMultipleGroups() {
        this.createTopic((String)this.topics().apply(0), this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        this.createTopic((String)this.topics().apply(1), 2, this.createTopic$default$3(), this.createTopic$default$4());
        this.createTopic((String)this.topics().apply(2), 3, this.createTopic$default$3(), this.createTopic$default$4());
        scala.collection.mutable.Map partitionMap = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(this.groupToPartitionMap()).asScala().map((Function1 & Serializable)e -> new Tuple2(e._1(), Option$.MODULE$.apply(e._2()).getOrElse((Function0 & Serializable)() -> this.allTopicsList())));
        this.groups().foreach((Function1 & Serializable)groupId -> {
            OffsetFetchRequestTest.$anonfun$testOffsetFetchRequestWithMultipleGroups$3(this, partitionMap, groupId);
            return BoxedUnit.UNIT;
        });
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(8), (int)ApiKeys.OFFSET_FETCH.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            OffsetFetchRequest request = new OffsetFetchRequest.Builder(this.groupToPartitionMap(), false, false).build((short)version);
            OffsetFetchResponse response = (OffsetFetchResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(OffsetFetchResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
            ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(response.data().groups()).asScala().map((Function1 & Serializable)x$1 -> x$1.groupId())).foreach((Function1 & Serializable)groupId -> {
                this.verifyResponse(response.groupLevelError(groupId), response.partitionDataMap(groupId), (List)partitionMap.apply((Object)groupId));
                return BoxedUnit.UNIT;
            });
        });
    }

    @Test
    public void testOffsetFetchRequestWithMultipleGroupsWithOneGroupRepeating() {
        this.createTopic((String)this.topics().apply(0), this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        this.createTopic((String)this.topics().apply(1), 2, this.createTopic$default$3(), this.createTopic$default$4());
        this.createTopic((String)this.topics().apply(2), 3, this.createTopic$default$3(), this.createTopic$default$4());
        scala.collection.mutable.Map partitionMap = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(this.groupToPartitionMap()).asScala().map((Function1 & Serializable)e -> new Tuple2(e._1(), Option$.MODULE$.apply(e._2()).getOrElse((Function0 & Serializable)() -> this.allTopicsList())));
        this.groups().foreach((Function1 & Serializable)groupId -> {
            OffsetFetchRequestTest.$anonfun$testOffsetFetchRequestWithMultipleGroupsWithOneGroupRepeating$3(this, partitionMap, groupId);
            return BoxedUnit.UNIT;
        });
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(8), (int)ApiKeys.OFFSET_FETCH.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            OffsetFetchRequest request = new OffsetFetchRequest.Builder(this.groupToPartitionMap(), false, false).build((short)version);
            List requestGroups = request.data().groups();
            requestGroups.add(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId((String)this.groups().apply(2)).setTopics(Collections.singletonList(new OffsetFetchRequestData.OffsetFetchRequestTopics().setName((String)this.topics().apply(0)).setPartitionIndexes(Collections.singletonList(Predef$.MODULE$.int2Integer(0))))));
            request.data().setGroups(requestGroups);
            OffsetFetchResponse response = (OffsetFetchResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(OffsetFetchResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
            ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(response.data().groups()).asScala().map((Function1 & Serializable)x$2 -> x$2.groupId())).foreach((Function1 & Serializable)groupId -> {
                OffsetFetchRequestTest.$anonfun$testOffsetFetchRequestWithMultipleGroupsWithOneGroupRepeating$6(this, response, partitionMap, groupId);
                return BoxedUnit.UNIT;
            });
        });
    }

    private void verifySingleGroupResponse(short version, short responseError, short partitionError, String topicName, Integer partitionIndex, long committedOffset, Integer committedLeaderEpoch, String partitionMetadata) {
        Assertions.assertEquals((short)Errors.NONE.code(), (short)responseError);
        Assertions.assertEquals((Object)this.topic(), (Object)topicName);
        Assertions.assertEquals((int)0, (Integer)partitionIndex);
        Assertions.assertEquals((long)this.offset(), (long)committedOffset);
        if (version >= 5) {
            Assertions.assertEquals((Integer)this.leaderEpoch().get(), (Integer)committedLeaderEpoch);
        }
        Assertions.assertEquals((Object)this.metadata(), (Object)partitionMetadata);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionError);
    }

    private void verifyPartitionData(OffsetFetchResponse.PartitionData partitionData) {
        Assertions.assertTrue((!partitionData.hasError() ? 1 : 0) != 0);
        Assertions.assertEquals((long)this.offset(), (long)partitionData.offset);
        Assertions.assertEquals((Object)this.metadata(), (Object)partitionData.metadata);
        Assertions.assertEquals((Integer)this.leaderEpoch().get(), (Integer)((Integer)partitionData.leaderEpoch.get()));
    }

    private void verifyResponse(Errors groupLevelResponse, java.util.Map<TopicPartition, OffsetFetchResponse.PartitionData> partitionData, List<TopicPartition> topicList) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)groupLevelResponse);
        Assertions.assertTrue((partitionData.size() == topicList.size() ? 1 : 0) != 0);
        topicList.forEach(t -> this.verifyPartitionData((OffsetFetchResponse.PartitionData)partitionData.get(t)));
    }

    private void commitOffsets(List<TopicPartition> tpList) {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign(tpList);
        java.util.Map offsets = CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(tpList).asScala().map((Function1 & Serializable)tp -> new Tuple2(tp, (Object)new OffsetAndMetadata(this.offset(), this.leaderEpoch(), this.metadata())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
        consumer.commitSync(offsets);
        consumer.close();
    }

    public static final /* synthetic */ String $anonfun$groups$1(int i) {
        return new StringBuilder(5).append("group").append(i).toString();
    }

    public static final /* synthetic */ String $anonfun$topics$1(int i) {
        return new StringBuilder(5).append("topic").append(i).toString();
    }

    public static final /* synthetic */ void $anonfun$testOffsetFetchRequestWithMultipleGroups$3(OffsetFetchRequestTest $this, scala.collection.mutable.Map partitionMap$1, String groupId) {
        $this.consumerConfig().setProperty("group.id", groupId);
        $this.commitOffsets((List)partitionMap$1.apply((Object)groupId));
    }

    public static final /* synthetic */ void $anonfun$testOffsetFetchRequestWithMultipleGroupsWithOneGroupRepeating$3(OffsetFetchRequestTest $this, scala.collection.mutable.Map partitionMap$2, String groupId) {
        $this.consumerConfig().setProperty("group.id", groupId);
        $this.commitOffsets((List)partitionMap$2.apply((Object)groupId));
    }

    public static final /* synthetic */ void $anonfun$testOffsetFetchRequestWithMultipleGroupsWithOneGroupRepeating$6(OffsetFetchRequestTest $this, OffsetFetchResponse response$2, scala.collection.mutable.Map partitionMap$2, String groupId) {
        String string = groupId;
        String string2 = "group3";
        if (string != null && string.equals(string2)) {
            $this.verifyResponse(response$2.groupLevelError(groupId), response$2.partitionDataMap(groupId), $this.topic1List());
            return;
        }
        $this.verifyResponse(response$2.groupLevelError(groupId), response$2.partitionDataMap(groupId), (List)partitionMap$2.apply((Object)groupId));
    }

    public OffsetFetchRequestTest() {
        this.offset = 15L;
        this.metadata = "metadata";
        this.topic = "topic";
        this.groupId = "groupId";
        this.groupToPartitionMap().put((String)this.groups().apply(0), this.topic1List());
        this.groupToPartitionMap().put((String)this.groups().apply(1), this.topic1And2List());
        this.groupToPartitionMap().put((String)this.groups().apply(2), this.allTopicsList());
        this.groupToPartitionMap().put((String)this.groups().apply(3), null);
        this.groupToPartitionMap().put((String)this.groups().apply(4), null);
    }
}

