/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.admin.BrokerMetadata;
import kafka.cluster.Broker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.BrokerState;
import org.apache.zookeeper.KeeperException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u001d3Aa\u0003\u0007\u0001#!)\u0001\u0004\u0001C\u00013!9Q\u0002\u0001a\u0001\n\u0013a\u0002b\u0002\u0011\u0001\u0001\u0004%I!\t\u0005\u0007U\u0001\u0001\u000b\u0015B\u000f\t\u000b-\u0002A\u0011\t\u0017\t\u000bi\u0002A\u0011\u0001\u0017\t\u000b}\u0002A\u0011\u0001\u0017\t\u000b\u0005\u0003A\u0011\u0001\u0017\t\u000b\r\u0003A\u0011\u0001\u0017\t\u000b\u0015\u0003A\u0011\u0001\u0017\u0003#M+'O^3s'R\f'\u000f^;q)\u0016\u001cHO\u0003\u0002\u000e\u001d\u000511/\u001a:wKJT\u0011aD\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\u001d\u0005\u0011!p[\u0005\u0003/Q\u0011ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001\u001b!\tY\u0002!D\u0001\r+\u0005i\u0002CA\u000e\u001f\u0013\tyBBA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\u0018AC:feZ,'o\u0018\u0013fcR\u0011!\u0005\u000b\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0005+:LG\u000fC\u0004*\u0007\u0005\u0005\t\u0019A\u000f\u0002\u0007a$\u0013'A\u0004tKJ4XM\u001d\u0011\u0002\u0011Q,\u0017M\u001d#po:$\u0012A\t\u0015\u0003\u000b9\u0002\"a\f\u001d\u000e\u0003AR!!\r\u001a\u0002\u0007\u0005\u0004\u0018N\u0003\u00024i\u00059!.\u001e9ji\u0016\u0014(BA\u001b7\u0003\u0015QWO\\5u\u0015\u00059\u0014aA8sO&\u0011\u0011\b\r\u0002\n\u0003\u001a$XM]#bG\"\f\u0011\u0004^3ti\n\u0013xn[3s\u0007J,\u0017\r^3t5.\u001b\u0005N]8pi\"\u0012a\u0001\u0010\t\u0003_uJ!A\u0010\u0019\u0003\tQ+7\u000f^\u0001&i\u0016\u001cHoQ8oM2L7\r\u001e\"s_.,'o\u0015;beR,\boV5uQN\u000bW.\u001a)peRD#a\u0002\u001f\u0002=Q,7\u000f^\"p]\u001ad\u0017n\u0019;Ce>\\WM\u001d*fO&\u001cHO]1uS>t\u0007F\u0001\u0005=\u0003M!Xm\u001d;Ce>\\WM]*fY\u001a\fu/\u0019:fQ\tIA(A\u000fuKN$(I]8lKJ\u001cF/\u0019;f%Vtg.\u001b8h\u0003\u001a$XM\u001d.LQ\tQA\b")
public class ServerStartupTest
extends ZooKeeperTestHarness {
    private KafkaServer server = null;

    private KafkaServer server() {
        return this.server;
    }

    private void server_$eq(KafkaServer x$1) {
        this.server = x$1;
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.server() != null) {
            TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}))));
        }
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerCreatesZKChroot() {
        void createServer_time;
        void createServer_config;
        Time time;
        int brokerId = 0;
        String zookeeperChroot = "/kafka-chroot-for-unittest";
        Properties props = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        Object zooKeeperConnect = props.get("zookeeper.connect");
        props.put("zookeeper.connect", new StringBuilder(0).append(zooKeeperConnect.toString()).append(zookeeperChroot).toString());
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time time3 = time2;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        Object var8_9 = null;
        Object var5_8 = null;
        kafkaConfig = null;
        time3 = null;
        this.server_$eq(createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, false));
        Assertions.assertTrue((boolean)this.zkClient().pathExists(zookeeperChroot));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConflictBrokerStartupWithSamePort() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        void createServer_time;
        void createServer_config;
        Time time;
        int brokerId1 = 0;
        Properties props1 = TestUtils$.MODULE$.createBrokerConfig(brokerId1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time time3 = time2;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props1);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        Object var14_7 = null;
        Object var11_6 = null;
        kafkaConfig = null;
        time3 = null;
        this.server_$eq(createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, false));
        int port = TestUtils$.MODULE$.boundPort(this.server(), SecurityProtocol.PLAINTEXT);
        int brokerId2 = 1;
        String x$2 = this.zkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties props2 = TestUtils$.MODULE$.createBrokerConfig(brokerId2, x$2, bl, bl2, port, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        Assertions.assertThrows(KafkaException.class, () -> {
            void createServer_time;
            Time time;
            Time time2 = time = Time.SYSTEM;
            time = null;
            Time time3 = time2;
            KafkaConfig createServer_config = KafkaConfig$.MODULE$.fromProps(props2);
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
            createServer_this.createServer(createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, false);
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConflictBrokerRegistration() {
        void createServer_time;
        void createServer_config;
        Time time;
        int brokerId = 0;
        Properties props1 = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time time3 = time2;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props1);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        Object var8_7 = null;
        Object var5_6 = null;
        kafkaConfig = null;
        time3 = null;
        this.server_$eq(createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, false));
        Broker brokerRegistration = (Broker)this.zkClient().getBroker(brokerId).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"broker doesn't exists"));
        Properties props2 = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        Assertions.assertThrows(KeeperException.NodeExistsException.class, () -> {
            void createServer_time;
            Time time;
            Time time2 = time = Time.SYSTEM;
            time = null;
            Time time3 = time2;
            KafkaConfig createServer_config = KafkaConfig$.MODULE$.fromProps(props2);
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
            createServer_this.createServer(createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, false);
        });
        Assertions.assertEquals((Object)brokerRegistration, (Object)this.zkClient().getBroker(brokerId).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"broker doesn't exists")));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerSelfAware() {
        void createServer_time;
        void createServer_config;
        Time time;
        int brokerId = 0;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time time3 = time2;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        Object var8_7 = null;
        Object var5_6 = null;
        kafkaConfig = null;
        time3 = null;
        this.server_$eq(createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, false));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ServerStartupTest.$anonfun$testBrokerSelfAware$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Wait for cache to update");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Assertions.assertEquals((int)1, (int)this.server().metadataCache().getAliveBrokers().size());
        Assertions.assertEquals((int)brokerId, (int)((BrokerMetadata)this.server().metadataCache().getAliveBrokers().head()).id());
    }

    @Test
    public void testBrokerStateRunningAfterZK() {
        int brokerId = 0;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        this.server_$eq(new KafkaServer(KafkaConfig$.MODULE$.fromProps(props), Time.SYSTEM, (Option)None$.MODULE$, false));
        this.server().startup();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ServerStartupTest.$anonfun$testBrokerStateRunningAfterZK$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"waiting for the broker state to become RUNNING");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Seq brokers = this.zkClient().getAllBrokersInCluster();
        Assertions.assertEquals((int)1, (int)brokers.size());
        Assertions.assertEquals((int)brokerId, (int)((Broker)brokers.head()).id());
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerSelfAware$1(ServerStartupTest $this) {
        return $this.server().metadataCache().getAliveBrokers().nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$testBrokerSelfAware$2() {
        return "Wait for cache to update";
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerStateRunningAfterZK$1(ServerStartupTest $this) {
        BrokerState brokerState = $this.server().brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testBrokerStateRunningAfterZK$2() {
        return "waiting for the broker state to become RUNNING";
    }
}

