/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.Serializable;
import java.util.Arrays;
import kafka.tools.ConsoleProducer;
import kafka.tools.ConsoleProducer$;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0005a3AAE\n\u00011!)q\u0004\u0001C\u0001A!91\u0005\u0001b\u0001\n\u0003!\u0003BB\u001a\u0001A\u0003%Q\u0005C\u00045\u0001\t\u0007I\u0011\u0001\u0013\t\rU\u0002\u0001\u0015!\u0003&\u0011\u001d1\u0004A1A\u0005\u0002\u0011Baa\u000e\u0001!\u0002\u0013)\u0003b\u0002\u001d\u0001\u0005\u0004%\t\u0001\n\u0005\u0007s\u0001\u0001\u000b\u0011B\u0013\t\u000fi\u0002!\u0019!C\u0001I!11\b\u0001Q\u0001\n\u0015BQ\u0001\u0010\u0001\u0005\u0002uBQA\u0014\u0001\u0005\u0002uBQ\u0001\u0015\u0001\u0005\u0002uBQA\u0015\u0001\u0005\u0002uBQ\u0001\u0016\u0001\u0005\u0002uBQA\u0016\u0001\u0005\u0002u\u00121cQ8og>dW\r\u0015:pIV\u001cWM\u001d+fgRT!\u0001F\u000b\u0002\u000bQ|w\u000e\\:\u000b\u0003Y\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00013A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0011\u0011\u0005\t\u0002Q\"A\n\u0002'\t\u0014xn[3s\u0019&\u001cHOV1mS\u0012\f%oZ:\u0016\u0003\u0015\u00022A\u0007\u0014)\u0013\t93DA\u0003BeJ\f\u0017\u0010\u0005\u0002*a9\u0011!F\f\t\u0003Wmi\u0011\u0001\f\u0006\u0003[]\ta\u0001\u0010:p_Rt\u0014BA\u0018\u001c\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011G\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=Z\u0012\u0001\u00062s_.,'\u000fT5tiZ\u000bG.\u001b3Be\u001e\u001c\b%\u0001\rc_>$8\u000f\u001e:baN+'O^3s-\u0006d\u0017\u000eZ!sON\f\u0011DY8piN$(/\u00199TKJ4XM\u001d,bY&$\u0017I]4tA\u0005Y\u0011N\u001c<bY&$\u0017I]4t\u00031IgN^1mS\u0012\f%oZ:!\u0003]\u0011wn\u001c;tiJ\f\u0007oU3sm\u0016\u0014xJ^3se&$W-\u0001\rc_>$8\u000f\u001e:baN+'O^3s\u001fZ,'O]5eK\u0002\n\u0001c\u00197jK:$\u0018\nZ(wKJ\u0014\u0018\u000eZ3\u0002#\rd\u0017.\u001a8u\u0013\u0012|e/\u001a:sS\u0012,\u0007%\u0001\u000euKN$h+\u00197jI\u000e{gNZ5hg\n\u0013xn[3s\u0019&\u001cH\u000fF\u0001?!\tQr(\u0003\u0002A7\t!QK\\5uQ\ta!\t\u0005\u0002D\u00196\tAI\u0003\u0002F\r\u0006\u0019\u0011\r]5\u000b\u0005\u001dC\u0015a\u00026va&$XM\u001d\u0006\u0003\u0013*\u000bQA[;oSRT\u0011aS\u0001\u0004_J<\u0017BA'E\u0005\u0011!Vm\u001d;\u0002?Q,7\u000f\u001e,bY&$7i\u001c8gS\u001e\u001c(i\\8ugR\u0014\u0018\r]*feZ,'\u000f\u000b\u0002\u000e\u0005\u0006\u0011B/Z:u\u0013:4\u0018\r\\5e\u0007>tg-[4tQ\tq!)\u0001\tuKN$\b+\u0019:tK.+\u0017\u0010\u0015:pa\"\u0012qBQ\u0001\u001ci\u0016\u001cHOQ8piN$(/\u00199TKJ4XM](wKJ\u0014\u0018\u000eZ3)\u0005A\u0011\u0015\u0001\u0006;fgR\u001cE.[3oi&#wJ^3se&$W\r\u000b\u0002\u0012\u0005\u0002")
public class ConsoleProducerTest {
    private final String[] brokerListValidArgs = new String[]{"--broker-list", "localhost:1001,localhost:1002", "--topic", "t3", "--property", "parse.key=true", "--property", "key.separator=#"};
    private final String[] bootstrapServerValidArgs = new String[]{"--bootstrap-server", "localhost:1003,localhost:1004", "--topic", "t3", "--property", "parse.key=true", "--property", "key.separator=#"};
    private final String[] invalidArgs = new String[]{"--t", "t3"};
    private final String[] bootstrapServerOverride = new String[]{"--broker-list", "localhost:1001", "--bootstrap-server", "localhost:1002", "--topic", "t3"};
    private final String[] clientIdOverride = new String[]{"--broker-list", "localhost:1001", "--topic", "t3", "--producer-property", "client.id=producer-1"};

    public String[] brokerListValidArgs() {
        return this.brokerListValidArgs;
    }

    public String[] bootstrapServerValidArgs() {
        return this.bootstrapServerValidArgs;
    }

    public String[] invalidArgs() {
        return this.invalidArgs;
    }

    public String[] bootstrapServerOverride() {
        return this.bootstrapServerOverride;
    }

    public String[] clientIdOverride() {
        return this.clientIdOverride;
    }

    @Test
    public void testValidConfigsBrokerList() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.brokerListValidArgs());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assertions.assertEquals(Arrays.asList("localhost:1001", "localhost:1002"), (Object)producerConfig.getList("bootstrap.servers"));
    }

    @Test
    public void testValidConfigsBootstrapServer() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.bootstrapServerValidArgs());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assertions.assertEquals(Arrays.asList("localhost:1003", "localhost:1004"), (Object)producerConfig.getList("bootstrap.servers"));
    }

    @Test
    public void testInvalidConfigs() {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(x$1, message) -> ConsoleProducerTest.$anonfun$testInvalidConfigs$1(BoxesRunTime.unboxToInt((Object)x$1), message);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var2_1 = null;
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleProducer.ProducerConfig(this.invalidArgs()));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void testParseKeyProp() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.brokerListValidArgs());
        ConsoleProducer.LineMessageReader reader = (ConsoleProducer.LineMessageReader)Class.forName(config.readerClass()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        reader.init(System.in, ConsoleProducer$.MODULE$.getReaderProps(config));
        String string = reader.keySeparator();
        String string2 = "#";
        Predef$.MODULE$.assert(string != null && string.equals(string2));
        Predef$.MODULE$.assert(reader.parseKey());
    }

    @Test
    public void testBootstrapServerOverride() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.bootstrapServerOverride());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assertions.assertEquals(Arrays.asList("localhost:1002"), (Object)producerConfig.getList("bootstrap.servers"));
    }

    @Test
    public void testClientIdOverride() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.clientIdOverride());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assertions.assertEquals((Object)"producer-1", (Object)producerConfig.getString("client.id"));
    }

    public static final /* synthetic */ Nothing$ $anonfun$testInvalidConfigs$1(int x$1, Option message) {
        throw new IllegalArgumentException((String)message.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }
}

