/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kafka.common.RequestAndCompletionHandler;
import kafka.common.UnsentRequests;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.DisconnectException;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.collection.Iterable;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0005\u0005mc!\u0002\r\u001a\u0003\u0003q\u0002\"C\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u00144\u0011!!\u0004A!A!\u0002\u0013)\u0004\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011B!\t\u0011\u0015\u0003!\u0011!Q\u0001\n\u0019C\u0011\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014)\t\u000bE\u0003A\u0011\u0001*\t\u000fi\u0003!\u0019!C\u00057\"1q\f\u0001Q\u0001\nqCQ\u0001\u0019\u0001\u0007\u0002\u0005DQA\u001c\u0001\u0005\u0002=DQ\u0001\u001d\u0001\u0005BEDQ!\u001e\u0001\u0005\nEDQA\u001e\u0001\u0005\u0012]DQ! \u0001\u0005BEDQA \u0001\u0005\n}Dq!a\u0002\u0001\t\u0013\tI\u0001C\u0004\u0002\u000e\u0001!I!a\u0004\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0016!1\u00111\u0007\u0001\u0005\u0002E<\u0011\"!\u000e\u001a\u0003\u0003E\t!a\u000e\u0007\u0011aI\u0012\u0011!E\u0001\u0003sAa!U\u000b\u0005\u0002\u0005\u0005\u0003\"CA\"+E\u0005I\u0011AA#\u0005UIe\u000e^3s\u0005J|7.\u001a:TK:$G\u000b\u001b:fC\u0012T!AG\u000e\u0002\r\r|W.\\8o\u0015\u0005a\u0012!B6bM.\f7\u0001A\n\u0003\u0001}\u0001\"\u0001I\u0012\u000e\u0003\u0005R!AI\u000e\u0002\u000bU$\u0018\u000e\\:\n\u0005\u0011\n#AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012\fAA\\1nKB\u0011q\u0005\r\b\u0003Q9\u0002\"!\u000b\u0017\u000e\u0003)R!aK\u000f\u0002\rq\u0012xn\u001c;?\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011G\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=b\u0013BA\u0013$\u00035qW\r^<pe.\u001cE.[3oiB\u0011aGP\u0007\u0002o)\u0011\u0001(O\u0001\bG2LWM\u001c;t\u0015\ta\"H\u0003\u0002<y\u00051\u0011\r]1dQ\u0016T\u0011!P\u0001\u0004_J<\u0017BA 8\u0005-Y\u0015MZ6b\u00072LWM\u001c;\u0002!I,\u0017/^3tiRKW.Z8vi6\u001b\bC\u0001\"D\u001b\u0005a\u0013B\u0001#-\u0005\rIe\u000e^\u0001\u0005i&lW\r\u0005\u0002H\u00156\t\u0001J\u0003\u0002#\u0013*\u0011!$O\u0005\u0003\u0017\"\u0013A\u0001V5nK\u0006y\u0011n]%oi\u0016\u0014(/\u001e9uS\ndW\r\u0005\u0002C\u001d&\u0011q\n\f\u0002\b\u0005>|G.Z1o\u0013\ta5%\u0001\u0004=S:LGO\u0010\u000b\u0007'V3v\u000bW-\u0011\u0005Q\u0003Q\"A\r\t\u000b\u00152\u0001\u0019\u0001\u0014\t\u000bQ2\u0001\u0019A\u001b\t\u000b\u00013\u0001\u0019A!\t\u000b\u00153\u0001\u0019\u0001$\t\u000f13\u0001\u0013!a\u0001\u001b\u0006qQO\\:f]R\u0014V-];fgR\u001cX#\u0001/\u0011\u0005Qk\u0016B\u00010\u001a\u00059)fn]3oiJ+\u0017/^3tiN\fq\"\u001e8tK:$(+Z9vKN$8\u000fI\u0001\u0011O\u0016tWM]1uKJ+\u0017/^3tiN$\u0012A\u0019\t\u0004G\"\\gB\u00013g\u001d\tIS-C\u0001.\u0013\t9G&A\u0004qC\u000e\\\u0017mZ3\n\u0005%T'\u0001C%uKJ\f'\r\\3\u000b\u0005\u001dd\u0003C\u0001+m\u0013\ti\u0017DA\u000eSKF,Xm\u001d;B]\u0012\u001cu.\u001c9mKRLwN\u001c%b]\u0012dWM]\u0001\u0012Q\u0006\u001cXK\\:f]R\u0014V-];fgR\u001cX#A'\u0002\u0011MDW\u000f\u001e3po:$\u0012A\u001d\t\u0003\u0005NL!\u0001\u001e\u0017\u0003\tUs\u0017\u000e^\u0001\u0017IJ\f\u0017N\\$f]\u0016\u0014\u0018\r^3e%\u0016\fX/Z:ug\u0006A\u0001o\u001c7m\u001f:\u001cW\r\u0006\u0002sq\")\u00110\u0004a\u0001u\u0006aQ.\u0019=US6,w.\u001e;NgB\u0011!i_\u0005\u0003y2\u0012A\u0001T8oO\u00061Am\\,pe.\fAb]3oIJ+\u0017/^3tiN$RA_A\u0001\u0003\u000bAa!a\u0001\u0010\u0001\u0004Q\u0018a\u00018po\")\u0011p\u0004a\u0001u\u0006\u00012\r[3dW\u0012K7oY8o]\u0016\u001cGo\u001d\u000b\u0004e\u0006-\u0001BBA\u0002!\u0001\u0007!0A\ngC&dW\t\u001f9je\u0016$'+Z9vKN$8\u000fF\u0002s\u0003#Aa!a\u0001\u0012\u0001\u0004Q\u0018AF2p[BdW\r^3XSRDG)[:d_:tWm\u0019;\u0015\u000fI\f9\"!\t\u0002$!9\u0011\u0011\u0004\nA\u0002\u0005m\u0011a\u0002:fcV,7\u000f\u001e\t\u0004m\u0005u\u0011bAA\u0010o\ti1\t\\5f]R\u0014V-];fgRDa!a\u0001\u0013\u0001\u0004Q\bbBA\u0013%\u0001\u0007\u0011qE\u0001\u0018CV$\b.\u001a8uS\u000e\fG/[8o\u000bb\u001cW\r\u001d;j_:\u0004B!!\u000b\u000205\u0011\u00111\u0006\u0006\u0004\u0003[I\u0015AB3se>\u00148/\u0003\u0003\u00022\u0005-\"aF!vi\",g\u000e^5dCRLwN\\#yG\u0016\u0004H/[8o\u0003\u00199\u0018m[3va\u0006)\u0012J\u001c;fe\n\u0013xn[3s'\u0016tG\r\u00165sK\u0006$\u0007C\u0001+\u0016'\r)\u00121\b\t\u0004\u0005\u0006u\u0012bAA Y\t1\u0011I\\=SK\u001a$\"!a\u000e\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\t9EK\u0002N\u0003\u0013Z#!a\u0013\u0011\t\u00055\u0013qK\u0007\u0003\u0003\u001fRA!!\u0015\u0002T\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003+b\u0013AC1o]>$\u0018\r^5p]&!\u0011\u0011LA(\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public abstract class InterBrokerSendThread
extends ShutdownableThread {
    private final KafkaClient networkClient;
    private final int requestTimeoutMs;
    private final Time time;
    private final UnsentRequests unsentRequests;

    public static boolean $lessinit$greater$default$5() {
        return true;
    }

    private UnsentRequests unsentRequests() {
        return this.unsentRequests;
    }

    public abstract Iterable<RequestAndCompletionHandler> generateRequests();

    public boolean hasUnsentRequests() {
        return this.unsentRequests().iterator().hasNext();
    }

    @Override
    public void shutdown() {
        this.initiateShutdown();
        this.networkClient.initiateClose();
        this.awaitShutdown();
        this.networkClient.close();
    }

    private void drainGeneratedRequests() {
        this.generateRequests().foreach((Function1 & Serializable)request -> {
            InterBrokerSendThread.$anonfun$drainGeneratedRequests$1(this, request);
            return BoxedUnit.UNIT;
        });
    }

    public void pollOnce(long maxTimeoutMs) {
        try {
            this.drainGeneratedRequests();
            long now = this.time.milliseconds();
            long timeout = this.sendRequests(now, maxTimeoutMs);
            this.networkClient.poll(timeout, now);
            now = this.time.milliseconds();
            this.checkDisconnects(now);
            this.failExpiredRequests(now);
            this.unsentRequests().clean();
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof DisconnectException && !this.networkClient.active()) {
                return;
            }
            if (throwable instanceof FatalExitError) {
                throw (FatalExitError)throwable;
            }
            if (throwable != null) {
                this.error((Function0<String>)(Function0 & Serializable)() -> "unhandled exception caught in InterBrokerSendThread", (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
                throw new FatalExitError();
            }
            throw null;
        }
    }

    @Override
    public void doWork() {
        this.pollOnce(Long.MAX_VALUE);
    }

    private long sendRequests(long now, long maxTimeoutMs) {
        LongRef pollTimeout = LongRef.create((long)maxTimeoutMs);
        CollectionConverters$.MODULE$.SetHasAsScala(this.unsentRequests().nodes()).asScala().foreach((Function1 & Serializable)node -> {
            InterBrokerSendThread.$anonfun$sendRequests$1(this, now, pollTimeout, node);
            return BoxedUnit.UNIT;
        });
        return pollTimeout.elem;
    }

    /*
     * WARNING - void declaration
     */
    private void checkDisconnects(long now) {
        Iterator<Map.Entry<Node, ArrayDeque<ClientRequest>>> iterator = this.unsentRequests().iterator();
        while (iterator.hasNext()) {
            void var5_4;
            void var6_5;
            Map.Entry<Node, ArrayDeque<ClientRequest>> entry = iterator.next();
            ArrayDeque<ClientRequest> arrayDeque = entry.getValue();
            Node node = entry.getKey();
            ArrayDeque<ClientRequest> requests = arrayDeque;
            if (var6_5.isEmpty() || !this.networkClient.connectionFailed((Node)var5_4)) continue;
            iterator.remove();
            CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)var6_5).asScala().foreach(arg_0 -> InterBrokerSendThread.$anonfun$checkDisconnects$1$adapted(this, (Node)var5_4, now, arg_0));
        }
    }

    private void failExpiredRequests(long now) {
        Collection<ClientRequest> timedOutRequests = this.unsentRequests().removeAllTimedOut(now);
        CollectionConverters$.MODULE$.CollectionHasAsScala(timedOutRequests).asScala().foreach((Function1 & Serializable)request -> {
            InterBrokerSendThread.$anonfun$failExpiredRequests$1(this, now, request);
            return BoxedUnit.UNIT;
        });
    }

    public void completeWithDisconnect(ClientRequest request, long now, AuthenticationException authenticationException) {
        RequestCompletionHandler handler = request.callback();
        handler.onComplete(new ClientResponse(request.makeHeader(request.requestBuilder().latestAllowedVersion()), handler, request.destination(), now, now, true, null, authenticationException, null));
    }

    public void wakeup() {
        this.networkClient.wakeup();
    }

    public static final /* synthetic */ void $anonfun$drainGeneratedRequests$1(InterBrokerSendThread $this, RequestAndCompletionHandler request) {
        $this.unsentRequests().put(request.destination(), $this.networkClient.newClientRequest(request.destination().idString(), request.request(), request.creationTimeMs(), true, $this.requestTimeoutMs, request.handler()));
    }

    public static final /* synthetic */ void $anonfun$sendRequests$1(InterBrokerSendThread $this, long now$1, LongRef pollTimeout$1, Node node) {
        Iterator<ClientRequest> requestIterator = $this.unsentRequests().requestIterator(node);
        while (requestIterator.hasNext()) {
            ClientRequest request = requestIterator.next();
            if ($this.networkClient.ready(node, now$1)) {
                $this.networkClient.send(request, now$1);
                requestIterator.remove();
                continue;
            }
            pollTimeout$1.elem = Math.min(pollTimeout$1.elem, $this.networkClient.connectionDelay(node, now$1));
        }
    }

    public static final /* synthetic */ void $anonfun$checkDisconnects$1(InterBrokerSendThread $this, Node node$1, long now$2, ClientRequest request) {
        AuthenticationException authenticationException = $this.networkClient.authenticationException(node$1);
        if (authenticationException != null) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(66).append("Failed to send the following request due to authentication error: ").append(request).toString());
        }
        $this.completeWithDisconnect(request, now$2, authenticationException);
    }

    public static final /* synthetic */ void $anonfun$failExpiredRequests$1(InterBrokerSendThread $this, long now$3, ClientRequest request) {
        $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Failed to send the following request after ").append(request.requestTimeoutMs()).append(" ms: ").append(request).toString());
        $this.completeWithDisconnect(request, now$3, null);
    }

    public InterBrokerSendThread(String name, KafkaClient networkClient, int requestTimeoutMs, Time time, boolean isInterruptible) {
        this.networkClient = networkClient;
        this.requestTimeoutMs = requestTimeoutMs;
        this.time = time;
        super(name, isInterruptible);
        this.unsentRequests = new UnsentRequests();
    }

    public static final /* synthetic */ Object $anonfun$checkDisconnects$1$adapted(InterBrokerSendThread $this, Node node$1, long now$2, ClientRequest request) {
        InterBrokerSendThread.$anonfun$checkDisconnects$1($this, node$1, now$2, request);
        return BoxedUnit.UNIT;
    }
}

