/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.server.metadata;

import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.log.UnifiedLog;
import kafka.server.BrokerServer;
import kafka.server.KafkaConfig$;
import kafka.server.metadata.BrokerMetadataPublisher;
import kafka.server.metadata.BrokerMetadataPublisher$;
import kafka.server.metadata.MetadataPublisher;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.image.MetadataImageTest;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005m4A\u0001C\u0005\u0001%!)\u0011\u0004\u0001C\u00015!)Q\u0004\u0001C\u0001=!)q\u0006\u0001C\u0001=!)\u0011\u0007\u0001C\u0005e!)!\n\u0001C\u0005\u0017\")\u0011\u000f\u0001C\u0005e\")\u0011\u0010\u0001C\u0001=\tY\"I]8lKJlU\r^1eCR\f\u0007+\u001e2mSNDWM\u001d+fgRT!AC\u0006\u0002\u00115,G/\u00193bi\u0006T!\u0001D\u0007\u0002\rM,'O^3s\u0015\tqq\"A\u0003lC\u001a\\\u0017MC\u0001\u0011\u0003\u0011)h.\u001b;\u0004\u0001M\u0011\u0001a\u0005\t\u0003)]i\u0011!\u0006\u0006\u0002-\u0005)1oY1mC&\u0011\u0001$\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005I\u0011!\u0005;fgR<U\r\u001e+pa&\u001cG)\u001a7uCR\tq\u0004\u0005\u0002\u0015A%\u0011\u0011%\u0006\u0002\u0005+:LG\u000f\u000b\u0002\u0003GA\u0011A%L\u0007\u0002K)\u0011aeJ\u0001\u0004CBL'B\u0001\u0015*\u0003\u001dQW\u000f]5uKJT!AK\u0016\u0002\u000b),h.\u001b;\u000b\u00031\n1a\u001c:h\u0013\tqSE\u0001\u0003UKN$\u0018!\u0006;fgR4\u0015N\u001c3TiJ\f\u0017PU3qY&\u001c\u0017m\u001d\u0015\u0003\u0007\r\nq!\\8dW2{w\rF\u00024u\u0015\u0003\"\u0001\u000e\u001d\u000e\u0003UR!AN\u001c\u0002\u00071|wMC\u0001\u000f\u0013\tITG\u0001\u0006V]&4\u0017.\u001a3M_\u001eDQa\u000f\u0003A\u0002q\nq\u0001^8qS\u000eLE\r\u0005\u0002>\u00076\taH\u0003\u0002@\u0001\u000611m\\7n_:T!AD!\u000b\u0005\t[\u0013AB1qC\u000eDW-\u0003\u0002E}\t!Q+^5e\u0011\u00151E\u00011\u0001H\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"!\u0010%\n\u0005%s$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u000bi>\u0004\u0018nY%nC\u001e,G\u0003\u0002'S'\u0002\u0004\"!\u0014)\u000e\u00039S!a\u0014!\u0002\u000b%l\u0017mZ3\n\u0005Es%A\u0003+pa&\u001c\u0017*\\1hK\")1(\u0002a\u0001y!)A+\u0002a\u0001+\u0006)Ao\u001c9jGB\u0011a+\u0018\b\u0003/n\u0003\"\u0001W\u000b\u000e\u0003eS!AW\t\u0002\rq\u0012xn\u001c;?\u0013\taV#\u0001\u0004Qe\u0016$WMZ\u0005\u0003=~\u0013aa\u0015;sS:<'B\u0001/\u0016\u0011\u0015\tW\u00011\u0001c\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0005-\u000e,\u0007.\u0003\u0002e?\n\u0019Q*\u00199\u0011\u0005Q1\u0017BA4\u0016\u0005\rIe\u000e\u001e\t\u0004S:,gB\u00016m\u001d\tA6.C\u0001\u0017\u0013\tiW#A\u0004qC\u000e\\\u0017mZ3\n\u0005=\u0004(aA*fc*\u0011Q.F\u0001\fi>\u0004\u0018nY:J[\u0006<W\r\u0006\u0002tmB\u0011Q\n^\u0005\u0003k:\u00131\u0002V8qS\u000e\u001c\u0018*\\1hK\")qO\u0002a\u0001q\u00061Ao\u001c9jGN\u00042!\u001b8M\u0003%\"Xm\u001d;SK2|\u0017\rZ+qI\u0006$X\r\u001a$jY\u0016\u001cx+\u001b;i_V$8i\u001c8gS\u001e\u001c\u0005.\u00198hK\"\u0012qa\t")
public class BrokerMetadataPublisherTest {
    @Test
    public void testGetTopicDelta() {
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("not-a-topic", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isEmpty(), (Function0 & Serializable)() -> "Expected no delta for unknown topic");
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("foo", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isEmpty(), (Function0 & Serializable)() -> "Expected no delta for deleted topic");
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("bar", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isDefined(), (Function0 & Serializable)() -> "Expected to see delta for changed topic");
    }

    @Test
    public void testFindStrayReplicas() {
        int brokerId = 0;
        String deletedTopic = "a";
        Uuid deletedTopicId = Uuid.randomUuid();
        TopicPartition deletedTopicPartition1 = new TopicPartition(deletedTopic, 0);
        UnifiedLog deletedTopicLog1 = this.mockLog(deletedTopicId, deletedTopicPartition1);
        TopicPartition deletedTopicPartition2 = new TopicPartition(deletedTopic, 1);
        UnifiedLog deletedTopicLog2 = this.mockLog(deletedTopicId, deletedTopicPartition2);
        String recreatedTopic = "b";
        TopicPartition recreatedTopicPartition = new TopicPartition(recreatedTopic, 0);
        UnifiedLog recreatedTopicLog = this.mockLog(Uuid.randomUuid(), recreatedTopicPartition);
        TopicImage recreatedTopicImage = this.topicImage(Uuid.randomUuid(), recreatedTopic, (scala.collection.immutable.Map<Object, Seq<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)recreatedTopicPartition.partition())), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}))));
        String reassignedTopic = "c";
        Uuid reassignedTopicId = Uuid.randomUuid();
        TopicPartition reassignedTopicPartition = new TopicPartition(reassignedTopic, 0);
        UnifiedLog reassignedTopicLog = this.mockLog(reassignedTopicId, reassignedTopicPartition);
        TopicPartition retainedTopicPartition = new TopicPartition(reassignedTopic, 1);
        UnifiedLog retainedTopicLog = this.mockLog(reassignedTopicId, retainedTopicPartition);
        TopicImage reassignedTopicImage = this.topicImage(reassignedTopicId, reassignedTopic, (scala.collection.immutable.Map<Object, Seq<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)reassignedTopicPartition.partition())), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)retainedTopicPartition.partition())), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 3})))}))));
        Seq logs = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnifiedLog[]{deletedTopicLog1, deletedTopicLog2, recreatedTopicLog, reassignedTopicLog, retainedTopicLog}));
        TopicsImage image = this.topicsImage((Seq<TopicImage>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicImage[]{recreatedTopicImage, reassignedTopicImage}))));
        Set expectedStrayPartitions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{deletedTopicPartition1, deletedTopicPartition2, recreatedTopicPartition, reassignedTopicPartition}));
        Set strayPartitions = BrokerMetadataPublisher$.MODULE$.findStrayPartitions(brokerId, image, (Iterable)logs).toSet();
        Assertions.assertEquals((Object)expectedStrayPartitions, (Object)strayPartitions);
    }

    /*
     * WARNING - void declaration
     */
    private UnifiedLog mockLog(Uuid topicId, TopicPartition topicPartition) {
        void var3_3;
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)log.topicId()).thenReturn((Object)new Some((Object)topicId));
        Mockito.when((Object)log.topicPartition()).thenReturn((Object)topicPartition);
        return var3_3;
    }

    private TopicImage topicImage(Uuid topicId, String topic, scala.collection.immutable.Map<Object, Seq<Object>> partitions) {
        scala.collection.immutable.Map partitionRegistrations = (scala.collection.immutable.Map)partitions.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int partitionId = x0$1._1$mcI$sp();
            Seq replicas = (Seq)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partitionId)), (Object)new PartitionRegistration((int[])replicas.toArray((ClassTag)ClassTag$.MODULE$.Int()), (int[])replicas.toArray((ClassTag)ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int()), BoxesRunTime.unboxToInt((Object)replicas.head()), LeaderRecoveryState.RECOVERED, 0, 0));
            return tuple2;
        });
        return new TopicImage(topic, topicId, CollectionConverters$.MODULE$.MapHasAsJava((Map)partitionRegistrations).asJava());
    }

    private TopicsImage topicsImage(Seq<TopicImage> topics) {
        scala.collection.immutable.Map idsMap = ((IterableOnceOps)topics.map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t.id()), t))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map namesMap = ((IterableOnceOps)topics.map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t.name()), t))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return new TopicsImage(CollectionConverters$.MODULE$.MapHasAsJava((Map)idsMap).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)namesMap).asJava());
    }

    @Test
    public void testReloadUpdatedFilesWithoutConfigChange() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            BrokerServer broker = cluster.brokers().values().iterator().next();
            BrokerMetadataPublisher publisher = (BrokerMetadataPublisher)Mockito.spy((Object)new BrokerMetadataPublisher(broker.config(), broker.metadataCache(), broker.logManager(), broker.replicaManager(), broker.groupCoordinator(), broker.transactionCoordinator(), broker.clientQuotaMetadataManager(), broker.featureCache(), broker.dynamicConfigHandlers().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), Option$.MODULE$.empty()));
            AtomicInteger numTimesReloadCalled = new AtomicInteger(0);
            publisher.reloadUpdatedFilesWithoutConfigChange((Properties)ArgumentMatchers.any());
            Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(null, numTimesReloadCalled){
                private final AtomicInteger numTimesReloadCalled$1;

                public void answer(InvocationOnMock invocation) {
                    this.numTimesReloadCalled$1.addAndGet(1);
                }
                {
                    this.numTimesReloadCalled$1 = numTimesReloadCalled$1;
                }
            });
            broker.metadataListener().alterPublisher((MetadataPublisher)publisher).get();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Assertions.assertEquals((int)0, (int)numTimesReloadCalled.get());
                admin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), Collections.singleton(new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.MaxConnectionsProp(), "123"), AlterConfigOp.OpType.SET)))).all().get();
                long l = 15000L;
                long l2 = 100L;
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!BrokerMetadataPublisherTest.$anonfun$testReloadUpdatedFilesWithoutConfigChange$1(numTimesReloadCalled)) {
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                        Assertions.fail((String)BrokerMetadataPublisherTest.$anonfun$testReloadUpdatedFilesWithoutConfigChange$2());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
                }
                admin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(broker.config().nodeId())), Collections.singleton(new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.MaxConnectionsProp(), "123"), AlterConfigOp.OpType.SET)))).all().get();
                long l3 = 15000L;
                long l4 = 100L;
                long waitUntilTrue_startTime2 = System.currentTimeMillis();
                while (!BrokerMetadataPublisherTest.$anonfun$testReloadUpdatedFilesWithoutConfigChange$3(numTimesReloadCalled)) {
                    if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                        Assertions.fail((String)BrokerMetadataPublisherTest.$anonfun$testReloadUpdatedFilesWithoutConfigChange$4());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
                }
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$testReloadUpdatedFilesWithoutConfigChange$1(AtomicInteger numTimesReloadCalled$1) {
        return numTimesReloadCalled$1.get() == 0;
    }

    public static final /* synthetic */ String $anonfun$testReloadUpdatedFilesWithoutConfigChange$2() {
        return "numTimesConfigured never reached desired value";
    }

    public static final /* synthetic */ boolean $anonfun$testReloadUpdatedFilesWithoutConfigChange$3(AtomicInteger numTimesReloadCalled$1) {
        return numTimesReloadCalled$1.get() == 1;
    }

    public static final /* synthetic */ String $anonfun$testReloadUpdatedFilesWithoutConfigChange$4() {
        return "numTimesConfigured never reached desired value";
    }
}

