/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.time.Duration;
import java.util.Collection;
import java.util.Properties;
import java.util.stream.Stream;
import kafka.api.AbstractConsumerTest;
import kafka.api.BaseConsumerTest$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaServer;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@Timeout(value=600L)
@ScalaSignature(bytes="\u0006\u0005\u0005Ec\u0001B\b\u0011\u0001UAQA\u0007\u0001\u0005\u0002mAQ!\b\u0001\u0005\u0002yAQa\u0014\u0001\u0005\u0002ACQA\u0016\u0001\u0005\u0002]CQ!\u0018\u0001\u0005\u0002yCQ\u0001\u001a\u0001\u0005\u0002\u0015DQa\u001b\u0001\u0005\u00021DQa\u001e\u0001\u0005\u0002aDQA \u0001\u0005\u0002}Dq!a\u0003\u0001\t\u0003\tiaB\u0004\u0002(AA\t!!\u000b\u0007\r=\u0001\u0002\u0012AA\u0016\u0011\u0019QB\u0002\"\u0001\u00024!1a\n\u0004C\u0001\u0003k\u00111\u0004\u00157bS:$X\r\u001f;D_:\u001cX/\\3s\u0003N\u001c\u0018n\u001a8UKN$(BA\t\u0013\u0003\r\t\u0007/\u001b\u0006\u0002'\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0017!\t9\u0002$D\u0001\u0011\u0013\tI\u0002C\u0001\u000bBEN$(/Y2u\u0007>t7/^7feR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0001\"a\u0006\u0001\u0002IQ,7\u000f^!tg&<g.\u00118e\u0007>lW.\u001b;Bgft7MT8u\u0007>lW.\u001b;uK\u0012$2aH\u00133!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0011)f.\u001b;\t\u000b\u0019\u0012\u0001\u0019A\u0014\u0002\rE,xN];n!\tAsF\u0004\u0002*[A\u0011!&I\u0007\u0002W)\u0011A\u0006F\u0001\u0007yI|w\u000e\u001e \n\u00059\n\u0013A\u0002)sK\u0012,g-\u0003\u00021c\t11\u000b\u001e:j]\u001eT!AL\u0011\t\u000bM\u0012\u0001\u0019A\u0014\u0002\u001b\u001d\u0014x.\u001e9Qe>$xnY8mQ\u0011\u0011Q'\u0011\"\u0011\u0005YzT\"A\u001c\u000b\u0005aJ\u0014A\u00029be\u0006l7O\u0003\u0002;w\u00059!.\u001e9ji\u0016\u0014(B\u0001\u001f>\u0003\u0015QWO\\5u\u0015\u0005q\u0014aA8sO&\u0011\u0001i\u000e\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f\u0013aQ\u0001+w\u0012L7\u000f\u001d7bs:\u000bW.Z?/cV|'/^7>wBjhf\u001a:pkB\u0004&o\u001c;pG>dWh_\u0019~Q\u0011\u0011Qi\u0013'\u0011\u0005\u0019KU\"A$\u000b\u0005!;\u0014\u0001\u00039s_ZLG-\u001a:\n\u0005);%\u0001D'fi\"|GmU8ve\u000e,\u0017!\u0002<bYV,G&A'\"\u00039\u000b!fZ3u)\u0016\u001cH/U;peVl\u0017I\u001c3He>,\b\u000f\u0015:pi>\u001cw\u000e\u001c)be\u0006lW\r^3sg\u0006cG.A\u0012uKN$\u0018i]:jO:\fe\u000eZ\"p[6LGoU=oG:{GoQ8n[&$H/\u001a3\u0015\u0007}\t&\u000bC\u0003'\u0007\u0001\u0007q\u0005C\u00034\u0007\u0001\u0007q\u0005\u000b\u0003\u0004k\u0005\u0013\u0005\u0006B\u0002F\u0017Vc\u0013!T\u0001#i\u0016\u001cH/Q:tS\u001et\u0017I\u001c3D_6l\u0017\u000e^*z]\u000e\fE\u000e\\\"p]N,X.\u001a3\u0015\u0007}A\u0016\fC\u0003'\t\u0001\u0007q\u0005C\u00034\t\u0001\u0007q\u0005\u000b\u0003\u0005k\u0005\u0013\u0005\u0006\u0002\u0003F\u0017rc\u0013!T\u0001\u0015i\u0016\u001cH/Q:tS\u001et\u0017I\u001c3D_:\u001cX/\\3\u0015\u0007}y\u0006\rC\u0003'\u000b\u0001\u0007q\u0005C\u00034\u000b\u0001\u0007q\u0005\u000b\u0003\u0006k\u0005\u0013\u0005\u0006B\u0003F\u0017\u000ed\u0013!T\u0001%i\u0016\u001cH/Q:tS\u001et\u0017I\u001c3D_:\u001cX/\\3TW&\u0004\b/\u001b8h!>\u001c\u0018\u000e^5p]R\u0019qDZ4\t\u000b\u00192\u0001\u0019A\u0014\t\u000bM2\u0001\u0019A\u0014)\t\u0019)\u0014I\u0011\u0015\u0005\r\u0015[%\u000eL\u0001N\u0003]\"Xm\u001d;BgNLwM\\!oI\u000e{gn];nK^KG\u000f\u001b'fC\u0012,'o\u00115b]\u001e,g+\u00197jI\u0006$\u0018N\\4Q_NLG/[8ogR\u0019q$\u001c8\t\u000b\u0019:\u0001\u0019A\u0014\t\u000bM:\u0001\u0019A\u0014)\t\u001d)\u0014I\u0011\u0015\u0005\u000fE\\E\u000f\u0005\u0002Ge&\u00111o\u0012\u0002\n\u0007N48k\\;sG\u0016d\u0013!^\u0011\u0002m\u0006Y!p\u001b\u0017!G2\f7o]5d\u0003\t\"Xm\u001d;BgNLwM\\!oI\u001a+Go\u00195D_6l\u0017\u000e\u001e;fI>3gm]3ugR\u0019q$\u001f>\t\u000b\u0019B\u0001\u0019A\u0014\t\u000bMB\u0001\u0019A\u0014)\t!)\u0014I\u0011\u0015\u0005\u0011\u0015[U\u0010L\u0001N\u0003!\"Xm\u001d;BgNLwM\\!oI\u000e{gn];nK\u001a\u0013x.\\\"p[6LG\u000f^3e\u001f\u001a47/\u001a;t)\u0015y\u0012\u0011AA\u0002\u0011\u00151\u0013\u00021\u0001(\u0011\u0015\u0019\u0014\u00021\u0001(Q\u0011IQ'\u0011\")\u000b%)5*!\u0003-\u00035\u000bA\u0007^3ti\u0006\u001b8/[4o\u0003:$'+\u001a;sS\u00164\u0018N\\4D_6l\u0017\u000e\u001e;fI>3gm]3ug6+H\u000e^5qY\u0016$\u0016.\\3t)\u0015y\u0012qBA\t\u0011\u00151#\u00021\u0001(\u0011\u0015\u0019$\u00021\u0001(Q\u0011QQ'\u0011\")\u000b))5*a\u0006-\u00035Cc\u0001AA\u000e\u0017\u0006\u0015\u0002\u0003BA\u000f\u0003Ci!!a\b\u000b\u0005EI\u0014\u0002BA\u0012\u0003?\u0011q\u0001V5nK>,HO\b\u0002\u00031\u0006Y\u0002\u000b\\1j]R,\u0007\u0010^\"p]N,X.\u001a:BgNLwM\u001c+fgR\u0004\"a\u0006\u0007\u0014\u00071\ti\u0003E\u0002!\u0003_I1!!\r\"\u0005\u0019\te.\u001f*fMR\u0011\u0011\u0011F\u000b\u0003\u0003o\u0001b!!\u000f\u0002H\u0005-SBAA\u001e\u0015\u0011\ti$a\u0010\u0002\rM$(/Z1n\u0015\u0011\t\t%a\u0011\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u000b\nAA[1wC&!\u0011\u0011JA\u001e\u0005\u0019\u0019FO]3b[B\u0019a)!\u0014\n\u0007\u0005=sIA\u0005Be\u001e,X.\u001a8ug\u0002")
public class PlaintextConsumerAssignTest
extends AbstractConsumerTest {
    public static Stream<Arguments> getTestQuorumAndGroupProtocolParametersAll() {
        return BaseConsumerTest$.MODULE$.getTestQuorumAndGroupProtocolParametersAll();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testAssignAndCommitAsyncNotCommitted(String quorum, String groupProtocol) {
        Properties props = new Properties();
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, props, x$4);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        int numRecords = 10000;
        long startingTimestamp = System.currentTimeMillis();
        AbstractConsumerTest.CountConsumerCommitCallback cb = new AbstractConsumerTest.CountConsumerCommitCallback();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.commitAsync((OffsetCommitCallback)cb);
        long pollUntilTrue_waitTimeMs = 10000L;
        long pollUntilTrue_waitUntilTrue_pause = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            consumer.poll(Duration.ofMillis(100L));
            if (PlaintextConsumerAssignTest.$anonfun$testAssignAndCommitAsyncNotCommitted$1(cb)) break;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to observe commit callback before timeout");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(pollUntilTrue_waitTimeMs), pollUntilTrue_waitUntilTrue_pause));
        }
        java.util.Map committedOffset = consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assertions.assertNotNull((Object)committedOffset);
        Assertions.assertNull(committedOffset.get(this.tp()));
        Assertions.assertTrue((boolean)consumer.assignment().contains(this.tp()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testAssignAndCommitSyncNotCommitted(String quorum, String groupProtocol) {
        Properties props = new Properties();
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, props, x$4);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        int numRecords = 10000;
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.commitSync();
        java.util.Map committedOffset = consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assertions.assertNotNull((Object)committedOffset);
        Assertions.assertNull(committedOffset.get(this.tp()));
        Assertions.assertTrue((boolean)consumer.assignment().contains(this.tp()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testAssignAndCommitSyncAllConsumed(String quorum, String groupProtocol) {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        Properties props = new Properties();
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, props, x$4);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.seek(this.tp(), 0L);
        int x$9 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$10 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$11 = this.consumeAndVerifyRecords$default$7();
        int x$12 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$9, startingTimestamp, x$10, x$11, x$12);
        consumer.commitSync();
        java.util.Map committedOffset = consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assertions.assertNotNull((Object)committedOffset);
        Assertions.assertNotNull(committedOffset.get(this.tp()));
        Assertions.assertEquals((long)numRecords, (long)((OffsetAndMetadata)committedOffset.get(this.tp())).offset());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testAssignAndConsume(String quorum, String groupProtocol) {
        int numRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        Properties props = new Properties();
        .colon.colon x$2 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$3 = this.createConsumer$default$1();
        ByteArrayDeserializer x$4 = this.createConsumer$default$2();
        Consumer consumer = this.createConsumer(x$3, x$4, props, (List<String>)x$2);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        int x$9 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$10 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$11 = this.consumeAndVerifyRecords$default$7();
        int x$12 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$9, startingTimestamp, x$10, x$11, x$12);
        Assertions.assertEquals((long)numRecords, (long)consumer.position(this.tp()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testAssignAndConsumeSkippingPosition(String quorum, String groupProtocol) {
        int numRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        Properties props = new Properties();
        .colon.colon x$2 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$3 = this.createConsumer$default$1();
        ByteArrayDeserializer x$4 = this.createConsumer$default$2();
        Consumer consumer = this.createConsumer(x$3, x$4, props, (List<String>)x$2);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        int offset = 1;
        consumer.seek(this.tp(), (long)offset);
        this.consumeAndVerifyRecords(consumer, numRecords - offset, offset, offset, startingTimestamp + (long)offset, this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        Assertions.assertEquals((long)numRecords, (long)consumer.position(this.tp()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @CsvSource(value={"zk, classic"})
    public void testAssignAndConsumeWithLeaderChangeValidatingPositions(String quorum, String groupProtocol) {
        int numRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        Properties props = new Properties();
        .colon.colon x$2 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$3 = this.createConsumer$default$1();
        ByteArrayDeserializer x$4 = this.createConsumer$default$2();
        Consumer consumer = this.createConsumer(x$3, x$4, props, (List<String>)x$2);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        int x$9 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$10 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$11 = this.consumeAndVerifyRecords$default$7();
        int x$12 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$9, startingTimestamp, x$10, x$11, x$12);
        Buffer parts = null;
        while (parts == null) {
            parts = CollectionConverters$.MODULE$.ListHasAsScala(consumer.partitionsFor(this.tp().topic())).asScala();
        }
        int leader = ((PartitionInfo)parts.head()).leader().id();
        ((KafkaBroker)this.servers().apply(leader)).shutdown();
        ((KafkaServer)this.servers().apply(leader)).startup();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        int x$17 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$18 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$19 = this.consumeAndVerifyRecords$default$7();
        int x$20 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer, numRecords, 10, x$17, startingTimestamp, x$18, x$19, x$20);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testAssignAndFetchCommittedOffsets(String quorum, String groupProtocol) {
        int numRecords = 100;
        long startingTimestamp = System.currentTimeMillis();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        Properties props = new Properties();
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, props, x$4);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.seek(this.tp(), 0L);
        int x$9 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$10 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$11 = this.consumeAndVerifyRecords$default$7();
        int x$12 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$9, startingTimestamp, x$10, x$11, x$12);
        consumer.commitSync();
        Assertions.assertEquals((long)numRecords, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        ByteArrayDeserializer x$14 = this.createConsumer$default$1();
        ByteArrayDeserializer x$15 = this.createConsumer$default$2();
        List<String> x$16 = this.createConsumer$default$4();
        Consumer anotherConsumer = this.createConsumer(x$14, x$15, props, x$16);
        anotherConsumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((long)numRecords, (long)((OffsetAndMetadata)anotherConsumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testAssignAndConsumeFromCommittedOffsets(String quorum, String groupProtocol) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        int numRecords = 100;
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        Properties props = new Properties();
        props.setProperty("group.id", "group1");
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, props, x$4);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        int offset = 10;
        consumer.commitSync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata((long)offset))}))).asJava());
        Assertions.assertEquals((long)offset, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        consumer.close();
        ByteArrayDeserializer x$6 = this.createConsumer$default$1();
        ByteArrayDeserializer x$7 = this.createConsumer$default$2();
        List<String> x$8 = this.createConsumer$default$4();
        Consumer anotherConsumer = this.createConsumer(x$6, x$7, props, x$8);
        Assertions.assertEquals((long)offset, (long)((OffsetAndMetadata)anotherConsumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        anotherConsumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.consumeAndVerifyRecords(anotherConsumer, numRecords - offset, offset, offset, startingTimestamp + (long)offset, this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testAssignAndRetrievingCommittedOffsetsMultipleTimes(String quorum, String groupProtocol) {
        int numRecords = 100;
        long startingTimestamp = System.currentTimeMillis();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        Properties props = new Properties();
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, props, x$4);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.seek(this.tp(), 0L);
        int x$9 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$10 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$11 = this.consumeAndVerifyRecords$default$7();
        int x$12 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$9, startingTimestamp, x$10, x$11, x$12);
        consumer.commitSync();
        Assertions.assertEquals((long)numRecords, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((long)numRecords, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
    }

    public static final /* synthetic */ boolean $anonfun$testAssignAndCommitAsyncNotCommitted$1(AbstractConsumerTest.CountConsumerCommitCallback cb$1) {
        return cb$1.successCount() >= 1 || cb$1.lastError().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testAssignAndCommitAsyncNotCommitted$2() {
        return "Failed to observe commit callback before timeout";
    }
}

