/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.TreeMap;
import kafka.coordinator.transaction.BaseKey;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.coordinator.transaction.UnknownKey;
import kafka.internals.generated.TransactionLogKey;
import kafka.internals.generated.TransactionLogValue;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00194A\u0001E\t\u00011!)q\u0004\u0001C\u0001A!91\u0005\u0001b\u0001\n\u0003!\u0003B\u0002\u0015\u0001A\u0003%Q\u0005C\u0004*\u0001\t\u0007I\u0011\u0001\u0016\t\r9\u0002\u0001\u0015!\u0003,\u0011\u001dy\u0003A1A\u0005\u0002ABaa\u0012\u0001!\u0002\u0013\t\u0004\"\u0002%\u0001\t\u0003I\u0005\"\u0002-\u0001\t\u0003I\u0005\"\u0002.\u0001\t\u0003I\u0005\"\u0002/\u0001\t\u0003I\u0005\"\u00020\u0001\t\u0003I\u0005\"\u00021\u0001\t\u0003I\u0005\"\u00022\u0001\t\u0003I\u0005\"\u00023\u0001\t\u0003I%A\u0005+sC:\u001c\u0018m\u0019;j_:dun\u001a+fgRT!AE\n\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003)U\t1bY8pe\u0012Lg.\u0019;pe*\ta#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001I\u0002C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002CA\u0011!\u0005A\u0007\u0002#\u0005i\u0001O]8ek\u000e,'/\u00129pG\",\u0012!\n\t\u00035\u0019J!aJ\u000e\u0003\u000bMCwN\u001d;\u0002\u001dA\u0014x\u000eZ;dKJ,\u0005o\\2iA\u0005!BO]1og\u0006\u001cG/[8o)&lWm\\;u\u001bN,\u0012a\u000b\t\u000351J!!L\u000e\u0003\u0007%sG/A\u000bue\u0006t7/Y2uS>tG+[7f_V$Xj\u001d\u0011\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N,\u0012!\r\t\u0004eebdBA\u001a8!\t!4$D\u00016\u0015\t1t#\u0001\u0004=e>|GOP\u0005\u0003qm\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001e<\u0005\r\u0019V\r\u001e\u0006\u0003qm\u0001\"!P#\u000e\u0003yR!a\u0010!\u0002\r\r|W.\\8o\u0015\t1\u0012I\u0003\u0002C\u0007\u00061\u0011\r]1dQ\u0016T\u0011\u0001R\u0001\u0004_J<\u0017B\u0001$?\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0001\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002GMDw.\u001e7e)\"\u0014xn^#yG\u0016\u0004H/[8o/JLG/Z%om\u0006d\u0017\u000e\u001a+y]R\t!\n\u0005\u0002\u001b\u0017&\u0011Aj\u0007\u0002\u0005+:LG\u000f\u000b\u0002\t\u001dB\u0011qJV\u0007\u0002!*\u0011\u0011KU\u0001\u0004CBL'BA*U\u0003\u001dQW\u000f]5uKJT!!V\"\u0002\u000b),h.\u001b;\n\u0005]\u0003&\u0001\u0002+fgR\fqc\u001d5pk2$'+Z1e/JLG/Z'fgN\fw-Z:)\u0005%q\u0015A\b;fgR$&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b!\u0006\u00148/\u001b8hQ\tQa*A\u0014uKN$HK]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uCR{WNY:u_:,\u0007+\u0019:tS:<\u0007FA\u0006O\u0003m\"Xm\u001d;TKJL\u0017\r\\5{KR\u0013\u0018M\\:bGRLwN\u001c'pOZ\u000bG.^3U_\"Kw\r[3ti:{gN\u00127fq&\u0014G.\u001a,feNLwN\u001c\u0015\u0003\u00199\u000b!\u0007^3ti\u0012+7/\u001a:jC2L'0\u001a%jO\",7\u000f^*vaB|'\u000f^3e)J\fgn]1di&|g\u000eT8h-\u0006dW/\u001a\u0015\u0003\u001b9\u000b\u0001\u0006^3ti\u0012+7/\u001a:jC2L'0\u001a$viV\u0014X\r\u0016:b]N\f7\r^5p]2{wMV1mk\u0016D#A\u0004(\u0002SQ,7\u000f\u001e*fC\u0012$\u0006P\u001c*fG>\u0014HmS3z\u0007\u0006t'+Z1e+:\\gn\\<o\u001b\u0016\u001c8/Y4fQ\tya\n")
public class TransactionLogTest {
    private final short producerEpoch;
    private final int transactionTimeoutMs;
    private final scala.collection.immutable.Set<TopicPartition> topicPartitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1), new TopicPartition("topic2", 0), new TopicPartition("topic2", 1), new TopicPartition("topic2", 2)}));

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public int transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public scala.collection.immutable.Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    @Test
    public void shouldThrowExceptionWriteInvalidTxn() {
        String transactionalId = "transactionalId";
        long producerId = 23423L;
        TransactionMetadata txnMetadata = TransactionMetadata$.MODULE$.apply(transactionalId, producerId, this.producerEpoch(), this.transactionTimeoutMs(), 0L);
        txnMetadata.addPartitions(this.topicPartitions());
        Assertions.assertThrows(IllegalStateException.class, () -> TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldReadWriteMessages() {
        void withRecords_records;
        void withRecords_compression;
        Map pidMappings = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zero"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"one"), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"two"), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"three"), (Object)BoxesRunTime.boxToLong((long)3L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"four"), (Object)BoxesRunTime.boxToLong((long)4L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"five"), (Object)BoxesRunTime.boxToLong((long)5L))}));
        Map transactionStates = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)0L)), (Object)Empty$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L)), (Object)Ongoing$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)2L)), (Object)PrepareCommit$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)3L)), (Object)CompleteCommit$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)4L)), (Object)PrepareAbort$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)5L)), (Object)CompleteAbort$.MODULE$)}));
        Seq txnRecords = ((IterableOnceOps)pidMappings.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                long producerId;
                String transactionalId = (String)x0$1._1();
                TransactionMetadata txnMetadata = TransactionMetadata$.MODULE$.apply(transactionalId, producerId = x0$1._2$mcJ$sp(), this.producerEpoch(), this.transactionTimeoutMs(), (TransactionState)transactionStates.apply((Object)BoxesRunTime.boxToLong((long)producerId)), 0L);
                if (!txnMetadata.state().equals(Empty$.MODULE$)) {
                    txnMetadata.addPartitions(this.topicPartitions());
                }
                byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
                byte[] valueBytes = TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit());
                return new SimpleRecord(keyBytes, valueBytes);
            }
            throw new MatchError(null);
        })).toSeq();
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])txnRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        NoCompression noCompression = Compression.NONE;
        long withRecords_initialOffset = 0L;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        Object var10_7 = null;
        noCompression = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        IntRef count = IntRef.create((int)0);
        CollectionConverters$.MODULE$.IterableHasAsScala(records.records()).asScala().foreach((Function1 & Serializable)record -> {
            TransactionLogTest.$anonfun$shouldReadWriteMessages$2(this, pidMappings, transactionStates, count, record);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)pidMappings.size(), (int)count.elem);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTransactionMetadataParsing() {
        void var11_10;
        void var10_9;
        String transactionalId = "id";
        long producerId = 1334L;
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        TransactionMetadata txnMetadata = TransactionMetadata$.MODULE$.apply(transactionalId, producerId, this.producerEpoch(), this.transactionTimeoutMs(), (TransactionState)Ongoing$.MODULE$, 0L);
        txnMetadata.addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition})));
        byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
        byte[] valueBytes = TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit());
        Record transactionMetadataRecord = (Record)CollectionConverters$.MODULE$.IterableHasAsScala(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord(keyBytes, valueBytes), (List)Nil$.MODULE$), (byte)2, (Compression)Compression.NONE, -1L, (short)-1, -1, 0L, -1).records()).asScala().head();
        Tuple2 tuple2 = TransactionLog$.MODULE$.formatRecordKeyAndValue(transactionMetadataRecord);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option keyStringOpt = (Option)tuple2._1();
        Option valueStringOpt = (Option)tuple2._2();
        Assertions.assertEquals((Object)new Some((Object)new StringBuilder(38).append("transaction_metadata::transactionalId=").append(transactionalId).toString()), (Object)var10_9);
        Assertions.assertEquals((Object)new Some((Object)new StringBuilder(93).append("producerId:").append(producerId).append(",producerEpoch:").append(this.producerEpoch()).append(",state=Ongoing,").append("partitions=[").append(topicPartition).append("],txnLastUpdateTimestamp=0,txnTimeoutMs=").append(this.transactionTimeoutMs()).toString()), (Object)var11_10);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTransactionMetadataTombstoneParsing() {
        void var5_5;
        void var4_4;
        String transactionalId = "id";
        Record transactionMetadataRecord = (Record)CollectionConverters$.MODULE$.IterableHasAsScala(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord(TransactionLog$.MODULE$.keyToBytes(transactionalId), null), (List)Nil$.MODULE$), (byte)2, (Compression)Compression.NONE, -1L, (short)-1, -1, 0L, -1).records()).asScala().head();
        Tuple2 tuple2 = TransactionLog$.MODULE$.formatRecordKeyAndValue(transactionMetadataRecord);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option keyStringOpt = (Option)tuple2._1();
        Option valueStringOpt = (Option)tuple2._2();
        Assertions.assertEquals((Object)new Some((Object)new StringBuilder(38).append("transaction_metadata::transactionalId=").append(transactionalId).toString()), (Object)var4_4);
        Assertions.assertEquals((Object)new Some((Object)"<DELETE>"), (Object)var5_5);
    }

    @Test
    public void testSerializeTransactionLogValueToHighestNonFlexibleVersion() {
        TxnTransitMetadata txnTransitMetadata = new TxnTransitMetadata(1L, 1L, 1, 1, 1000, (TransactionState)CompleteCommit$.MODULE$, Predef$.MODULE$.Set().empty(), 500L, 500L);
        ByteBuffer txnLogValueBuffer = ByteBuffer.wrap(TransactionLog$.MODULE$.valueToBytes(txnTransitMetadata));
        Assertions.assertEquals((int)0, (int)txnLogValueBuffer.getShort());
    }

    @Test
    public void testDeserializeHighestSupportedTransactionLogValue() {
        TransactionLogValue.PartitionsSchema txnPartitions = new TransactionLogValue.PartitionsSchema().setTopic("topic").setPartitionIds(Collections.singletonList(Predef$.MODULE$.int2Integer(0)));
        TransactionLogValue txnLogValue = new TransactionLogValue().setProducerId(100L).setProducerEpoch((short)50).setTransactionStatus(CompleteCommit$.MODULE$.id()).setTransactionStartTimestampMs(750L).setTransactionLastUpdateTimestampMs(1000L).setTransactionTimeoutMs(500).setTransactionPartitions(Collections.singletonList(txnPartitions));
        ByteBuffer serialized = MessageUtil.toVersionPrefixedByteBuffer((short)1, (Message)txnLogValue);
        TransactionMetadata deserialized = (TransactionMetadata)TransactionLog$.MODULE$.readTxnRecordValue("transactionId", serialized).get();
        Assertions.assertEquals((long)100L, (long)deserialized.producerId());
        Assertions.assertEquals((int)50, (int)deserialized.producerEpoch());
        Assertions.assertEquals((Object)CompleteCommit$.MODULE$, (Object)deserialized.state());
        Assertions.assertEquals((long)750L, (long)deserialized.txnStartTimestamp());
        Assertions.assertEquals((long)1000L, (long)deserialized.txnLastUpdateTimestamp());
        Assertions.assertEquals((int)500, (int)deserialized.txnTimeoutMs());
        scala.collection.mutable.Set actualTxnPartitions = deserialized.topicPartitions();
        Assertions.assertEquals((int)1, (int)actualTxnPartitions.size());
        Assertions.assertTrue((boolean)actualTxnPartitions.contains((Object)new TopicPartition("topic", 0)));
    }

    @Test
    public void testDeserializeFutureTransactionLogValue() {
        Schema futurePartitionsSchema = new Schema(new Field[]{new Field("topic", (Type)Type.COMPACT_STRING, ""), new Field("partition_ids", (Type)new CompactArrayOf((Type)Type.INT32), ""), Field.TaggedFieldsSection.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)0), new Field("partition_foo", (Type)Type.STRING, ""), BoxesRunTime.boxToInteger((int)1), new Field("partition_foo", (Type)Type.INT32, "")})});
        Struct txnPartitions = new Struct(futurePartitionsSchema);
        txnPartitions.set("topic", (Object)"topic");
        txnPartitions.set("partition_ids", (Object)new Integer[]{1});
        TreeMap<Integer, Object> txnPartitionsTaggedFields = new TreeMap<Integer, Object>();
        txnPartitionsTaggedFields.put(Predef$.MODULE$.int2Integer(0), "foo");
        txnPartitionsTaggedFields.put(Predef$.MODULE$.int2Integer(1), BoxesRunTime.boxToInteger((int)4000));
        txnPartitions.set("_tagged_fields", txnPartitionsTaggedFields);
        Schema futureTransactionLogValueSchema = new Schema(new Field[]{new Field("producer_id", (Type)Type.INT64, ""), new Field("producer_epoch", (Type)Type.INT16, ""), new Field("transaction_timeout_ms", (Type)Type.INT32, ""), new Field("transaction_status", (Type)Type.INT8, ""), new Field("transaction_partitions", (Type)CompactArrayOf.nullable((Type)futurePartitionsSchema), ""), new Field("transaction_last_update_timestamp_ms", (Type)Type.INT64, ""), new Field("transaction_start_timestamp_ms", (Type)Type.INT64, ""), Field.TaggedFieldsSection.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)0), new Field("txn_foo", (Type)Type.STRING, ""), BoxesRunTime.boxToInteger((int)1), new Field("txn_bar", (Type)Type.INT32, "")})});
        Struct transactionLogValue = new Struct(futureTransactionLogValueSchema);
        transactionLogValue.set("producer_id", (Object)BoxesRunTime.boxToLong((long)1000L));
        transactionLogValue.set("producer_epoch", (Object)BoxesRunTime.boxToShort((short)((short)100)));
        transactionLogValue.set("transaction_timeout_ms", (Object)BoxesRunTime.boxToInteger((int)1000));
        transactionLogValue.set("transaction_status", (Object)BoxesRunTime.boxToByte((byte)CompleteCommit$.MODULE$.id()));
        transactionLogValue.set("transaction_partitions", (Object)new Struct[]{txnPartitions});
        transactionLogValue.set("transaction_last_update_timestamp_ms", (Object)BoxesRunTime.boxToLong((long)2000L));
        transactionLogValue.set("transaction_start_timestamp_ms", (Object)BoxesRunTime.boxToLong((long)3000L));
        TreeMap<Integer, Object> txnLogValueTaggedFields = new TreeMap<Integer, Object>();
        txnLogValueTaggedFields.put(Predef$.MODULE$.int2Integer(0), "foo");
        txnLogValueTaggedFields.put(Predef$.MODULE$.int2Integer(1), BoxesRunTime.boxToInteger((int)4000));
        transactionLogValue.set("_tagged_fields", txnLogValueTaggedFields);
        ByteBuffer buffer = ByteBuffer.allocate(transactionLogValue.sizeOf() + 2);
        buffer.put((byte)0);
        buffer.put((byte)1);
        transactionLogValue.writeTo(buffer);
        buffer.flip();
        buffer.getShort();
        TransactionLogValue value = new TransactionLogValue((Readable)new ByteBufferAccessor(buffer), (short)1);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(value.unknownTaggedFields()).asScala().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.tag())));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((TransactionLogValue.PartitionsSchema)value.transactionPartitions().get(0)).unknownTaggedFields()).asScala().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.tag())));
        buffer.rewind();
        TransactionMetadata txnMetadata = (TransactionMetadata)TransactionLog$.MODULE$.readTxnRecordValue("transaction-id", buffer).get();
        Assertions.assertEquals((long)1000L, (long)txnMetadata.producerId());
        Assertions.assertEquals((int)100, (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)1000L, (long)txnMetadata.txnTimeoutMs());
        Assertions.assertEquals((Object)CompleteCommit$.MODULE$, (Object)txnMetadata.state());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic", 1)})), (Object)txnMetadata.topicPartitions());
        Assertions.assertEquals((long)2000L, (long)txnMetadata.txnLastUpdateTimestamp());
        Assertions.assertEquals((long)3000L, (long)txnMetadata.txnStartTimestamp());
    }

    @Test
    public void testReadTxnRecordKeyCanReadUnknownMessage() {
        TransactionLogKey record = new TransactionLogKey();
        byte[] unknownRecord = MessageUtil.toVersionPrefixedBytes((short)Short.MAX_VALUE, (Message)record);
        BaseKey key = TransactionLog$.MODULE$.readTxnRecordKey(ByteBuffer.wrap(unknownRecord));
        Assertions.assertEquals((Object)new UnknownKey(Short.MAX_VALUE), (Object)key);
    }

    public static final /* synthetic */ void $anonfun$shouldReadWriteMessages$2(TransactionLogTest $this, Map pidMappings$1, Map transactionStates$1, IntRef count$1, Record record) {
        String transactionalId = TransactionLog$.MODULE$.readTxnRecordKey(record.key()).transactionalId();
        TransactionMetadata txnMetadata = (TransactionMetadata)TransactionLog$.MODULE$.readTxnRecordValue(transactionalId, record.value()).get();
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)pidMappings$1.apply((Object)transactionalId)), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)$this.producerEpoch(), (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((int)$this.transactionTimeoutMs(), (int)txnMetadata.txnTimeoutMs());
        Assertions.assertEquals((Object)transactionStates$1.apply((Object)BoxesRunTime.boxToLong((long)txnMetadata.producerId())), (Object)txnMetadata.state());
        if (txnMetadata.state().equals(Empty$.MODULE$)) {
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)txnMetadata.topicPartitions());
        } else {
            Assertions.assertEquals($this.topicPartitions(), (Object)txnMetadata.topicPartitions());
        }
        ++count$1.elem;
    }

    public TransactionLogTest() {
        this.producerEpoch = 0;
        this.transactionTimeoutMs = 1000;
    }
}

