/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import kafka.zk.AclChangeNode;
import kafka.zk.ExtendedAclStore;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005E3AAD\b\u0001)!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0013\u0001\u0003B\u0002\u0018\u0001A\u0003%\u0011\u0005C\u00040\u0001\t\u0007I\u0011\u0002\u0011\t\rA\u0002\u0001\u0015!\u0003\"\u0011\u001d\t\u0004A1A\u0005\nIBaA\u000e\u0001!\u0002\u0013\u0019\u0004\"B\u001c\u0001\t\u0003A\u0004\"B$\u0001\t\u0003A\u0004\"B%\u0001\t\u0003A\u0004\"B&\u0001\t\u0003A\u0004\"B'\u0001\t\u0003A\u0004\"B(\u0001\t\u0003A$\u0001F#yi\u0016tG-\u001a3BG2\u001cFo\u001c:f)\u0016\u001cHO\u0003\u0002\u0011#\u0005\u0011!p\u001b\u0006\u0002%\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0016!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011aD\u0001\u0010Y&$XM]1m%\u0016\u001cx.\u001e:dKV\t\u0011\u0005\u0005\u0002#Y5\t1E\u0003\u0002%K\u0005A!/Z:pkJ\u001cWM\u0003\u0002'O\u000511m\\7n_:T!A\u0005\u0015\u000b\u0005%R\u0013AB1qC\u000eDWMC\u0001,\u0003\ry'oZ\u0005\u0003[\r\u0012qBU3t_V\u00148-\u001a)biR,'O\\\u0001\u0011Y&$XM]1m%\u0016\u001cx.\u001e:dK\u0002\n\u0001\u0003\u001d:fM&DX\r\u001a*fg>,(oY3\u0002#A\u0014XMZ5yK\u0012\u0014Vm]8ve\u000e,\u0007%A\u0003ti>\u0014X-F\u00014!\tqB'\u0003\u00026\u001f\t\u0001R\t\u001f;f]\u0012,G-Q2m'R|'/Z\u0001\u0007gR|'/\u001a\u0011\u0002-MDw.\u001e7e\u0011\u00064XmQ8se\u0016\u001cG\u000fU1uQN$\u0012!\u000f\t\u0003-iJ!aO\f\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0011u\u0002\"AP#\u000e\u0003}R!\u0001Q!\u0002\u0007\u0005\u0004\u0018N\u0003\u0002C\u0007\u00069!.\u001e9ji\u0016\u0014(B\u0001#+\u0003\u0015QWO\\5u\u0013\t1uH\u0001\u0003UKN$\u0018\u0001H:i_VdG\rS1wK\u000e{'O]3diB\u000bG\u000f^3s]RK\b/\u001a\u0015\u0003\u0013u\n1e\u001d5pk2$G\u000b\u001b:po&37i\u001c8tiJ,8\r^3e/&$\b\u000eT5uKJ\fG\u000e\u000b\u0002\u000b{\u0005q2\u000f[8vY\u0012$\u0006N]8x\rJ|W.\u00128d_\u0012,wJ\u001c'ji\u0016\u0014\u0018\r\u001c\u0015\u0003\u0017u\n\u0001e\u001d5pk2$wK]5uK\u000eC\u0017M\\4fgR{G\u000b[3Xe&$X\rU1uQ\"\u0012A\"P\u0001\u001ag\"|W\u000f\u001c3S_VtG\r\u0016:ja\u000eC\u0017M\\4f\u001d>$W\r\u000b\u0002\u000e{\u0001")
public class ExtendedAclStoreTest {
    private final ResourcePattern literalResource = new ResourcePattern(ResourceType.TOPIC, "some-topic", PatternType.LITERAL);
    private final ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "some-topic", PatternType.PREFIXED);
    private final ExtendedAclStore store = new ExtendedAclStore(PatternType.PREFIXED);

    private ResourcePattern literalResource() {
        return this.literalResource;
    }

    private ResourcePattern prefixedResource() {
        return this.prefixedResource;
    }

    private ExtendedAclStore store() {
        return this.store;
    }

    @Test
    public void shouldHaveCorrectPaths() {
        Assertions.assertEquals((Object)"/kafka-acl-extended/prefixed", (Object)this.store().aclPath());
        Assertions.assertEquals((Object)"/kafka-acl-extended/prefixed/Topic", (Object)this.store().path(ResourceType.TOPIC));
        Assertions.assertEquals((Object)"/kafka-acl-extended-changes", (Object)this.store().changeStore().aclChangePath());
    }

    @Test
    public void shouldHaveCorrectPatternType() {
        Assertions.assertEquals((Object)PatternType.PREFIXED, (Object)this.store().patternType());
    }

    @Test
    public void shouldThrowIfConstructedWithLiteral() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ExtendedAclStore(PatternType.LITERAL));
    }

    @Test
    public void shouldThrowFromEncodeOnLiteral() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.store().changeStore().createChangeNode(this.literalResource()));
    }

    @Test
    public void shouldWriteChangesToTheWritePath() {
        AclChangeNode changeNode = this.store().changeStore().createChangeNode(this.prefixedResource());
        Assertions.assertEquals((Object)"/kafka-acl-extended-changes/acl_changes_", (Object)changeNode.path());
    }

    @Test
    public void shouldRoundTripChangeNode() {
        AclChangeNode changeNode = this.store().changeStore().createChangeNode(this.prefixedResource());
        ResourcePattern actual = this.store().changeStore().decode(changeNode.bytes());
        Assertions.assertEquals((Object)this.prefixedResource(), (Object)actual);
    }
}

