/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugin.assembly.interpolation.AssemblyExpressionEvaluator;
import org.apache.maven.plugin.assembly.interpolation.AssemblyInterpolationException;
import org.apache.maven.plugin.assembly.interpolation.AssemblyInterpolator;
import org.apache.maven.plugin.assembly.io.AssemblyReadException;
import org.apache.maven.plugin.assembly.io.AssemblyReader;
import org.apache.maven.plugin.assembly.io.PrefixedClasspathLocatorStrategy;
import org.apache.maven.plugin.assembly.io.RelativeFileLocatorStrategy;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.model.Component;
import org.apache.maven.plugin.assembly.model.ContainerDescriptorHandlerConfig;
import org.apache.maven.plugin.assembly.model.DependencySet;
import org.apache.maven.plugin.assembly.model.FileItem;
import org.apache.maven.plugin.assembly.model.FileSet;
import org.apache.maven.plugin.assembly.model.ModuleSet;
import org.apache.maven.plugin.assembly.model.Repository;
import org.apache.maven.plugin.assembly.model.io.xpp3.AssemblyXpp3Reader;
import org.apache.maven.plugin.assembly.model.io.xpp3.AssemblyXpp3Writer;
import org.apache.maven.plugin.assembly.model.io.xpp3.ComponentXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.io.location.ClasspathResourceLocatorStrategy;
import org.apache.maven.shared.io.location.FileLocatorStrategy;
import org.apache.maven.shared.io.location.Location;
import org.apache.maven.shared.io.location.Locator;
import org.apache.maven.shared.io.location.LocatorStrategy;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@org.codehaus.plexus.component.annotations.Component(role=AssemblyReader.class)
public class DefaultAssemblyReader
extends AbstractLogEnabled
implements AssemblyReader {
    @Override
    public List<Assembly> readAssemblies(AssemblerConfigurationSource configSource) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        Locator locator = new Locator();
        ArrayList<RelativeFileLocatorStrategy> strategies = new ArrayList<RelativeFileLocatorStrategy>();
        strategies.add(new RelativeFileLocatorStrategy(configSource.getBasedir()));
        strategies.add((RelativeFileLocatorStrategy)new FileLocatorStrategy());
        ArrayList<PrefixedClasspathLocatorStrategy> refStrategies = new ArrayList<PrefixedClasspathLocatorStrategy>();
        refStrategies.add(new PrefixedClasspathLocatorStrategy("/assemblies/"));
        ArrayList<Assembly> assemblies = new ArrayList<Assembly>();
        String descriptor = configSource.getDescriptor();
        String descriptorId = configSource.getDescriptorId();
        String[] descriptors = configSource.getDescriptors();
        String[] descriptorRefs = configSource.getDescriptorReferences();
        File descriptorSourceDirectory = configSource.getDescriptorSourceDirectory();
        if (descriptor != null) {
            locator.setStrategies(strategies);
            this.addAssemblyFromDescriptor(descriptor, locator, configSource, assemblies);
        }
        if (descriptorId != null) {
            locator.setStrategies(refStrategies);
            this.addAssemblyForDescriptorReference(descriptorId, configSource, assemblies);
        }
        if (descriptors != null && descriptors.length > 0) {
            locator.setStrategies(strategies);
            for (String descriptor1 : descriptors) {
                this.getLogger().info("Reading assembly descriptor: " + descriptor1);
                this.addAssemblyFromDescriptor(descriptor1, locator, configSource, assemblies);
            }
        }
        if (descriptorRefs != null && descriptorRefs.length > 0) {
            locator.setStrategies(refStrategies);
            for (String descriptorRef : descriptorRefs) {
                this.addAssemblyForDescriptorReference(descriptorRef, configSource, assemblies);
            }
        }
        if (descriptorSourceDirectory != null && descriptorSourceDirectory.isDirectory()) {
            locator.setStrategies(Collections.singletonList(new RelativeFileLocatorStrategy(descriptorSourceDirectory)));
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(descriptorSourceDirectory);
            scanner.setIncludes(new String[]{"**/*.xml"});
            scanner.addDefaultExcludes();
            try {
                scanner.scan();
            }
            catch (NullPointerException e) {
                StackTraceElement frameZero = e.getStackTrace()[0];
                if ("org.codehaus.plexus.util.DirectoryScanner".equals(frameZero.getClassName()) && "scandir".equals(frameZero.getMethodName())) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Caught filesystem error while scanning directories...using zero-length list as the result.", (Throwable)e);
                    }
                }
                throw e;
            }
            String[] paths = scanner.getIncludedFiles();
            if (paths != null) {
                for (String path : paths) {
                    this.addAssemblyFromDescriptor(path, locator, configSource, assemblies);
                }
            }
        }
        if (assemblies.isEmpty()) {
            if (configSource.isIgnoreMissingDescriptor()) {
                this.getLogger().debug("Ignoring missing assembly descriptors per configuration. See messages above for specifics.");
            } else {
                throw new AssemblyReadException("No assembly descriptors found.");
            }
        }
        HashSet<String> ids = new HashSet<String>();
        for (Assembly assembly : assemblies) {
            if (ids.add(assembly.getId())) continue;
            this.getLogger().warn("The assembly id " + assembly.getId() + " is used more than once.");
        }
        return assemblies;
    }

    @Override
    public Assembly getAssemblyForDescriptorReference(String ref, AssemblerConfigurationSource configSource) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        return this.addAssemblyForDescriptorReference(ref, configSource, new ArrayList<Assembly>(1));
    }

    @Override
    public Assembly getAssemblyFromDescriptorFile(File file, AssemblerConfigurationSource configSource) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        return this.addAssemblyFromDescriptorFile(file, configSource, new ArrayList<Assembly>(1));
    }

    private Assembly addAssemblyForDescriptorReference(String ref, AssemblerConfigurationSource configSource, List<Assembly> assemblies) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("assemblies/" + ref + ".xml");
        if (resourceAsStream == null) {
            if (configSource.isIgnoreMissingDescriptor()) {
                this.getLogger().debug("Ignoring missing assembly descriptor with ID '" + ref + "' per configuration.");
                return null;
            }
            throw new AssemblyReadException("Descriptor with ID '" + ref + "' not found");
        }
        try {
            Assembly assembly = this.readAssembly(new InputStreamReader(resourceAsStream, "UTF-8"), ref, null, configSource);
            assemblies.add(assembly);
            return assembly;
        }
        catch (UnsupportedEncodingException e) {
            throw new AssemblyReadException("Encoding not supported for descriptor with ID '" + ref + "'");
        }
    }

    private Assembly addAssemblyFromDescriptorFile(File descriptor, AssemblerConfigurationSource configSource, List<Assembly> assemblies) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        Assembly assembly;
        if (!descriptor.exists()) {
            if (configSource.isIgnoreMissingDescriptor()) {
                this.getLogger().debug("Ignoring missing assembly descriptor: '" + descriptor + "' per configuration.");
                return null;
            }
            throw new AssemblyReadException("Descriptor: '" + descriptor + "' not found");
        }
        InputStreamReader r = null;
        try {
            r = new InputStreamReader((InputStream)new FileInputStream(descriptor), "UTF-8");
            Assembly assembly2 = this.readAssembly(r, descriptor.getAbsolutePath(), descriptor.getParentFile(), configSource);
            assemblies.add(assembly2);
            assembly = assembly2;
        }
        catch (IOException e) {
            try {
                throw new AssemblyReadException("Error reading assembly descriptor: " + descriptor, e);
            }
            catch (Throwable throwable) {
                IOUtil.close(r);
                throw throwable;
            }
        }
        IOUtil.close((Reader)r);
        return assembly;
    }

    private Assembly addAssemblyFromDescriptor(String spec, Locator locator, AssemblerConfigurationSource configSource, List<Assembly> assemblies) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        Assembly assembly;
        Location location = locator.resolve(spec);
        if (location == null) {
            if (configSource.isIgnoreMissingDescriptor()) {
                this.getLogger().debug("Ignoring missing assembly descriptor with ID '" + spec + "' per configuration.\nLocator output was:\n\n" + locator.getMessageHolder().render());
                return null;
            }
            throw new AssemblyReadException("Error locating assembly descriptor: " + spec + "\n\n" + locator.getMessageHolder().render());
        }
        InputStreamReader r = null;
        try {
            r = new InputStreamReader(location.getInputStream(), "UTF-8");
            File dir = null;
            if (location.getFile() != null) {
                dir = location.getFile().getParentFile();
            }
            Assembly assembly2 = this.readAssembly(r, spec, dir, configSource);
            assemblies.add(assembly2);
            assembly = assembly2;
        }
        catch (IOException e) {
            try {
                throw new AssemblyReadException("Error reading assembly descriptor: " + spec, e);
            }
            catch (Throwable throwable) {
                IOUtil.close(r);
                throw throwable;
            }
        }
        IOUtil.close((Reader)r);
        return assembly;
    }

    protected Assembly readAssembly(Reader reader, String locationDescription, File assemblyDir, AssemblerConfigurationSource configSource) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        Assembly assembly;
        File basedir = configSource.getBasedir();
        MavenProject project = configSource.getProject();
        try {
            HashMap<String, String> context = new HashMap<String, String>();
            MavenSession session = configSource.getMavenSession();
            Properties commandLineProperties = DefaultAssemblyReader.mergeExecutionPropertiesWithSystemPropertiew(session);
            Enumeration<Object> e = commandLineProperties.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (key == null || key.trim().length() < 1) continue;
                context.put(key, commandLineProperties.getProperty(key));
            }
            context.put("basedir", basedir.getAbsolutePath());
            AssemblyXpp3Reader r = new AssemblyXpp3Reader();
            assembly = r.read(reader);
            this.mergeComponentsWithMainAssembly(assembly, assemblyDir, configSource);
            this.debugPrintAssembly("Before assembly is interpolated:", assembly);
            assembly = new AssemblyInterpolator().interpolate(assembly, project, configSource);
            this.debugPrintAssembly("After assembly is interpolated:", assembly);
        }
        catch (IOException e) {
            throw new AssemblyReadException("Error reading descriptor: " + locationDescription + ": " + e.getMessage(), e);
        }
        catch (XmlPullParserException e) {
            throw new AssemblyReadException("Error reading descriptor: " + locationDescription + ": " + e.getMessage(), e);
        }
        catch (AssemblyInterpolationException e) {
            throw new AssemblyReadException("Error reading descriptor: " + locationDescription + ": " + e.getMessage(), e);
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        if (configSource.isSiteIncluded() || assembly.isIncludeSiteDirectory()) {
            this.includeSiteInAssembly(assembly, configSource);
        }
        return assembly;
    }

    public static Properties mergeExecutionPropertiesWithSystemPropertiew(MavenSession session) {
        Properties commandLineProperties = System.getProperties();
        if (session != null) {
            commandLineProperties = new Properties();
            if (session.getExecutionProperties() != null) {
                commandLineProperties.putAll((Map<?, ?>)session.getExecutionProperties());
            }
            if (session.getUserProperties() != null) {
                commandLineProperties.putAll((Map<?, ?>)session.getUserProperties());
            }
        }
        return commandLineProperties;
    }

    private void debugPrintAssembly(String message, Assembly assembly) {
        StringWriter sWriter = new StringWriter();
        try {
            new AssemblyXpp3Writer().write(sWriter, assembly);
        }
        catch (IOException e) {
            this.getLogger().debug("Failed to print debug message with assembly descriptor listing, and message: " + message, (Throwable)e);
        }
        this.getLogger().debug(message + "\n\n" + sWriter.toString() + "\n\n");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void mergeComponentsWithMainAssembly(Assembly assembly, File assemblyDir, AssemblerConfigurationSource configSource) throws AssemblyReadException {
        Locator locator = new Locator();
        if (assemblyDir != null && assemblyDir.exists() && assemblyDir.isDirectory()) {
            locator.addStrategy((LocatorStrategy)new RelativeFileLocatorStrategy(assemblyDir));
        }
        locator.addStrategy((LocatorStrategy)new RelativeFileLocatorStrategy(configSource.getBasedir()));
        locator.addStrategy((LocatorStrategy)new FileLocatorStrategy());
        locator.addStrategy((LocatorStrategy)new ClasspathResourceLocatorStrategy());
        AssemblyExpressionEvaluator aee = new AssemblyExpressionEvaluator(configSource);
        List<String> componentLocations = assembly.getComponentDescriptors();
        Iterator<String> i$ = componentLocations.iterator();
        while (i$.hasNext()) {
            String location = i$.next();
            try {
                location = aee.evaluate(location).toString();
            }
            catch (Exception eee) {
                this.getLogger().error("Error interpolating componentDescriptor: " + location, (Throwable)eee);
            }
            Location resolvedLocation = locator.resolve(location);
            if (resolvedLocation == null) {
                throw new AssemblyReadException("Failed to locate component descriptor: " + location);
            }
            Component component = null;
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader(resolvedLocation.getInputStream());
                component = new ComponentXpp3Reader().read(reader);
            }
            catch (IOException e) {
                try {
                    throw new AssemblyReadException("Error reading component descriptor: " + location + " (resolved to: " + resolvedLocation.getSpecification() + ")", e);
                    catch (XmlPullParserException e2) {
                        throw new AssemblyReadException("Error reading component descriptor: " + location + " (resolved to: " + resolvedLocation.getSpecification() + ")", e2);
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.close(reader);
                    throw throwable;
                }
            }
            IOUtil.close((Reader)reader);
            this.mergeComponentWithAssembly(component, assembly);
        }
        return;
    }

    protected void mergeComponentWithAssembly(Component component, Assembly assembly) {
        List<ContainerDescriptorHandlerConfig> containerHandlerDescriptors = component.getContainerDescriptorHandlers();
        for (ContainerDescriptorHandlerConfig cfg : containerHandlerDescriptors) {
            assembly.addContainerDescriptorHandler(cfg);
        }
        List<DependencySet> dependencySetList = component.getDependencySets();
        for (DependencySet dependencySet : dependencySetList) {
            assembly.addDependencySet(dependencySet);
        }
        List<FileSet> fileSetList = component.getFileSets();
        for (FileSet fileSet : fileSetList) {
            assembly.addFileSet(fileSet);
        }
        List<FileItem> fileList = component.getFiles();
        for (FileItem fileItem : fileList) {
            assembly.addFile(fileItem);
        }
        List<Repository> repositoriesList = component.getRepositories();
        for (Repository repository : repositoriesList) {
            assembly.addRepository(repository);
        }
        List<ModuleSet> moduleSets = component.getModuleSets();
        for (ModuleSet moduleSet : moduleSets) {
            assembly.addModuleSet(moduleSet);
        }
    }

    @Override
    public void includeSiteInAssembly(Assembly assembly, AssemblerConfigurationSource configSource) throws InvalidAssemblerConfigurationException {
        File siteDirectory = configSource.getSiteDirectory();
        if (!siteDirectory.exists()) {
            throw new InvalidAssemblerConfigurationException("site did not exist in the target directory - please run site:site before creating the assembly");
        }
        this.getLogger().info("Adding site directory to assembly : " + siteDirectory);
        FileSet siteFileSet = new FileSet();
        siteFileSet.setDirectory(siteDirectory.getPath());
        siteFileSet.setOutputDirectory("/site");
        assembly.addFileSet(siteFileSet);
    }

    protected Logger getLogger() {
        Logger logger = super.getLogger();
        if (logger == null) {
            logger = new ConsoleLogger(1, "assemblyReader-internal");
            this.enableLogging(logger);
        }
        return logger;
    }
}

