/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.archive.archiver;

import java.io.File;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.components.io.filemappers.FileMapper;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.functions.InputStreamTransformer;

class PrefixedFileSet
implements FileSet {
    private static final FileMapper[] EMPTY_FILE_MAPPERS_ARRAY = new FileMapper[0];
    private final String rootPrefix;
    private final FileSet fileSet;
    private final FileSelector[] selectors;

    PrefixedFileSet(FileSet fileSet, String rootPrefix, FileSelector[] selectors) {
        this.fileSet = fileSet;
        this.selectors = selectors;
        this.rootPrefix = rootPrefix.length() > 0 && !rootPrefix.endsWith("/") ? rootPrefix + "/" : rootPrefix;
    }

    static FileSelector[] combineSelectors(FileSelector[] first, FileSelector[] second) {
        if (first != null && second != null) {
            FileSelector[] temp = new FileSelector[first.length + second.length];
            System.arraycopy(first, 0, temp, 0, first.length);
            System.arraycopy(second, 0, temp, first.length, second.length);
            first = temp;
        } else if (first == null && second != null) {
            first = second;
        }
        return first;
    }

    public String[] getExcludes() {
        return this.fileSet.getExcludes();
    }

    public FileSelector[] getFileSelectors() {
        FileSelector[] sel = this.fileSet.getFileSelectors();
        return PrefixedFileSet.combineSelectors(sel, this.selectors);
    }

    public String[] getIncludes() {
        return this.fileSet.getIncludes();
    }

    public String getPrefix() {
        String prefix = this.fileSet.getPrefix();
        if (prefix == null) {
            return this.rootPrefix;
        }
        if (prefix.startsWith("/")) {
            prefix = prefix.length() > 1 ? prefix.substring(1) : "";
        }
        return this.rootPrefix + prefix;
    }

    public boolean isCaseSensitive() {
        return this.fileSet.isCaseSensitive();
    }

    public boolean isIncludingEmptyDirectories() {
        return this.fileSet.isIncludingEmptyDirectories();
    }

    public boolean isUsingDefaultExcludes() {
        return this.fileSet.isUsingDefaultExcludes();
    }

    public File getDirectory() {
        return this.fileSet.getDirectory();
    }

    public InputStreamTransformer getStreamTransformer() {
        return this.fileSet.getStreamTransformer();
    }

    public FileMapper[] getFileMappers() {
        return EMPTY_FILE_MAPPERS_ARRAY;
    }
}

