/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.reader;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarFile;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.WorkspaceConfiguration;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.plugin.ide.IdeUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.core.internal.localstore.SafeChunkyInputStream;

public class ReadWorkspaceLocations {
    public static final String BINARY_LOCATION_FILE = ".location";
    public static final String METADATA_PLUGINS_ORG_ECLIPSE_CORE_RESOURCES_PROJECTS = ".metadata/.plugins/org.eclipse.core.resources/.projects";
    private static final String[] PARENT_VERSION = new String[]{"parent", "version"};
    private static final String[] PARENT_GROUP_ID = new String[]{"parent", "groupId"};
    private static final String[] PACKAGING = new String[]{"packaging"};
    private static final String[] VERSION = new String[]{"version"};
    private static final String[] GROUP_ID = new String[]{"groupId"};
    private static final String[] ARTEFACT_ID = new String[]{"artifactId"};
    private static final String METADATA_PLUGINS_ORG_ECLIPSE_CORE_RUNTIME_LAUNCHING_PREFS = ".metadata/.plugins/org.eclipse.core.runtime/.settings/org.eclipse.jdt.launching.prefs";
    private static final String METADATA_PLUGINS_ORG_ECLIPSE_CORE_RUNTIME_PREFS_VM_KEY = "org.eclipse.jdt.launching.PREF_VM_XML";
    private static final String METADATA_PLUGINS_ORG_ECLIPSE_CORE_RUNTIME_SERVER_PREFS = ".metadata/.plugins/org.eclipse.core.runtime/.settings/org.eclipse.wst.server.core.prefs";
    private static final String METADATA_PLUGINS_ORG_ECLIPSE_CORE_RUNTIME_PREFS_RUNTIMES_KEY = "runtimes";
    private static final String CLASSPATHENTRY_DEFAULT = "org.eclipse.jdt.launching.JRE_CONTAINER";
    private static final String CLASSPATHENTRY_STANDARD = "org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/";
    private static final String CLASSPATHENTRY_FORMAT = "org.eclipse.jdt.launching.JRE_CONTAINER/{0}/{1}";

    public void init(Log log, WorkspaceConfiguration workspaceConfiguration, MavenProject project, String wtpDefaultServer) {
        this.detectDefaultJREContainer(workspaceConfiguration, project, log);
        this.readWorkspace(workspaceConfiguration, log);
        this.detectWTPDefaultServer(workspaceConfiguration, wtpDefaultServer, log);
    }

    private void detectWTPDefaultServer(WorkspaceConfiguration workspaceConfiguration, String wtpDefaultServer, Log log) {
        HashMap servers = this.readDefinedServers(workspaceConfiguration, log);
        if (servers == null || servers.isEmpty()) {
            return;
        }
        if (wtpDefaultServer != null) {
            String name;
            String id;
            Set ids = servers.keySet();
            Iterator idIterator = ids.iterator();
            while (workspaceConfiguration.getDefaultDeployServerId() == null && idIterator.hasNext()) {
                id = (String)idIterator.next();
                name = (String)servers.get(id);
                if (!wtpDefaultServer.equals(id) && !wtpDefaultServer.equals(name)) continue;
                workspaceConfiguration.setDefaultDeployServerId(id);
                workspaceConfiguration.setDefaultDeployServerName(name);
            }
            if (workspaceConfiguration.getDefaultDeployServerId() == null) {
                log.info((CharSequence)"no exact wtp server match.");
                idIterator = ids.iterator();
                while (workspaceConfiguration.getDefaultDeployServerId() == null && idIterator.hasNext()) {
                    id = (String)idIterator.next();
                    name = (String)servers.get(id);
                    if (id.indexOf(wtpDefaultServer) < 0 && name.indexOf(wtpDefaultServer) < 0) continue;
                    workspaceConfiguration.setDefaultDeployServerId(id);
                    workspaceConfiguration.setDefaultDeployServerName(name);
                }
            }
        }
        if (workspaceConfiguration.getDefaultDeployServerId() == null && servers.size() > 0) {
            log.info((CharSequence)"no substring wtp server match.");
            workspaceConfiguration.setDefaultDeployServerId((String)servers.get(""));
            workspaceConfiguration.setDefaultDeployServerName((String)servers.get(workspaceConfiguration.getDefaultDeployServerId()));
        }
        log.info((CharSequence)("Using as WTP server : " + workspaceConfiguration.getDefaultDeployServerName()));
    }

    private String getContainerFromExecutable(String rawExecutable, Map jreMap, Log logger) {
        String foundContainer = null;
        if (rawExecutable != null) {
            try {
                String executable = new File(rawExecutable).getCanonicalPath();
                logger.debug((CharSequence)("detected executable: " + executable));
            }
            catch (Exception e) {
                return null;
            }
            for (File executableFile = new File(executable); executableFile != null; executableFile = executableFile.getParentFile()) {
                foundContainer = (String)jreMap.get(executableFile.getPath());
                if (foundContainer == null) continue;
                logger.debug((CharSequence)("detected classpathContainer from executable: " + foundContainer));
                return foundContainer;
            }
        }
        return null;
    }

    private void detectDefaultJREContainer(WorkspaceConfiguration workspaceConfiguration, MavenProject project, Log logger) {
        HashMap jreMap;
        String defaultJREContainer = CLASSPATHENTRY_DEFAULT;
        if (workspaceConfiguration.getWorkspaceDirectory() != null && (jreMap = this.readAvailableJREs(workspaceConfiguration.getWorkspaceDirectory(), logger)) != null) {
            String sourceVersion;
            String foundContainer = this.getContainerFromExecutable(System.getProperty("maven.compiler.executable"), jreMap, logger);
            if (foundContainer == null) {
                foundContainer = this.getContainerFromExecutable(IdeUtils.getCompilerPluginSetting(project, "executable"), jreMap, logger);
            }
            if (foundContainer == null && (foundContainer = (String)jreMap.get(sourceVersion = IdeUtils.getCompilerSourceVersion(project))) != null) {
                logger.debug((CharSequence)("detected classpathContainer from sourceVersion(" + sourceVersion + "): " + foundContainer));
            }
            if (foundContainer == null) {
                foundContainer = this.getContainerFromExecutable(System.getProperty("java.home"), jreMap, logger);
            }
            if (foundContainer != null) {
                defaultJREContainer = foundContainer;
            }
        }
        workspaceConfiguration.setDefaultClasspathContainer(defaultJREContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File getProjectLocation(File workspaceLocation, File project) throws IOException, URISyntaxException {
        File projectBase;
        File location = new File(project, BINARY_LOCATION_FILE);
        if (location.exists()) {
            SafeChunkyInputStream fileInputStream;
            block5: {
                File file;
                fileInputStream = null;
                try {
                    fileInputStream = new SafeChunkyInputStream(location);
                    DataInputStream dataInputStream = new DataInputStream((InputStream)fileInputStream);
                    String file2 = dataInputStream.readUTF().trim();
                    if (file2.length() <= 0) break block5;
                    if (!file2.startsWith("URI//")) {
                        throw new IOException(location.getAbsolutePath() + " contains unexpected data: " + file2);
                    }
                    file2 = file2.substring("URI//".length());
                    file = new File(new URI(file2));
                }
                catch (Throwable throwable) {
                    IOUtil.close(fileInputStream);
                    throw throwable;
                }
                IOUtil.close((InputStream)fileInputStream);
                return file;
            }
            IOUtil.close((InputStream)fileInputStream);
        }
        if ((projectBase = new File(workspaceLocation, project.getName())).isDirectory()) {
            return projectBase;
        }
        return null;
    }

    private String getValue(Xpp3Dom element, String[] elementNames, String defaultValue) {
        String value = null;
        Xpp3Dom dom = element;
        for (int index = 0; dom != null && index < elementNames.length; dom = dom.getChild(elementNames[index]), ++index) {
        }
        if (dom != null) {
            value = dom.getValue();
        }
        if (value == null || value.trim().length() == 0) {
            return defaultValue;
        }
        return value;
    }

    private IdeDependency readArtefact(File projectLocation, Log logger) throws FileNotFoundException, XmlPullParserException, IOException {
        File pomFile;
        File projectFile = new File(projectLocation, ".project");
        String eclipseProjectName = projectLocation.getName();
        if (projectFile.exists()) {
            Xpp3Dom project = Xpp3DomBuilder.build((Reader)new FileReader(projectFile));
            eclipseProjectName = this.getValue(project, new String[]{"name"}, eclipseProjectName);
        }
        if ((pomFile = new File(projectLocation, "pom.xml")).exists()) {
            Xpp3Dom pom = Xpp3DomBuilder.build((Reader)new FileReader(pomFile));
            String artifact = this.getValue(pom, ARTEFACT_ID, null);
            String group = this.getValue(pom, GROUP_ID, this.getValue(pom, PARENT_GROUP_ID, null));
            String version = this.getValue(pom, VERSION, this.getValue(pom, PARENT_VERSION, null));
            String packaging = this.getValue(pom, PACKAGING, "jar");
            logger.debug((CharSequence)("found workspace artefact " + group + ":" + artifact + ":" + version + " " + packaging + " (" + eclipseProjectName + ")" + " -> " + projectLocation.getAbsolutePath()));
            return new IdeDependency(group, artifact, version, packaging, true, false, false, false, false, null, packaging, false, null, 0, eclipseProjectName);
        }
        logger.debug((CharSequence)("ignored workspace project NO pom available " + projectLocation.getAbsolutePath()));
        return null;
    }

    HashMap readDefinedServers(WorkspaceConfiguration workspaceConfiguration, Log logger) {
        HashMap<String, String> detectedRuntimes = new HashMap<String, String>();
        if (workspaceConfiguration.getWorkspaceDirectory() != null) {
            Xpp3Dom runtimesElement = null;
            try {
                File prefs = new File(workspaceConfiguration.getWorkspaceDirectory(), METADATA_PLUGINS_ORG_ECLIPSE_CORE_RUNTIME_SERVER_PREFS);
                if (prefs.exists()) {
                    Properties properties = new Properties();
                    properties.load(new FileInputStream(prefs));
                    String runtimes = properties.getProperty(METADATA_PLUGINS_ORG_ECLIPSE_CORE_RUNTIME_PREFS_RUNTIMES_KEY);
                    if (runtimes != null) {
                        runtimesElement = Xpp3DomBuilder.build((Reader)new StringReader(runtimes));
                    }
                }
            }
            catch (Exception e) {
                logger.error((CharSequence)("Could not read workspace wtp server runtimes preferences : " + e.getMessage()));
            }
            if (runtimesElement != null) {
                Xpp3Dom[] runtimeArray = runtimesElement.getChildren("runtime");
                for (int index = 0; runtimeArray != null && index < runtimeArray.length; ++index) {
                    String id = runtimeArray[index].getAttribute("id");
                    String name = runtimeArray[index].getAttribute("name");
                    if (detectedRuntimes.isEmpty()) {
                        logger.debug((CharSequence)("Using WTP runtime with id: \"" + id + "\" as default runtime"));
                        detectedRuntimes.put("", id);
                    }
                    detectedRuntimes.put(id, name);
                    logger.debug((CharSequence)("Detected WTP runtime with id: \"" + id + "\" and name: \"" + name + "\""));
                }
            }
        }
        return detectedRuntimes;
    }

    private HashMap readAvailableJREs(File workspaceLocation, Log logger) {
        Xpp3Dom vms;
        try {
            File prefs = new File(workspaceLocation, METADATA_PLUGINS_ORG_ECLIPSE_CORE_RUNTIME_LAUNCHING_PREFS);
            if (!prefs.exists()) {
                return null;
            }
            Properties properties = new Properties();
            properties.load(new FileInputStream(prefs));
            vms = Xpp3DomBuilder.build((Reader)new StringReader(properties.getProperty(METADATA_PLUGINS_ORG_ECLIPSE_CORE_RUNTIME_PREFS_VM_KEY)));
        }
        catch (Exception e) {
            logger.error((CharSequence)"Could not read workspace JRE preferences", (Throwable)e);
            return null;
        }
        HashMap<String, String> jreMap = new HashMap<String, String>();
        jreMap.put("1.2", "org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/J2SE-1.2");
        jreMap.put("1.3", "org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/J2SE-1.3");
        jreMap.put("1.4", "org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/J2SE-1.4");
        jreMap.put("1.5", "org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/J2SE-1.5");
        jreMap.put("5", (String)jreMap.get("1.5"));
        jreMap.put("1.6", "org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-1.6");
        jreMap.put("6", (String)jreMap.get("1.6"));
        String defaultJRE = vms.getAttribute("defaultVM").trim();
        Xpp3Dom[] vmTypes = vms.getChildren("vmType");
        for (int vmTypeIndex = 0; vmTypeIndex < vmTypes.length; ++vmTypeIndex) {
            String typeId = vmTypes[vmTypeIndex].getAttribute("id");
            Xpp3Dom[] vm = vmTypes[vmTypeIndex].getChildren("vm");
            for (int vmIndex = 0; vmIndex < vm.length; ++vmIndex) {
                try {
                    String path = vm[vmIndex].getAttribute("path");
                    String name = vm[vmIndex].getAttribute("name");
                    String vmId = vm[vmIndex].getAttribute("id").trim();
                    String classpathEntry = MessageFormat.format(CLASSPATHENTRY_FORMAT, typeId, name);
                    String jrePath = new File(path).getCanonicalPath();
                    File rtJarFile = new File(new File(jrePath), "jre/lib/rt.jar");
                    if (!rtJarFile.exists()) {
                        logger.warn((CharSequence)Messages.getString("EclipsePlugin.invalidvminworkspace", jrePath));
                        continue;
                    }
                    JarFile rtJar = new JarFile(rtJarFile);
                    String version = rtJar.getManifest().getMainAttributes().getValue("Specification-Version");
                    if (defaultJRE.endsWith("," + vmId)) {
                        jreMap.put(jrePath, CLASSPATHENTRY_DEFAULT);
                        jreMap.put(version, CLASSPATHENTRY_DEFAULT);
                        logger.debug((CharSequence)("Default Classpath Container version: " + version + "  location: " + jrePath));
                        continue;
                    }
                    if (!jreMap.containsKey(jrePath)) {
                        if (!jreMap.containsKey(version)) {
                            jreMap.put(version, classpathEntry);
                        }
                        jreMap.put(jrePath, classpathEntry);
                        logger.debug((CharSequence)("Additional Classpath Container version: " + version + " " + classpathEntry + " location: " + jrePath));
                        continue;
                    }
                    logger.debug((CharSequence)("Ignored (duplicated) additional Classpath Container version: " + version + " " + classpathEntry + " location: " + jrePath));
                    continue;
                }
                catch (IOException e) {
                    logger.warn((CharSequence)("Could not interpret entry: " + vm[vmIndex].toString()));
                }
            }
        }
        return jreMap;
    }

    private void readWorkspace(WorkspaceConfiguration workspaceConfiguration, Log logger) {
        ArrayList<IdeDependency> dependencies = new ArrayList<IdeDependency>();
        if (workspaceConfiguration.getWorkspaceDirectory() != null) {
            File workspace = new File(workspaceConfiguration.getWorkspaceDirectory(), METADATA_PLUGINS_ORG_ECLIPSE_CORE_RESOURCES_PROJECTS);
            File[] directories = workspace.listFiles();
            for (int index = 0; directories != null && index < directories.length; ++index) {
                File project = directories[index];
                if (!project.isDirectory()) continue;
                try {
                    File projectLocation = this.getProjectLocation(workspaceConfiguration.getWorkspaceDirectory(), project);
                    if (projectLocation == null) continue;
                    logger.debug((CharSequence)("read workpsace project " + projectLocation));
                    IdeDependency ideDependency = this.readArtefact(projectLocation, logger);
                    if (ideDependency == null) continue;
                    dependencies.add(ideDependency);
                    continue;
                }
                catch (Exception e) {
                    logger.warn((CharSequence)("could not read workspace project:" + project), (Throwable)e);
                }
            }
        }
        logger.debug((CharSequence)(dependencies.size() + " from workspace " + workspaceConfiguration.getWorkspaceDirectory()));
        workspaceConfiguration.setWorkspaceArtefacts(dependencies.toArray(new IdeDependency[dependencies.size()]));
    }
}

