/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.help;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputSource;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.model.io.xpp3.MavenXpp3WriterExOldSupport;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.help.AbstractEffectiveMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

@Mojo(name="effective-pom", aggregator=true)
public class EffectivePomMojo
extends AbstractEffectiveMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> projects;
    @Parameter(defaultValue="${mojo}", required=true, readonly=true)
    private MojoExecution mojoExecution;
    @Parameter(property="artifact")
    private String artifact;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose = false;

    public void execute() throws MojoExecutionException {
        if (StringUtils.isNotEmpty((String)this.artifact)) {
            this.project = this.getMavenProject(this.artifact);
        }
        StringWriter w = new StringWriter();
        String encoding = this.output != null ? this.project.getModel().getModelEncoding() : System.getProperty("file.encoding");
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w, StringUtils.repeat((String)" ", (int)2), encoding, null);
        EffectivePomMojo.writeHeader((XMLWriter)writer);
        if (this.shouldWriteAllEffectivePOMsInReactor()) {
            writer.startElement("projects");
            for (MavenProject subProject : this.projects) {
                this.writeEffectivePom(subProject, (XMLWriter)writer);
            }
            writer.endElement();
        } else {
            this.writeEffectivePom(this.project, (XMLWriter)writer);
        }
        String effectivePom = EffectivePomMojo.prettyFormat(w.toString(), encoding, false);
        if (this.verbose) {
            effectivePom = effectivePom.replaceAll("(?m)>\\s+<!--}", ">  <!-- ");
        }
        if (this.output != null) {
            try {
                EffectivePomMojo.writeXmlFile(this.output, effectivePom);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot write effective-POM to output: " + this.output, (Exception)e);
            }
            this.getLog().info((CharSequence)("Effective-POM written to: " + this.output));
        } else {
            if (MessageUtils.isColorEnabled()) {
                String comment = MessageUtils.buffer().project((Object)"<!--.-->").toString();
                int dotIndex = comment.indexOf(".");
                String commentStart = comment.substring(0, dotIndex);
                String commentEnd = comment.substring(dotIndex + 1);
                effectivePom = effectivePom.replaceAll("<!--", commentStart).replaceAll("-->", commentEnd);
            }
            StringBuilder message = new StringBuilder();
            message.append(LS);
            message.append("Effective POMs, after inheritance, interpolation, and profiles are applied:");
            message.append(LS).append(LS);
            message.append(effectivePom);
            message.append(LS);
            this.getLog().info((CharSequence)message.toString());
        }
    }

    private boolean shouldWriteAllEffectivePOMsInReactor() {
        MojoExecution.Source source = this.mojoExecution.getSource();
        return this.projects.size() > 1 && (source == MojoExecution.Source.CLI || source != MojoExecution.Source.CLI && this.projects.get(0).equals((Object)this.project));
    }

    private void writeEffectivePom(MavenProject project, XMLWriter writer) throws MojoExecutionException {
        Model pom = project.getModel();
        EffectivePomMojo.cleanModel(pom);
        StringWriter sWriter = new StringWriter();
        try {
            if (this.verbose) {
                if (!this.writeMavenXpp3WriterEx(sWriter, pom)) {
                    new EffectiveWriterExOldSupport().write(sWriter, pom);
                }
            } else {
                new MavenXpp3Writer().write((Writer)sWriter, pom);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot serialize POM to XML.", (Exception)e);
        }
        String effectivePom = EffectivePomMojo.prettyFormat(sWriter.toString(), null, true);
        EffectivePomMojo.writeComment(writer, "Effective POM for project '" + project.getId() + "'");
        writer.writeMarkup(effectivePom);
    }

    private static void cleanModel(Model pom) {
        AbstractEffectiveMojo.SortedProperties properties = new AbstractEffectiveMojo.SortedProperties();
        properties.putAll((Map<?, ?>)pom.getProperties());
        pom.setProperties((Properties)properties);
    }

    private void warnWriteMavenXpp3WriterEx(Throwable t) {
        this.getLog().warn((CharSequence)"Unexpected exception while running Maven Model Extended Writer, falling back to old internal implementation.", t);
    }

    private boolean writeMavenXpp3WriterEx(Writer writer, Model model) throws IOException {
        try {
            Class<?> mavenXpp3WriterExClass = Class.forName("org.apache.maven.model.io.xpp3.MavenXpp3WriterEx");
            Object mavenXpp3WriterEx = mavenXpp3WriterExClass.newInstance();
            Method setStringFormatter = mavenXpp3WriterExClass.getMethod("setStringFormatter", InputLocation.StringFormatter.class);
            setStringFormatter.invoke(mavenXpp3WriterEx, new Object[]{new InputLocationStringFormatter()});
            Method write = mavenXpp3WriterExClass.getMethod("write", Writer.class, Model.class);
            write.invoke(mavenXpp3WriterEx, writer, model);
            return true;
        }
        catch (ClassNotFoundException mavenXpp3WriterExClass) {
        }
        catch (NoSuchMethodException e) {
            this.warnWriteMavenXpp3WriterEx(e);
        }
        catch (SecurityException e) {
            this.warnWriteMavenXpp3WriterEx(e);
        }
        catch (InstantiationException e) {
            this.warnWriteMavenXpp3WriterEx(e);
        }
        catch (IllegalAccessException e) {
            this.warnWriteMavenXpp3WriterEx(e);
        }
        catch (IllegalArgumentException e) {
            this.warnWriteMavenXpp3WriterEx(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IOException) {
                throw (IOException)e.getTargetException();
            }
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            this.warnWriteMavenXpp3WriterEx(e);
        }
        return false;
    }

    private static String toString(InputLocation location) {
        InputSource source = location.getSource();
        String s = source.getModelId();
        if (StringUtils.isBlank((String)s) || s.contains("[unknown-version]")) {
            s = source.toString();
        }
        return '}' + s + (location.getLineNumber() >= 0 ? ", line " + location.getLineNumber() : "") + ' ';
    }

    private static class EffectiveWriterExOldSupport
    extends MavenXpp3WriterExOldSupport {
        private EffectiveWriterExOldSupport() {
        }

        @Override
        public String toString(InputLocation location) {
            return EffectivePomMojo.toString(location);
        }

        @Override
        protected void writeXpp3DomToSerializer(Xpp3Dom dom, XmlSerializer serializer) throws IOException {
            dom.writeToSerializer(null, serializer);
        }
    }

    private static class InputLocationStringFormatter
    extends InputLocation.StringFormatter {
        private InputLocationStringFormatter() {
        }

        public String toString(InputLocation location) {
            return EffectivePomMojo.toString(location);
        }
    }
}

