/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.install;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.digest.Digester;
import org.codehaus.plexus.digest.DigesterException;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractInstallMojo
extends AbstractMojo {
    protected ArtifactInstaller installer;
    protected ArtifactRepository localRepository;
    protected boolean createChecksum;
    protected Digester md5Digester;
    protected Digester sha1Digester;

    protected void installCheckSum(File file, boolean isPom) throws MojoExecutionException {
        this.installCheckSum(file, null, isPom);
    }

    protected void installCheckSum(File file, Artifact artifact, boolean isPom) throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)"Creating Checksums...");
            String md5Sum = this.getChecksum(file, "MD5");
            String sha1Sum = this.getChecksum(file, "SHA-1");
            File temp = File.createTempFile("maven-md5-checksum", null);
            temp.deleteOnExit();
            FileUtils.fileWrite((String)temp.getAbsolutePath(), (String)md5Sum);
            File tempSha1 = File.createTempFile("maven-sha1-checksum", null);
            tempSha1.deleteOnExit();
            FileUtils.fileWrite((String)tempSha1.getAbsolutePath(), (String)sha1Sum);
            File destination = null;
            if (isPom) {
                destination = file;
            } else {
                String localPath = this.localRepository.pathOf(artifact);
                destination = new File(this.localRepository.getBasedir(), localPath);
            }
            if (!destination.getParentFile().exists()) {
                destination.getParentFile().mkdirs();
            }
            this.getLog().debug((CharSequence)("Installing checksum for " + destination));
            FileUtils.copyFile((File)temp, (File)new File(destination + ".md5"));
            FileUtils.copyFile((File)tempSha1, (File)new File(destination + ".sha1"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating checksum", (Exception)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new MojoExecutionException("Error in algorithm", (Exception)e);
        }
        catch (DigesterException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected String getChecksum(File file, String algo) throws NoSuchAlgorithmException, DigesterException {
        if ("MD5".equals(algo)) {
            return this.md5Digester.calc(file);
        }
        if ("SHA-1".equals(algo)) {
            return this.sha1Digester.calc(file);
        }
        throw new NoSuchAlgorithmException("No support for algorithm " + algo + ".");
    }
}

