/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.install;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.install.AbstractInstallMojo;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;

public class InstallMojo
extends AbstractInstallMojo {
    protected String packaging;
    private File pomFile;
    private boolean updateReleaseInfo;
    private Artifact artifact;
    private List attachedArtifacts;

    public void execute() throws MojoExecutionException {
        boolean isPomArtifact = "pom".equals(this.packaging);
        ProjectArtifactMetadata metadata = null;
        if (this.updateReleaseInfo) {
            this.artifact.setRelease(true);
        }
        try {
            if (isPomArtifact) {
                this.installer.install(this.pomFile, this.artifact, this.localRepository);
            } else {
                metadata = new ProjectArtifactMetadata(this.artifact, this.pomFile);
                this.artifact.addMetadata((ArtifactMetadata)metadata);
                File file = this.artifact.getFile();
                if (file != null && !file.isDirectory()) {
                    this.installer.install(file, this.artifact, this.localRepository);
                    if (this.createChecksum) {
                        File pom = new File(this.localRepository.getBasedir(), this.localRepository.pathOfLocalRepositoryMetadata((ArtifactMetadata)metadata, this.localRepository));
                        this.installCheckSum(pom, true);
                        this.installCheckSum(file, this.artifact, false);
                    }
                } else if (!this.attachedArtifacts.isEmpty()) {
                    this.getLog().info((CharSequence)"No primary artifact to install, installing attached artifacts instead.");
                } else {
                    throw new MojoExecutionException("The packaging for this project did not assign a file to the build artifact");
                }
            }
            Iterator i = this.attachedArtifacts.iterator();
            while (i.hasNext()) {
                Artifact attached = (Artifact)i.next();
                this.installer.install(attached.getFile(), attached, this.localRepository);
                if (!this.createChecksum) continue;
                this.installCheckSum(attached.getFile(), attached, false);
            }
        }
        catch (ArtifactInstallationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

