/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.install;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.install.AbstractInstallMojo;
import org.apache.maven.plugin.install.InstallRequest;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;

@Mojo(name="install", defaultPhase=LifecyclePhase.INSTALL, threadSafe=true)
public class InstallMojo
extends AbstractInstallMojo {
    private static final AtomicInteger readyProjectsCounter = new AtomicInteger();
    private static final List<InstallRequest> installRequests = Collections.synchronizedList(new ArrayList());
    @Component
    private MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="false", property="installAtEnd")
    private boolean installAtEnd;
    @Parameter(defaultValue="${project.packaging}", required=true, readonly=true)
    protected String packaging;
    @Parameter(defaultValue="${project.file}", required=true, readonly=true)
    private File pomFile;
    @Parameter(property="maven.install.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${project.artifact}", required=true, readonly=true)
    private Artifact artifact;
    @Parameter(defaultValue="${project.attachedArtifacts}", required=true, readonly=true)
    private List<Artifact> attachedArtifacts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        boolean projectsReady;
        boolean bl = projectsReady = readyProjectsCounter.incrementAndGet() == this.reactorProjects.size();
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping artifact installation");
        } else {
            InstallRequest currentExecutionInstallRequest = new InstallRequest().setProject(this.project).setCreateChecksum(this.createChecksum).setUpdateReleaseInfo(this.updateReleaseInfo);
            if (!this.installAtEnd) {
                this.installProject(currentExecutionInstallRequest);
            } else {
                installRequests.add(currentExecutionInstallRequest);
                if (!projectsReady) {
                    this.getLog().info((CharSequence)("Installing " + this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion() + " at end"));
                }
            }
        }
        if (projectsReady) {
            List<InstallRequest> list = installRequests;
            synchronized (list) {
                while (!installRequests.isEmpty()) {
                    this.installProject(installRequests.remove(0));
                }
            }
        }
    }

    private void installProject(InstallRequest request) throws MojoExecutionException {
        MavenProject project = request.getProject();
        boolean createChecksum = request.isCreateChecksum();
        boolean updateReleaseInfo = request.isUpdateReleaseInfo();
        Artifact artifact = project.getArtifact();
        String packaging = project.getPackaging();
        File pomFile = project.getFile();
        List attachedArtifacts = project.getAttachedArtifacts();
        boolean isPomArtifact = "pom".equals(packaging);
        if (updateReleaseInfo) {
            artifact.setRelease(true);
        }
        try {
            LinkedHashSet<File> metadataFiles = new LinkedHashSet<File>();
            if (isPomArtifact) {
                this.installer.install(pomFile, artifact, this.localRepository);
                this.installChecksums(artifact, createChecksum);
                this.addMetaDataFilesForArtifact(artifact, metadataFiles, createChecksum);
            } else {
                ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(artifact, pomFile);
                artifact.addMetadata((ArtifactMetadata)metadata);
                File file = artifact.getFile();
                if (file != null && file.isFile()) {
                    this.installer.install(file, artifact, this.localRepository);
                    this.installChecksums(artifact, createChecksum);
                    this.addMetaDataFilesForArtifact(artifact, metadataFiles, createChecksum);
                } else if (!attachedArtifacts.isEmpty()) {
                    this.getLog().info((CharSequence)"No primary artifact to install, installing attached artifacts instead.");
                    Artifact pomArtifact = this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion());
                    pomArtifact.setFile(pomFile);
                    if (updateReleaseInfo) {
                        pomArtifact.setRelease(true);
                    }
                    this.installer.install(pomFile, pomArtifact, this.localRepository);
                    this.installChecksums(pomArtifact, createChecksum);
                    this.addMetaDataFilesForArtifact(pomArtifact, metadataFiles, createChecksum);
                } else {
                    throw new MojoExecutionException("The packaging for this project did not assign a file to the build artifact");
                }
            }
            for (Artifact attached : attachedArtifacts) {
                this.installer.install(attached.getFile(), attached, this.localRepository);
                this.installChecksums(attached, createChecksum);
                this.addMetaDataFilesForArtifact(attached, metadataFiles, createChecksum);
            }
            this.installChecksums(metadataFiles);
        }
        catch (ArtifactInstallationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }
}

