/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pdf;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.doxia.document.DocumentModel;
import org.apache.maven.doxia.document.io.xpp3.DocumentXpp3Reader;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.pdf.DateBean;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.introspection.ReflectionValueExtractor;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DocumentDescriptorReader {
    private final MavenProject project;
    private final Log log;

    public DocumentDescriptorReader() {
        this(null, null);
    }

    public DocumentDescriptorReader(MavenProject project) {
        this(project, null);
    }

    public DocumentDescriptorReader(MavenProject project, Log log) {
        this.project = project;
        this.log = log;
    }

    public DocumentModel readAndFilterDocumentDescriptor(File docDescriptor) throws XmlPullParserException, IOException {
        DocumentModel documentModel;
        XmlStreamReader reader = null;
        try {
            Properties filterProperties = System.getProperties();
            if (this.project != null && this.project.getProperties() != null) {
                filterProperties.putAll((Map<?, ?>)this.project.getProperties());
            }
            RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
            interpolator.addValueSource((ValueSource)new MapBasedValueSource((Map)filterProperties));
            interpolator.addValueSource((ValueSource)new EnvarBasedValueSource());
            interpolator.addValueSource((ValueSource)new ObjectBasedValueSource(this.project){

                public Object getValue(String expression) {
                    try {
                        return ReflectionValueExtractor.evaluate((String)expression, (Object)DocumentDescriptorReader.this.project);
                    }
                    catch (Exception e) {
                        this.addFeedback("Failed to extract '" + expression + "' from: " + DocumentDescriptorReader.this.project, e);
                        return null;
                    }
                }
            });
            DateBean bean = new DateBean();
            interpolator.addValueSource((ValueSource)new ObjectBasedValueSource((Object)bean));
            reader = ReaderFactory.newXmlReader((File)docDescriptor);
            String interpolatedDoc = interpolator.interpolate(IOUtil.toString((Reader)reader));
            if (this.log != null && this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Interpolated document descriptor (" + docDescriptor.getAbsolutePath() + ")\n" + interpolatedDoc));
            }
            documentModel = new DocumentXpp3Reader().read((Reader)new StringReader(interpolatedDoc), false);
        }
        catch (InterpolationException e) {
            try {
                IOException io = new IOException("Error interpolating document descriptor");
                io.initCause(e);
                throw io;
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        return documentModel;
    }
}

