/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pdf;

import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.doxia.document.DocumentModel;
import org.apache.maven.doxia.document.DocumentTOC;
import org.apache.maven.doxia.document.DocumentTOCItem;
import org.apache.maven.model.Reporting;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.pdf.PdfMojo;
import org.apache.maven.plugins.pdf.TocFileHelper;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="aggregate", aggregator=true, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
@Execute(goal="pdf")
public class PdfAggregateMojo
extends PdfMojo {
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${project.build.directory}/pdf-aggregate", required=true)
    private File aggregatedOutputDirectory;
    @Parameter(defaultValue="${project.build.directory}/pdf-aggregate", required=true)
    private File aggregatedWorkingDirectory;

    @Override
    protected File getOutputDirectory() {
        return this.aggregatedOutputDirectory;
    }

    @Override
    protected File getWorkingDirectory() {
        return this.aggregatedWorkingDirectory;
    }

    @Override
    protected boolean isIncludeReports() {
        return false;
    }

    @Override
    protected void prepareTempSiteDirectory(File tmpSiteDir) {
        tmpSiteDir.mkdirs();
    }

    @Override
    protected void appendGeneratedReports(DocumentModel model, Locale locale) {
        super.appendGeneratedReports(model, locale);
        this.getLog().info((CharSequence)"Appending staged reports.");
        DocumentTOC toc = model.getToc();
        File dstSiteTmp = null;
        try {
            dstSiteTmp = this.getSiteDirectoryTmp();
        }
        catch (IOException ioe) {
            this.getLog().error((CharSequence)"unexpected IOException while getting aggregator root tmp site dir", (Throwable)ioe);
        }
        if (!dstSiteTmp.exists()) {
            this.getLog().error((CharSequence)"Top-level project does not have src.tmp directory");
            return;
        }
        for (MavenProject reactorProject : this.reactorProjects) {
            this.getLog().info((CharSequence)("Appending " + reactorProject.getArtifactId() + " reports."));
            this.copySiteDirectoryTmp(reactorProject, dstSiteTmp);
            this.addTOCItems(toc, reactorProject);
        }
    }

    private void copySiteDirectoryTmp(MavenProject project, File dstSiteTmp) {
        Reporting reporting = project.getReporting();
        if (reporting == null) {
            this.getLog().info((CharSequence)("Skipping reactor project " + project + ": no reporting"));
            return;
        }
        File srcSiteTmp = this.getModuleSiteDirectoryTmp(project);
        if (!srcSiteTmp.exists()) {
            this.getLog().info((CharSequence)("Skipping reactor project " + project + ": no site.tmp directory"));
            return;
        }
        String stagedId = this.getStagedId(project);
        try {
            String defaultExcludes = FileUtils.getDefaultExcludesAsString();
            List srcDirNames = FileUtils.getDirectoryNames((File)srcSiteTmp, (String)"*", (String)defaultExcludes, (boolean)false);
            for (String srcDirName : srcDirNames) {
                File srcDir = new File(srcSiteTmp, srcDirName);
                File dstDir = new File(new File(dstSiteTmp, srcDirName), stagedId);
                if (!dstDir.exists() && !dstDir.mkdirs()) {
                    this.getLog().error((CharSequence)("Could not create directory: " + dstDir));
                    return;
                }
                FileUtils.copyDirectoryStructure((File)srcDir, (File)dstDir);
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Error while copying sub-project " + project.getArtifactId() + " site.tmp: " + e.getMessage()), (Throwable)e);
        }
    }

    private void addTOCItems(DocumentTOC topLevelToc, MavenProject project) {
        String stagedId = this.getStagedId(project);
        Map<String, Object> toc = this.loadToc(project);
        List items = (ArrayList)toc.get("items");
        DocumentTOCItem tocItem = new DocumentTOCItem();
        tocItem.setName(project.getName());
        tocItem.setRef(stagedId);
        if (items.size() == 1 && "project-info".equals(((Map)items.get(0)).get("ref"))) {
            items = (List)((Map)items.get(0)).get("items");
        }
        for (Map item : items) {
            this.addTOCItems(tocItem, item, stagedId);
        }
        topLevelToc.addItem(tocItem);
    }

    private Map<String, Object> loadToc(MavenProject project) {
        try {
            return TocFileHelper.loadToc(this.getModuleWorkingDirectory(project));
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Error while reading table of contents of module " + project.getArtifactId()), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private void addTOCItems(DocumentTOCItem parent, Map<String, Object> item, String stagedId) {
        DocumentTOCItem tocItem = new DocumentTOCItem();
        tocItem.setName((String)item.get("name"));
        tocItem.setRef(stagedId + "/" + item.get("ref"));
        List items = (List)item.get("items");
        for (Map it : items) {
            this.addTOCItems(tocItem, it, stagedId);
        }
        parent.addItem(tocItem);
    }

    private String getStagedId(MavenProject p) {
        ArrayDeque<String> projectPath = new ArrayDeque<String>();
        projectPath.addFirst(p.getArtifactId());
        while (p.getParent() != null) {
            p = p.getParent();
            projectPath.addFirst(p.getArtifactId());
        }
        StringBuilder stagedId = new StringBuilder();
        Iterator artifactIds = projectPath.iterator();
        while (artifactIds.hasNext()) {
            stagedId.append((String)artifactIds.next());
            if (!artifactIds.hasNext()) continue;
            stagedId.append('/');
        }
        return stagedId.toString();
    }

    private File getModuleWorkingDirectory(MavenProject project) {
        return new File(project.getBuild().getDirectory(), "pdf");
    }

    private File getModuleSiteDirectoryTmp(MavenProject project) {
        return new File(this.getModuleWorkingDirectory(project), "site.tmp");
    }
}

