/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.Locale;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.report.projectinfo.dependencies.ManagementDependencies;
import org.apache.maven.report.projectinfo.dependencies.RepositoryUtils;
import org.apache.maven.report.projectinfo.dependencies.renderer.DependencyManagementRenderer;

@Mojo(name="dependency-management", requiresDependencyResolution=ResolutionScope.TEST)
public class DependencyManagementReport
extends AbstractProjectInfoReport {
    @Component
    private MavenProjectBuilder mavenProjectBuilder;
    @Component
    protected ArtifactMetadataSource artifactMetadataSource;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private WagonManager wagonManager;
    @Component
    private RepositoryMetadataManager repositoryMetadataManager;
    private ManagementDependencies managementDependencies;

    public void executeReport(Locale locale) {
        RepositoryUtils repoUtils = new RepositoryUtils(this.getLog(), this.wagonManager, this.settings, this.mavenProjectBuilder, this.factory, this.resolver, this.project.getRemoteArtifactRepositories(), this.project.getPluginArtifactRepositories(), this.localRepository, this.repositoryMetadataManager);
        DependencyManagementRenderer r = new DependencyManagementRenderer(this.getSink(), locale, this.getI18N(locale), this.getLog(), this.getManagementDependencies(), this.artifactMetadataSource, this.artifactFactory, this.mavenProjectBuilder, this.remoteRepositories, this.localRepository, repoUtils);
        r.render();
    }

    public String getOutputName() {
        return "dependency-management";
    }

    protected String getI18Nsection() {
        return "dependencyManagement";
    }

    public boolean canGenerateReport() {
        return this.getManagementDependencies().hasDependencies();
    }

    private ManagementDependencies getManagementDependencies() {
        if (this.managementDependencies != null) {
            return this.managementDependencies;
        }
        this.managementDependencies = this.project.getDependencyManagement() == null ? new ManagementDependencies(null) : new ManagementDependencies(this.project.getDependencyManagement().getDependencies());
        return this.managementDependencies;
    }
}

