/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.report.projectinfo.dependencies.DependencyVersionMap;
import org.apache.maven.report.projectinfo.dependencies.SinkSerializingDependencyNodeVisitor;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.shared.artifact.filter.StrictPatternIncludesArtifactFilter;
import org.apache.maven.shared.dependency.graph.DependencyCollectorBuilder;
import org.apache.maven.shared.dependency.graph.DependencyCollectorBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.filter.AncestorOrSelfDependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.filter.AndDependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.filter.ArtifactDependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.filter.DependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.traversal.BuildingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.FilteringDependencyNodeVisitor;

@Mojo(name="dependency-convergence", aggregator=true)
public class DependencyConvergenceReport
extends AbstractProjectInfoReport {
    private static final String IMG_SUCCESS_URL = "images/icon_success_sml.gif";
    private static final String IMG_ERROR_URL = "images/icon_error_sml.gif";
    private static final int FULL_CONVERGENCE = 100;
    @Component
    private DependencyCollectorBuilder dependencyCollectorBuilder;
    private ArtifactFilter filter = null;
    private Map<MavenProject, DependencyNode> projectMap = new HashMap<MavenProject, DependencyNode>();

    public String getOutputName() {
        return "dependency-convergence";
    }

    @Override
    protected String getI18Nsection() {
        return "dependency-convergence";
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        Sink sink = this.getSink();
        sink.head();
        sink.title();
        if (this.isReactorBuild()) {
            sink.text(this.getI18nString(locale, "reactor.title"));
        } else {
            sink.text(this.getI18nString(locale, "title"));
        }
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        if (this.isReactorBuild()) {
            sink.text(this.getI18nString(locale, "reactor.title"));
        } else {
            sink.text(this.getI18nString(locale, "title"));
        }
        sink.sectionTitle1_();
        DependencyAnalyzeResult dependencyResult = this.analyzeDependencyTree();
        int convergence = this.calculateConvergence(dependencyResult);
        if (convergence < 100) {
            this.generateLegend(locale, sink);
            sink.lineBreak();
        }
        this.generateStats(locale, sink, dependencyResult);
        sink.section1_();
        if (convergence < 100) {
            this.generateConvergence(locale, sink, dependencyResult);
        }
        sink.body_();
        sink.flush();
        sink.close();
    }

    private List<ReverseDependencyLink> getSnapshotDependencies(Map<String, List<ReverseDependencyLink>> dependencyMap) {
        ArrayList<ReverseDependencyLink> snapshots = new ArrayList<ReverseDependencyLink>();
        for (Map.Entry<String, List<ReverseDependencyLink>> entry : dependencyMap.entrySet()) {
            List<ReverseDependencyLink> depList = entry.getValue();
            Map<String, List<ReverseDependencyLink>> artifactMap = this.getSortedUniqueArtifactMap(depList);
            for (Map.Entry<String, List<ReverseDependencyLink>> artEntry : artifactMap.entrySet()) {
                String version = artEntry.getKey();
                boolean isReactorProject = false;
                Iterator<ReverseDependencyLink> iterator = artEntry.getValue().iterator();
                ReverseDependencyLink rdl = null;
                if (iterator.hasNext() && this.isReactorProject((rdl = iterator.next()).getDependency())) {
                    isReactorProject = true;
                }
                if (!version.endsWith("-SNAPSHOT") || isReactorProject || rdl == null) continue;
                snapshots.add(rdl);
            }
        }
        return snapshots;
    }

    private void generateConvergence(Locale locale, Sink sink, DependencyAnalyzeResult result) {
        List<ReverseDependencyLink> depList;
        sink.section2();
        sink.sectionTitle2();
        if (this.isReactorBuild()) {
            sink.text(this.getI18nString(locale, "convergence.caption"));
        } else {
            sink.text(this.getI18nString(locale, "convergence.single.caption"));
        }
        sink.sectionTitle2_();
        for (Map.Entry<String, List<ReverseDependencyLink>> entry : result.getConflicting().entrySet()) {
            String key = entry.getKey();
            depList = entry.getValue();
            sink.section3();
            sink.sectionTitle3();
            sink.text(key);
            sink.sectionTitle3_();
            this.generateDependencyDetails(locale, sink, depList);
            sink.section3_();
        }
        for (ReverseDependencyLink dependencyLink : result.getSnapshots()) {
            sink.section3();
            sink.sectionTitle3();
            Dependency dep = dependencyLink.getDependency();
            sink.text(dep.getGroupId() + ":" + dep.getArtifactId());
            sink.sectionTitle3_();
            depList = new ArrayList<ReverseDependencyLink>();
            depList.add(dependencyLink);
            this.generateDependencyDetails(locale, sink, depList);
            sink.section3_();
        }
        sink.section2_();
    }

    private void generateDependencyDetails(Locale locale, Sink sink, List<ReverseDependencyLink> depList) {
        sink.table();
        sink.tableRows(null, false);
        Map<String, List<ReverseDependencyLink>> artifactMap = this.getSortedUniqueArtifactMap(depList);
        sink.tableRow();
        sink.tableCell();
        this.iconError(locale, sink);
        sink.tableCell_();
        sink.tableCell();
        sink.table();
        sink.tableRows(null, false);
        for (String version : artifactMap.keySet()) {
            sink.tableRow();
            sink.tableCell((SinkEventAttributes)new SinkEventAttributeSet(new String[]{"width", "25%"}));
            sink.text(version);
            sink.tableCell_();
            sink.tableCell();
            this.generateVersionDetails(sink, artifactMap, version);
            sink.tableCell_();
            sink.tableRow_();
        }
        sink.tableRows_();
        sink.table_();
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRows_();
        sink.table_();
    }

    private void generateVersionDetails(Sink sink, Map<String, List<ReverseDependencyLink>> artifactMap, String version) {
        sink.numberedList(0);
        List<ReverseDependencyLink> depList = artifactMap.get(version);
        List<DependencyNode> projectNodes = this.getProjectNodes(depList);
        if (projectNodes.isEmpty()) {
            this.getLog().warn((CharSequence)("Can't find project nodes for dependency list: " + depList.get(0).getDependency()));
            return;
        }
        Collections.sort(projectNodes, new DependencyNodeComparator());
        for (DependencyNode projectNode : projectNodes) {
            if (this.isReactorBuild()) {
                sink.numberedListItem();
            }
            this.showVersionDetails(projectNode, depList, sink);
            if (this.isReactorBuild()) {
                sink.numberedListItem_();
            }
            sink.lineBreak();
        }
        sink.numberedList_();
    }

    private List<DependencyNode> getProjectNodes(List<ReverseDependencyLink> depList) {
        ArrayList<DependencyNode> projectNodes = new ArrayList<DependencyNode>();
        for (ReverseDependencyLink depLink : depList) {
            MavenProject project = depLink.getProject();
            DependencyNode projectNode = this.projectMap.get(project);
            if (projectNode == null || projectNodes.contains(projectNode)) continue;
            projectNodes.add(projectNode);
        }
        return projectNodes;
    }

    private void showVersionDetails(DependencyNode projectNode, List<ReverseDependencyLink> depList, Sink sink) {
        if (depList == null || depList.isEmpty()) {
            return;
        }
        Dependency dependency = depList.get(0).getDependency();
        String key = dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getType() + ":" + dependency.getVersion();
        this.serializeDependencyTree(projectNode, key, sink);
    }

    private void serializeDependencyTree(DependencyNode rootNode, String key, Sink sink) {
        DependencyNodeVisitor visitor = this.getSerializingDependencyNodeVisitor(sink);
        visitor = new BuildingDependencyNodeVisitor(visitor);
        DependencyNodeFilter nodeFilter = this.createDependencyNodeFilter(key);
        if (nodeFilter != null) {
            CollectingDependencyNodeVisitor collectingVisitor = new CollectingDependencyNodeVisitor();
            FilteringDependencyNodeVisitor firstPassVisitor = new FilteringDependencyNodeVisitor((DependencyNodeVisitor)collectingVisitor, nodeFilter);
            rootNode.accept((DependencyNodeVisitor)firstPassVisitor);
            AncestorOrSelfDependencyNodeFilter secondPassFilter = new AncestorOrSelfDependencyNodeFilter(collectingVisitor.getNodes());
            visitor = new FilteringDependencyNodeVisitor(visitor, (DependencyNodeFilter)secondPassFilter);
        }
        rootNode.accept(visitor);
    }

    private DependencyNodeFilter createDependencyNodeFilter(String includes) {
        ArrayList<ArtifactDependencyNodeFilter> filters = new ArrayList<ArtifactDependencyNodeFilter>();
        if (includes != null) {
            List<String> patterns = Arrays.asList(includes.split(","));
            this.getLog().debug((CharSequence)("+ Filtering dependency tree by artifact include patterns: " + patterns));
            StrictPatternIncludesArtifactFilter artifactFilter = new StrictPatternIncludesArtifactFilter(patterns);
            filters.add(new ArtifactDependencyNodeFilter((ArtifactFilter)artifactFilter));
        }
        return filters.isEmpty() ? null : new AndDependencyNodeFilter(filters);
    }

    public DependencyNodeVisitor getSerializingDependencyNodeVisitor(Sink sink) {
        return new SinkSerializingDependencyNodeVisitor(sink);
    }

    private Map<String, List<ReverseDependencyLink>> getSortedUniqueArtifactMap(List<ReverseDependencyLink> depList) {
        TreeMap<String, List<ReverseDependencyLink>> uniqueArtifactMap = new TreeMap<String, List<ReverseDependencyLink>>();
        for (ReverseDependencyLink rdl : depList) {
            String key = rdl.getDependency().getVersion();
            ArrayList<ReverseDependencyLink> projectList = (ArrayList<ReverseDependencyLink>)uniqueArtifactMap.get(key);
            if (projectList == null) {
                projectList = new ArrayList<ReverseDependencyLink>();
            }
            projectList.add(rdl);
            uniqueArtifactMap.put(key, projectList);
        }
        return uniqueArtifactMap;
    }

    private void generateLegend(Locale locale, Sink sink) {
        sink.table();
        sink.tableRows(null, false);
        sink.tableCaption();
        sink.bold();
        sink.text(this.getI18nString(locale, "legend"));
        sink.bold_();
        sink.tableCaption_();
        sink.tableRow();
        sink.tableCell();
        this.iconError(locale, sink);
        sink.tableCell_();
        sink.tableCell();
        sink.text(this.getI18nString(locale, "legend.different"));
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRows_();
        sink.table_();
    }

    private void generateStats(Locale locale, Sink sink, DependencyAnalyzeResult result) {
        int depCount = result.getDependencyCount();
        int artifactCount = result.getArtifactCount();
        int snapshotCount = result.getSnapshotCount();
        int conflictingCount = result.getConflictingCount();
        int convergence = this.calculateConvergence(result);
        sink.table();
        sink.tableRows(null, false);
        sink.tableCaption();
        sink.bold();
        sink.text(this.getI18nString(locale, "stats.caption"));
        sink.bold_();
        sink.tableCaption_();
        if (this.isReactorBuild()) {
            sink.tableRow();
            sink.tableHeaderCell();
            sink.text(this.getI18nString(locale, "stats.modules"));
            sink.tableHeaderCell_();
            sink.tableCell();
            sink.text(String.valueOf(this.reactorProjects.size()));
            sink.tableCell_();
            sink.tableRow_();
        }
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(this.getI18nString(locale, "stats.dependencies"));
        sink.tableHeaderCell_();
        sink.tableCell();
        sink.text(String.valueOf(depCount));
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(this.getI18nString(locale, "stats.artifacts"));
        sink.tableHeaderCell_();
        sink.tableCell();
        sink.text(String.valueOf(artifactCount));
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(this.getI18nString(locale, "stats.conflicting"));
        sink.tableHeaderCell_();
        sink.tableCell();
        sink.text(String.valueOf(conflictingCount));
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(this.getI18nString(locale, "stats.snapshots"));
        sink.tableHeaderCell_();
        sink.tableCell();
        sink.text(String.valueOf(snapshotCount));
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(this.getI18nString(locale, "stats.convergence"));
        sink.tableHeaderCell_();
        sink.tableCell();
        if (convergence < 100) {
            this.iconError(locale, sink);
        } else {
            this.iconSuccess(locale, sink);
        }
        sink.nonBreakingSpace();
        sink.bold();
        sink.text(String.valueOf(convergence) + " %");
        sink.bold_();
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(this.getI18nString(locale, "stats.readyrelease"));
        sink.tableHeaderCell_();
        sink.tableCell();
        if (convergence >= 100 && snapshotCount <= 0) {
            this.iconSuccess(locale, sink);
            sink.nonBreakingSpace();
            sink.bold();
            sink.text(this.getI18nString(locale, "stats.readyrelease.success"));
            sink.bold_();
        } else {
            this.iconError(locale, sink);
            sink.nonBreakingSpace();
            sink.bold();
            sink.text(this.getI18nString(locale, "stats.readyrelease.error"));
            sink.bold_();
            if (convergence < 100) {
                sink.lineBreak();
                sink.text(this.getI18nString(locale, "stats.readyrelease.error.convergence"));
            }
            if (snapshotCount > 0) {
                sink.lineBreak();
                sink.text(this.getI18nString(locale, "stats.readyrelease.error.snapshots"));
            }
        }
        sink.tableCell_();
        sink.tableRow_();
        sink.tableRows_();
        sink.table_();
    }

    private boolean isReactorProject(Dependency dependency) {
        for (MavenProject mavenProject : this.reactorProjects) {
            if (!mavenProject.getGroupId().equals(dependency.getGroupId()) || !mavenProject.getArtifactId().equals(dependency.getArtifactId())) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)(dependency + " is a reactor project"));
            }
            return true;
        }
        return false;
    }

    private boolean isReactorBuild() {
        return this.reactorProjects.size() > 1;
    }

    private void iconSuccess(Locale locale, Sink sink) {
        SinkEventAttributeSet attributes = new SinkEventAttributeSet(new String[]{"alt", this.getI18nString(locale, "icon.success")});
        sink.figureGraphics(IMG_SUCCESS_URL, (SinkEventAttributes)attributes);
    }

    private void iconError(Locale locale, Sink sink) {
        SinkEventAttributeSet attributes = new SinkEventAttributeSet(new String[]{"alt", this.getI18nString(locale, "icon.error")});
        sink.figureGraphics(IMG_ERROR_URL, (SinkEventAttributes)attributes);
    }

    private DependencyAnalyzeResult analyzeDependencyTree() throws MavenReportException {
        TreeMap<String, List<ReverseDependencyLink>> conflictingDependencyMap = new TreeMap<String, List<ReverseDependencyLink>>();
        TreeMap<String, List<ReverseDependencyLink>> allDependencies = new TreeMap<String, List<ReverseDependencyLink>>();
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.getSession().getProjectBuildingRequest());
        for (MavenProject reactorProject : this.reactorProjects) {
            buildingRequest.setProject(reactorProject);
            DependencyNode node = this.getNode((ProjectBuildingRequest)buildingRequest);
            this.projectMap.put(reactorProject, node);
            this.getConflictingDependencyMap(conflictingDependencyMap, reactorProject, node);
            this.getAllDependencyMap(allDependencies, reactorProject, node);
        }
        return this.populateDependencyAnalyzeResult(conflictingDependencyMap, allDependencies);
    }

    private DependencyAnalyzeResult populateDependencyAnalyzeResult(Map<String, List<ReverseDependencyLink>> conflictingDependencyMap, Map<String, List<ReverseDependencyLink>> allDependencies) {
        DependencyAnalyzeResult dependencyResult = new DependencyAnalyzeResult();
        dependencyResult.setAll(allDependencies);
        dependencyResult.setConflicting(conflictingDependencyMap);
        List<ReverseDependencyLink> snapshots = this.getSnapshotDependencies(allDependencies);
        dependencyResult.setSnapshots(snapshots);
        return dependencyResult;
    }

    private void getConflictingDependencyMap(Map<String, List<ReverseDependencyLink>> conflictingDependencyMap, MavenProject reactorProject, DependencyNode node) {
        DependencyVersionMap visitor = new DependencyVersionMap();
        visitor.setUniqueVersions(true);
        node.accept((DependencyNodeVisitor)visitor);
        for (List<DependencyNode> nodes : visitor.getConflictedVersionNumbers()) {
            DependencyNode dependencyNode = nodes.get(0);
            String key = dependencyNode.getArtifact().getGroupId() + ":" + dependencyNode.getArtifact().getArtifactId();
            List<ReverseDependencyLink> dependencyList = conflictingDependencyMap.get(key);
            if (dependencyList == null) {
                dependencyList = new ArrayList<ReverseDependencyLink>();
            }
            dependencyList.add(new ReverseDependencyLink(this.toDependency(dependencyNode.getArtifact()), reactorProject));
            for (DependencyNode workNode : nodes.subList(1, nodes.size())) {
                dependencyList.add(new ReverseDependencyLink(this.toDependency(workNode.getArtifact()), reactorProject));
            }
            conflictingDependencyMap.put(key, dependencyList);
        }
    }

    private void getAllDependencyMap(Map<String, List<ReverseDependencyLink>> allDependencies, MavenProject reactorProject, DependencyNode node) {
        Set<Artifact> artifacts = this.getAllDescendants(node);
        for (Artifact art : artifacts) {
            String key = art.getGroupId() + ":" + art.getArtifactId();
            List<ReverseDependencyLink> reverseDepependencies = allDependencies.get(key);
            if (reverseDepependencies == null) {
                reverseDepependencies = new ArrayList<ReverseDependencyLink>();
            }
            if (!this.containsDependency(reverseDepependencies, art)) {
                reverseDepependencies.add(new ReverseDependencyLink(this.toDependency(art), reactorProject));
            }
            allDependencies.put(key, reverseDepependencies);
        }
    }

    private Dependency toDependency(Artifact artifact) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(artifact.getGroupId());
        dependency.setArtifactId(artifact.getArtifactId());
        dependency.setVersion(artifact.getVersion());
        dependency.setClassifier(artifact.getClassifier());
        dependency.setScope(artifact.getScope());
        return dependency;
    }

    private boolean containsDependency(List<ReverseDependencyLink> reverseDependencies, Artifact art) {
        for (ReverseDependencyLink revDependency : reverseDependencies) {
            Dependency dep = revDependency.getDependency();
            if (!dep.getGroupId().equals(art.getGroupId()) || !dep.getArtifactId().equals(art.getArtifactId()) || !dep.getVersion().equals(art.getVersion())) continue;
            return true;
        }
        return false;
    }

    private DependencyNode getNode(ProjectBuildingRequest buildingRequest) throws MavenReportException {
        try {
            return this.dependencyCollectorBuilder.collectDependencyGraph(buildingRequest, this.filter);
        }
        catch (DependencyCollectorBuilderException e) {
            throw new MavenReportException("Could not build dependency tree: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private Set<Artifact> getAllDescendants(DependencyNode node) {
        HashSet<Artifact> children = null;
        if (node.getChildren() != null) {
            children = new HashSet<Artifact>();
            for (DependencyNode depNode : node.getChildren()) {
                children.add(depNode.getArtifact());
                Set<Artifact> subNodes = this.getAllDescendants(depNode);
                if (subNodes == null) continue;
                children.addAll(subNodes);
            }
        }
        return children;
    }

    private int calculateConvergence(DependencyAnalyzeResult result) {
        return (int)((double)result.getDependencyCount() / (double)result.getArtifactCount() * 100.0);
    }

    private class DependencyAnalyzeResult {
        Map<String, List<ReverseDependencyLink>> all;
        List<ReverseDependencyLink> snapshots;
        Map<String, List<ReverseDependencyLink>> conflicting;

        private DependencyAnalyzeResult() {
        }

        public void setAll(Map<String, List<ReverseDependencyLink>> all) {
            this.all = all;
        }

        public List<ReverseDependencyLink> getSnapshots() {
            return this.snapshots;
        }

        public void setSnapshots(List<ReverseDependencyLink> snapshots) {
            this.snapshots = snapshots;
        }

        public Map<String, List<ReverseDependencyLink>> getConflicting() {
            return this.conflicting;
        }

        public void setConflicting(Map<String, List<ReverseDependencyLink>> conflicting) {
            this.conflicting = conflicting;
        }

        public int getDependencyCount() {
            return this.all.size();
        }

        public int getSnapshotCount() {
            return this.snapshots.size();
        }

        public int getConflictingCount() {
            return this.conflicting.size();
        }

        public int getArtifactCount() {
            int artifactCount = 0;
            for (List<ReverseDependencyLink> depList : this.all.values()) {
                Map artifactMap = DependencyConvergenceReport.this.getSortedUniqueArtifactMap(depList);
                artifactCount += artifactMap.size();
            }
            return artifactCount;
        }
    }

    static class DependencyNodeComparator
    implements Comparator<DependencyNode> {
        DependencyNodeComparator() {
        }

        @Override
        public int compare(DependencyNode p1, DependencyNode p2) {
            return p1.getArtifact().getId().compareTo(p2.getArtifact().getId());
        }
    }

    private static class ReverseDependencyLink {
        private Dependency dependency;
        protected MavenProject project;

        ReverseDependencyLink(Dependency dependency, MavenProject project) {
            this.dependency = dependency;
            this.project = project;
        }

        public Dependency getDependency() {
            return this.dependency;
        }

        public MavenProject getProject() {
            return this.project;
        }

        public String toString() {
            return this.project.getId();
        }
    }
}

