/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.io.xpp3.DecorationXpp3Reader;
import org.apache.maven.doxia.tools.SiteToolException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.site.AbstractSiteMojo;
import org.apache.maven.plugins.site.SiteDescriptorArtifactMetadata;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class SiteDescriptorAttachMojo
extends AbstractSiteMojo {
    private Artifact artifact;
    private File basedir;

    public void execute() throws MojoExecutionException {
        List localesList = this.siteTool.getAvailableLocales(this.locales);
        Iterator iterator = localesList.iterator();
        while (iterator.hasNext()) {
            DecorationModel decoration;
            Locale locale = (Locale)iterator.next();
            File descriptorFile = this.siteTool.getSiteDescriptorFromBasedir(SiteDescriptorAttachMojo.toRelative(this.project.getBasedir(), this.siteDirectory.getAbsolutePath()), this.basedir, locale);
            if (!descriptorFile.exists()) continue;
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("reports", "<menu ref=\"reports\"/>");
            props.put("modules", "<menu ref=\"modules\"/>");
            try {
                String siteDescriptorContent = IOUtil.toString((Reader)ReaderFactory.newXmlReader((File)descriptorFile));
                siteDescriptorContent = this.siteTool.getInterpolatedSiteDescriptorContent(props, this.project, siteDescriptorContent, this.getInputEncoding(), this.getOutputEncoding());
                decoration = new DecorationXpp3Reader().read((Reader)new StringReader(siteDescriptorContent));
            }
            catch (XmlPullParserException e) {
                throw new MojoExecutionException("Error parsing site descriptor", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error reading site descriptor", (Exception)e);
            }
            catch (SiteToolException e) {
                throw new MojoExecutionException("Error when interpoling site descriptor", (Exception)((Object)e));
            }
            MavenProject parentProject = this.siteTool.getParentProject(this.project, this.reactorProjects, this.localRepository);
            if (parentProject != null && this.project.getUrl() != null && parentProject.getUrl() != null) {
                this.siteTool.populateParentMenu(decoration, locale, this.project, parentProject, true);
            }
            try {
                this.siteTool.populateModulesMenu(this.project, this.reactorProjects, this.localRepository, decoration, locale, true);
            }
            catch (SiteToolException e) {
                throw new MojoExecutionException("Error when populating modules", (Exception)((Object)e));
            }
            this.artifact.addMetadata((ArtifactMetadata)new SiteDescriptorArtifactMetadata(this.artifact, decoration, descriptorFile));
        }
    }
}

