/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.reporting;

import org.apache.commons.validator.routines.RegexValidator;
import org.apache.commons.validator.routines.UrlValidator;

final class UrlValidationUtil {
    private static final String LETTERS_DIGITS = "[a-zA-Z0-9]";
    private static final String LETTERS_DIGITS_HYPHEN = "[a-zA-Z0-9\\-]";
    private static final String LABEL = "[a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?";
    private static final String OPTIONAL_PORT = "(:(([1-5]\\d{1,4})|([1-9]\\d{1,3})))?";
    private static final String AUTHORITY_REGEX = "[a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?(\\.[a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?)*\\.local\\.?(:(([1-5]\\d{1,4})|([1-9]\\d{1,3})))?";
    private static final String[] SCHEMES = new String[]{"http", "https"};

    private UrlValidationUtil() {
        throw new RuntimeException("Instantiation of " + UrlValidationUtil.class.getName() + " is not allowed.");
    }

    static boolean isValidUrl(String url) {
        return UrlValidationUtil.isValidPublicUrl(url) || UrlValidationUtil.isValidLocalUrl(url);
    }

    private static boolean isValidPublicUrl(String url) {
        UrlValidator validator = UrlValidationUtil.configurePublicUrlValidator();
        return validator.isValid(url);
    }

    private static UrlValidator configurePublicUrlValidator() {
        return new UrlValidator(SCHEMES);
    }

    private static boolean isValidLocalUrl(String url) {
        UrlValidator validator = UrlValidationUtil.configureLocalUrlValidator();
        return validator.isValid(url);
    }

    private static UrlValidator configureLocalUrlValidator() {
        RegexValidator authorityValidator = UrlValidationUtil.configureLocalAuthorityValidator();
        return new UrlValidator(SCHEMES, authorityValidator, 8L);
    }

    static RegexValidator configureLocalAuthorityValidator() {
        return new RegexValidator(AUTHORITY_REGEX, false);
    }
}

