/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import org.apache.maven.surefire.suite.RunResult;

public class TestSetStatistics {
    private int completedCount;
    private int errors;
    private int failures;
    private int skipped;

    public synchronized void incrementCompletedCount() {
        ++this.completedCount;
    }

    public synchronized void incrementErrorsCount() {
        ++this.errors;
    }

    public synchronized void incrementFailureCount() {
        ++this.failures;
    }

    public synchronized void incrementSkippedCount() {
        ++this.skipped;
    }

    public synchronized boolean hadFailures() {
        return this.failures > 0;
    }

    public synchronized void reset() {
        this.completedCount = 0;
        this.errors = 0;
        this.failures = 0;
        this.skipped = 0;
    }

    public synchronized boolean hadErrors() {
        return this.errors > 0;
    }

    public synchronized int getCompletedCount() {
        return this.completedCount;
    }

    public int getSkipped() {
        return this.skipped;
    }

    public synchronized void add(TestSetStatistics testSetStatistics) {
        this.completedCount += testSetStatistics.completedCount;
        this.errors += testSetStatistics.errors;
        this.failures += testSetStatistics.failures;
        this.skipped += testSetStatistics.skipped;
    }

    public synchronized RunResult getRunResult() {
        return new RunResult(this.completedCount, this.errors, this.failures, this.skipped);
    }

    public synchronized String getSummary() {
        return "Tests run: " + this.completedCount + ", Failures: " + this.failures + ", Errors: " + this.errors + ", Skipped: " + this.skipped;
    }
}

