/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.booter.IsolatedClassLoader;
import org.apache.maven.surefire.booter.PropertiesWrapper;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.util.NestedRuntimeException;

public class ClasspathConfiguration {
    private static final String CHILD_DELEGATION = "childDelegation";
    private static final String ENABLE_ASSERTIONS = "enableAssertions";
    private static final String CLASSPATH = "classPathUrl.";
    private static final String SUREFIRE_CLASSPATH = "surefireClassPathUrl.";
    private final Classpath classpathUrls;
    private final Classpath surefireClasspathUrls;
    private final boolean enableAssertions;
    private final boolean childDelegation;
    private static Method assertionStatusMethod;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public ClasspathConfiguration(boolean enableAssertions, boolean childDelegation) {
        this(new Classpath(), new Classpath(), enableAssertions, childDelegation);
    }

    ClasspathConfiguration(PropertiesWrapper properties) {
        this(properties.getClasspath(CLASSPATH), properties.getClasspath(SUREFIRE_CLASSPATH), properties.getBooleanProperty(ENABLE_ASSERTIONS), properties.getBooleanProperty(CHILD_DELEGATION));
    }

    public ClasspathConfiguration(Classpath testClasspath, Classpath surefireClassPathUrls, boolean enableAssertions, boolean childDelegation) {
        this.enableAssertions = enableAssertions;
        this.childDelegation = childDelegation;
        this.classpathUrls = testClasspath;
        this.surefireClasspathUrls = surefireClassPathUrls;
    }

    public void setForkProperties(PropertiesWrapper properties) {
        properties.setClasspath(CLASSPATH, this.classpathUrls);
        properties.setClasspath(SUREFIRE_CLASSPATH, this.surefireClasspathUrls);
        properties.setProperty(ENABLE_ASSERTIONS, String.valueOf(this.enableAssertions));
        properties.setProperty(CHILD_DELEGATION, String.valueOf(this.childDelegation));
    }

    public ClassLoader createTestClassLoaderConditionallySystem(boolean useSystemClassLoader) throws SurefireExecutionException {
        return useSystemClassLoader ? ClassLoader.getSystemClassLoader() : this.createTestClassLoader(this.childDelegation);
    }

    public ClassLoader createTestClassLoader(boolean childDelegation) throws SurefireExecutionException {
        return this.createClassLoaderSEE(this.classpathUrls, null, childDelegation);
    }

    public ClassLoader createTestClassLoader() throws SurefireExecutionException {
        return this.createClassLoaderSEE(this.classpathUrls, null, this.childDelegation);
    }

    public ClassLoader createSurefireClassLoader(ClassLoader parent) throws SurefireExecutionException {
        return this.createClassLoaderSEE(this.surefireClasspathUrls, parent, false);
    }

    private ClassLoader createClassLoaderSEE(Classpath classPathUrls, ClassLoader parent, boolean childDelegation) throws SurefireExecutionException {
        try {
            return this.createClassLoader(classPathUrls, parent, childDelegation);
        }
        catch (MalformedURLException e) {
            throw new SurefireExecutionException("When creating classloader", e);
        }
    }

    private ClassLoader createClassLoader(Classpath classPathUrls, ClassLoader parent, boolean childDelegation) throws MalformedURLException {
        List urls = classPathUrls.getAsUrlList();
        IsolatedClassLoader classLoader = new IsolatedClassLoader(parent, childDelegation);
        if (assertionStatusMethod != null) {
            try {
                Object[] args = new Object[]{this.enableAssertions ? Boolean.TRUE : Boolean.FALSE};
                if (parent != null) {
                    assertionStatusMethod.invoke((Object)parent, args);
                }
                assertionStatusMethod.invoke((Object)classLoader, args);
            }
            catch (IllegalAccessException e) {
                throw new NestedRuntimeException("Unable to access the assertion enablement method", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new NestedRuntimeException("Unable to invoke the assertion enablement method", (Throwable)e);
            }
        }
        Iterator iter = urls.iterator();
        while (iter.hasNext()) {
            URL url = (URL)iter.next();
            classLoader.addURL(url);
        }
        return classLoader;
    }

    public Classpath getTestClasspath() {
        return this.classpathUrls;
    }

    public void addClasspathUrl(String path) {
        this.classpathUrls.addClassPathElementUrl(path);
    }

    public void addSurefireClasspathUrl(String path) {
        this.surefireClasspathUrls.addClassPathElementUrl(path);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            assertionStatusMethod = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ClasspathConfiguration.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getMethod("setDefaultAssertionStatus", Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            assertionStatusMethod = null;
        }
    }
}

