/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.extensions.util;

import java.io.Closeable;
import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class CountdownCloseable
implements Closeable {
    private final Closeable closeable;
    private volatile int countdown;

    public CountdownCloseable(@Nonnull Closeable closeable, @Nonnegative int countdown) {
        this.closeable = closeable;
        this.countdown = countdown;
    }

    @Override
    public synchronized void close() throws IOException {
        if (--this.countdown == 0) {
            try {
                this.closeable.close();
            }
            finally {
                this.notifyAll();
            }
        }
    }

    public synchronized void awaitClosed() throws InterruptedException {
        if (this.countdown > 0) {
            this.wait();
        }
    }
}

