/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng;

import java.util.ResourceBundle;
import org.apache.maven.surefire.report.CategorizedReportEntry;
import org.apache.maven.surefire.report.PojoStackTraceWriter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.Reporter;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;

public class TestNGReporter
implements ITestListener,
ISuiteListener {
    private ResourceBundle bundle = ResourceBundle.getBundle("org.apache.maven.surefire.surefire");
    protected Reporter reporter;

    public TestNGReporter(Reporter reportManager) {
        this.reporter = reportManager;
        if (reportManager == null) {
            throw new IllegalArgumentException("ReportManager passed in was null.");
        }
    }

    public void onTestStart(ITestResult result) {
        String rawString = this.bundle.getString("testStarting");
        String group = TestNGReporter.groupString(result.getMethod().getGroups(), result.getTestClass().getName());
        CategorizedReportEntry report = new CategorizedReportEntry(this.getSource(result), TestNGReporter.getUserFriendlyTestName(result), group, rawString);
        this.reporter.testStarting((ReportEntry)report);
    }

    private String getSource(ITestResult result) {
        return result.getTestClass().getName();
    }

    public void onTestSuccess(ITestResult result) {
        SimpleReportEntry report = new SimpleReportEntry(this.getSource(result), TestNGReporter.getUserFriendlyTestName(result));
        this.reporter.testSucceeded((ReportEntry)report);
    }

    public void onTestFailure(ITestResult result) {
        SimpleReportEntry report = new SimpleReportEntry(this.getSource(result), TestNGReporter.getUserFriendlyTestName(result), (StackTraceWriter)new PojoStackTraceWriter(result.getTestClass().getRealClass().getName(), result.getMethod().getMethodName(), result.getThrowable()));
        this.reporter.testFailed((ReportEntry)report);
    }

    private static String getUserFriendlyTestName(ITestResult result) {
        return result.getName() + "(" + result.getTestClass().getName() + ")";
    }

    public void onTestSkipped(ITestResult result) {
        SimpleReportEntry report = new SimpleReportEntry(this.getSource(result), TestNGReporter.getUserFriendlyTestName(result));
        this.reporter.testSkipped((ReportEntry)report);
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        SimpleReportEntry report = new SimpleReportEntry(this.getSource(result), TestNGReporter.getUserFriendlyTestName(result), (StackTraceWriter)new PojoStackTraceWriter(result.getTestClass().getRealClass().getName(), result.getMethod().getMethodName(), result.getThrowable()));
        this.reporter.testError((ReportEntry)report);
    }

    public void onStart(ITestContext context) {
    }

    public void onFinish(ITestContext context) {
    }

    public void onStart(ISuite suite) {
    }

    public void onFinish(ISuite suite) {
    }

    private static String groupString(String[] groups, String defaultValue) {
        String retVal;
        if (groups != null && groups.length > 0) {
            StringBuffer str = new StringBuffer();
            for (int i = 0; i < groups.length; ++i) {
                str.append(groups[i]);
                if (i + 1 >= groups.length) continue;
                str.append(",");
            }
            retVal = str.toString();
        } else {
            retVal = defaultValue;
        }
        return retVal;
    }

    public void onConfigurationFailure(ITestResult result) {
        this.onTestFailure(result);
    }

    public void onConfigurationSkip(ITestResult result) {
        this.onTestSkipped(result);
    }

    public void onConfigurationSuccess(ITestResult result) {
    }
}

