/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.oauth2.rs.validator;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;
import org.apache.oltu.oauth2.common.validators.AbstractValidator;

public class BearerHeaderOAuthValidator
extends AbstractValidator {
    @Override
    public void validateContentType(HttpServletRequest request) throws OAuthProblemException {
    }

    @Override
    public void validateMethod(HttpServletRequest request) throws OAuthProblemException {
    }

    @Override
    public void validateRequiredParameters(HttpServletRequest request) throws OAuthProblemException {
        String authzHeader = request.getHeader("Authorization");
        if (OAuthUtils.isEmpty(authzHeader)) {
            throw OAuthProblemException.error("", "Missing authorization header.");
        }
        String authzMethod = OAuthUtils.getAuthzMethod(authzHeader);
        if (!"Bearer".equals(authzMethod)) {
            throw OAuthProblemException.error("", "Incorrect authorization method.");
        }
        String headerField = OAuthUtils.getAuthHeaderField(authzHeader);
        if (OAuthUtils.isEmpty(headerField)) {
            throw OAuthProblemException.error("invalid_request", "Missing required parameter.");
        }
        Map<String, String> values = OAuthUtils.decodeOAuthHeader(authzHeader);
        String oauthVersionDiff = values.get("oauth_signature_method");
        if (!OAuthUtils.isEmpty(oauthVersionDiff)) {
            throw OAuthProblemException.error("invalid_request", "Incorrect OAuth version. Found OAuth V1.0.");
        }
    }
}

