/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDAbstractContentStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;

public final class PDPageContentStream
extends PDAbstractContentStream
implements Closeable {
    private static final Log LOG = LogFactory.getLog(PDPageContentStream.class);
    private boolean sourcePageHadContents = false;

    public PDPageContentStream(PDDocument document, PDPage sourcePage) throws IOException {
        this(document, sourcePage, AppendMode.OVERWRITE, true, false);
        if (this.sourcePageHadContents) {
            LOG.warn((Object)"You are overwriting an existing content, you should use the append mode");
        }
    }

    public PDPageContentStream(PDDocument document, PDPage sourcePage, AppendMode appendContent, boolean compress) throws IOException {
        this(document, sourcePage, appendContent, compress, false);
    }

    public PDPageContentStream(PDDocument document, PDPage sourcePage, AppendMode appendContent, boolean compress, boolean resetContext) throws IOException {
        this(document, sourcePage, appendContent, compress, resetContext, new PDStream(document), sourcePage.getResources() != null ? sourcePage.getResources() : new PDResources());
    }

    private PDPageContentStream(PDDocument document, PDPage sourcePage, AppendMode appendContent, boolean compress, boolean resetContext, PDStream stream, PDResources resources) throws IOException {
        super(document, stream.createOutputStream(compress ? COSName.FLATE_DECODE : null), resources);
        if (sourcePage.getResources() == null) {
            sourcePage.setResources(resources);
        }
        if (!appendContent.isOverwrite() && sourcePage.hasContents()) {
            COSArray array;
            COSBase contents = sourcePage.getCOSObject().getDictionaryObject(COSName.CONTENTS);
            if (contents instanceof COSArray) {
                array = (COSArray)contents;
            } else {
                array = new COSArray();
                array.add(contents);
            }
            if (appendContent.isPrepend()) {
                array.add(0, stream.getCOSObject());
            } else {
                array.add(stream);
            }
            if (resetContext) {
                PDStream prefixStream = new PDStream(document);
                try (OutputStream prefixOut = prefixStream.createOutputStream();){
                    prefixOut.write("q".getBytes(StandardCharsets.US_ASCII));
                    prefixOut.write(10);
                }
                array.add(0, prefixStream.getCOSObject());
            }
            sourcePage.getCOSObject().setItem(COSName.CONTENTS, (COSBase)array);
            if (resetContext) {
                this.restoreGraphicsState();
            }
        } else {
            this.sourcePageHadContents = sourcePage.hasContents();
            sourcePage.setContents(stream);
        }
        this.setMaximumFractionDigits(5);
    }

    public PDPageContentStream(PDDocument doc, PDAppearanceStream appearance) throws IOException {
        this(doc, appearance, appearance.getStream().createOutputStream());
    }

    public PDPageContentStream(PDDocument doc, PDAppearanceStream appearance, OutputStream outputStream) {
        super(doc, outputStream, appearance.getResources());
    }

    @Deprecated
    public void appendRawCommands(String commands) throws IOException {
        this.write(commands);
    }

    @Deprecated
    public void appendRawCommands(byte[] commands) throws IOException {
        this.write(commands);
    }

    @Deprecated
    public void appendRawCommands(int data) throws IOException {
        this.writeOperand(data);
    }

    @Deprecated
    public void appendRawCommands(double data) throws IOException {
        this.writeOperand((float)data);
    }

    @Deprecated
    public void appendRawCommands(float data) throws IOException {
        this.writeOperand(data);
    }

    public static enum AppendMode {
        OVERWRITE,
        APPEND,
        PREPEND;


        public boolean isOverwrite() {
            return this == OVERWRITE;
        }

        public boolean isPrepend() {
            return this == PREPEND;
        }
    }
}

