/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.fontencodingpane;

import java.io.IOException;
import java.util.LinkedHashMap;
import javax.swing.JPanel;
import org.apache.pdfbox.debugger.fontencodingpane.FontEncodingView;
import org.apache.pdfbox.debugger.fontencodingpane.FontPane;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDType3Font;

class Type3Font
extends FontPane {
    public static final String NO_GLYPH = "No glyph";
    private final FontEncodingView view;
    private int totalAvailableGlyph = 0;

    Type3Font(PDType3Font font) throws IOException {
        Object[][] tableData = this.getGlyphs(font);
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        attributes.put("Font", font.getName());
        attributes.put("Encoding", this.getEncodingName((PDSimpleFont)font));
        attributes.put("Glyphs", Integer.toString(this.totalAvailableGlyph));
        this.view = new FontEncodingView(tableData, attributes, new String[]{"Code", "Glyph Name", "Unicode Character"}, null);
    }

    private Object[][] getGlyphs(PDType3Font font) throws IOException {
        Object[][] glyphs = new Object[256][3];
        for (int index = 0; index <= 255; ++index) {
            glyphs[index][0] = index;
            if (font.getEncoding().contains(index)) {
                glyphs[index][1] = font.getEncoding().getName(index);
                glyphs[index][2] = font.toUnicode(index);
                ++this.totalAvailableGlyph;
                continue;
            }
            glyphs[index][1] = NO_GLYPH;
            glyphs[index][2] = NO_GLYPH;
        }
        return glyphs;
    }

    private String getEncodingName(PDSimpleFont font) {
        return font.getEncoding().getClass().getSimpleName();
    }

    @Override
    public JPanel getPanel() {
        return this.view.getPanel();
    }
}

