/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageExtBatch;
import org.apache.rocketmq.store.CommitLogDispatcher;
import org.apache.rocketmq.store.ConsumeQueue;
import org.apache.rocketmq.store.GetMessageResult;
import org.apache.rocketmq.store.MessageExtBrokerInner;
import org.apache.rocketmq.store.MessageFilter;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.QueryMessageResult;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.stats.BrokerStatsManager;

public interface MessageStore {
    public boolean load();

    public void start() throws Exception;

    public void shutdown();

    public void destroy();

    public PutMessageResult putMessage(MessageExtBrokerInner var1);

    public PutMessageResult putMessages(MessageExtBatch var1);

    public GetMessageResult getMessage(String var1, String var2, int var3, long var4, int var6, MessageFilter var7);

    public long getMaxOffsetInQueue(String var1, int var2);

    public long getMinOffsetInQueue(String var1, int var2);

    public long getCommitLogOffsetInQueue(String var1, int var2, long var3);

    public long getOffsetInQueueByTime(String var1, int var2, long var3);

    public MessageExt lookMessageByOffset(long var1);

    public SelectMappedBufferResult selectOneMessageByOffset(long var1);

    public SelectMappedBufferResult selectOneMessageByOffset(long var1, int var3);

    public String getRunningDataInfo();

    public HashMap<String, String> getRuntimeInfo();

    public long getMaxPhyOffset();

    public long getMinPhyOffset();

    public long getEarliestMessageTime(String var1, int var2);

    public long getEarliestMessageTime();

    public long getMessageStoreTimeStamp(String var1, int var2, long var3);

    public long getMessageTotalInQueue(String var1, int var2);

    public SelectMappedBufferResult getCommitLogData(long var1);

    public boolean appendToCommitLog(long var1, byte[] var3);

    public void executeDeleteFilesManually();

    public QueryMessageResult queryMessage(String var1, String var2, int var3, long var4, long var6);

    public void updateHaMasterAddress(String var1);

    public long slaveFallBehindMuch();

    public long now();

    public int cleanUnusedTopic(Set<String> var1);

    public void cleanExpiredConsumerQueue();

    public boolean checkInDiskByConsumeOffset(String var1, int var2, long var3);

    public long dispatchBehindBytes();

    public long flush();

    public boolean resetWriteOffset(long var1);

    public long getConfirmOffset();

    public void setConfirmOffset(long var1);

    public boolean isOSPageCacheBusy();

    public long lockTimeMills();

    public boolean isTransientStorePoolDeficient();

    public LinkedList<CommitLogDispatcher> getDispatcherList();

    public ConsumeQueue getConsumeQueue(String var1, int var2);

    public BrokerStatsManager getBrokerStatsManager();

    public void handleScheduleMessageService(BrokerRole var1);
}

