/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.util.data.collect.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.rocketmq.test.util.data.collect.DataCollector;

public class ListDataCollectorImpl
implements DataCollector {
    private List<Object> datas = new ArrayList<Object>();
    private boolean lock = false;

    public ListDataCollectorImpl() {
    }

    public ListDataCollectorImpl(Collection<Object> datas) {
        for (Object data : datas) {
            this.addData(data);
        }
    }

    @Override
    public Collection<Object> getAllData() {
        return this.datas;
    }

    @Override
    public void resetData() {
        this.datas.clear();
        this.unlockIncrement();
    }

    @Override
    public long getDataSizeWithoutDuplicate() {
        return this.getAllDataWithoutDuplicate().size();
    }

    @Override
    public synchronized void addData(Object data) {
        if (this.lock) {
            return;
        }
        this.datas.add(data);
    }

    @Override
    public long getDataSize() {
        return this.datas.size();
    }

    @Override
    public boolean isRepeatedData(Object data) {
        return Collections.frequency(this.datas, data) == 1;
    }

    @Override
    public Collection<Object> getAllDataWithoutDuplicate() {
        return new HashSet<Object>(this.datas);
    }

    @Override
    public int getRepeatedTimeForData(Object data) {
        int res = 0;
        for (Object obj : this.datas) {
            if (!obj.equals(data)) continue;
            ++res;
        }
        return res;
    }

    @Override
    public void removeData(Object data) {
        this.datas.remove(data);
    }

    @Override
    public void lockIncrement() {
        this.lock = true;
    }

    @Override
    public void unlockIncrement() {
        this.lock = false;
    }
}

