/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.message;

import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.MessageClientIDSetter;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.tools.command.SubCommand;

public class DecodeMessageIdCommond
implements SubCommand {
    @Override
    public String commandName() {
        return "DecodeMessageId";
    }

    @Override
    public String commandDesc() {
        return "decode unique message ID";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("i", "messageId", true, "unique message ID");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) {
        String messageId = commandLine.getOptionValue('i').trim();
        try {
            System.out.printf("ip=" + MessageClientIDSetter.getIPStrFromID((String)messageId), new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            String date = UtilAll.formatDate((Date)MessageClientIDSetter.getNearlyTimeFromID((String)messageId), (String)"yyyy-MM-dd#HH:mm:ss:SSS");
            System.out.printf("date=" + date, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

