/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.broker;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.admin.ConsumeStats;
import org.apache.rocketmq.common.admin.OffsetWrapper;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.protocol.body.ConsumeStatsList;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;

public class BrokerConsumeStatsSubCommad
implements SubCommand {
    @Override
    public String commandName() {
        return "brokerConsumeStats";
    }

    @Override
    public String commandDesc() {
        return "Fetch broker consume stats data";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("b", "brokerAddr", true, "Broker address");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("t", "timeoutMillis", true, "request timeout Millis");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("l", "level", true, "threshold of print diff");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("o", "order", true, "order topic");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            defaultMQAdminExt.start();
            String brokerAddr = commandLine.getOptionValue('b').trim();
            boolean isOrder = false;
            long timeoutMillis = 50000L;
            long diffLevel = 0L;
            if (commandLine.hasOption('o')) {
                isOrder = Boolean.parseBoolean(commandLine.getOptionValue('o').trim());
            }
            if (commandLine.hasOption('t')) {
                timeoutMillis = Long.parseLong(commandLine.getOptionValue('t').trim());
            }
            if (commandLine.hasOption('l')) {
                diffLevel = Long.parseLong(commandLine.getOptionValue('l').trim());
            }
            ConsumeStatsList consumeStatsList = defaultMQAdminExt.fetchConsumeStatsInBroker(brokerAddr, isOrder, timeoutMillis);
            System.out.printf("%-32s  %-32s  %-32s  %-4s  %-20s  %-20s  %-20s  %s%n", "#Topic", "#Group", "#Broker Name", "#QID", "#Broker Offset", "#Consumer Offset", "#Diff", "#LastTime");
            for (Map map : consumeStatsList.getConsumeStatsList()) {
                for (Map.Entry entry : map.entrySet()) {
                    String group = (String)entry.getKey();
                    List consumeStatsArray = (List)entry.getValue();
                    for (ConsumeStats consumeStats : consumeStatsArray) {
                        LinkedList mqList = new LinkedList();
                        mqList.addAll(consumeStats.getOffsetTable().keySet());
                        Collections.sort(mqList);
                        for (MessageQueue mq : mqList) {
                            OffsetWrapper offsetWrapper = (OffsetWrapper)consumeStats.getOffsetTable().get(mq);
                            long diff = offsetWrapper.getBrokerOffset() - offsetWrapper.getConsumerOffset();
                            if (diff < diffLevel) continue;
                            String lastTime = "-";
                            try {
                                lastTime = UtilAll.formatDate((Date)new Date(offsetWrapper.getLastTimestamp()), (String)"yyyy-MM-dd HH:mm:ss");
                            }
                            catch (Exception ignored) {
                                // empty catch block
                            }
                            if (offsetWrapper.getLastTimestamp() <= 0L) continue;
                            System.out.printf("%-32s  %-32s  %-32s  %-4d  %-20d  %-20d  %-20d  %s%n", UtilAll.frontStringAtLeast((String)mq.getTopic(), (int)32), group, UtilAll.frontStringAtLeast((String)mq.getBrokerName(), (int)32), mq.getQueueId(), offsetWrapper.getBrokerOffset(), offsetWrapper.getConsumerOffset(), diff, lastTime);
                        }
                    }
                }
            }
            System.out.printf("%nDiff Total: %d%n", consumeStatsList.getTotalDiff());
        }
        catch (Exception e) {
            throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }
}

