/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.stats;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.dozer.stats.StatisticEntry;
import org.dozer.stats.StatisticType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Statistic {
    private final StatisticType type;
    private final ConcurrentMap<Object, StatisticEntry> entriesMap = new ConcurrentHashMap<Object, StatisticEntry>();

    public Statistic(StatisticType type) {
        this.type = type;
    }

    public StatisticType getType() {
        return this.type;
    }

    public StatisticEntry increment(Object statisticEntryKey, long value) {
        StatisticEntry newStatisticEntry;
        if (statisticEntryKey == null) {
            throw new IllegalArgumentException("statistic entry key must be specified");
        }
        StatisticEntry statisticEntry = (StatisticEntry)this.entriesMap.get(statisticEntryKey);
        if (statisticEntry == null && (statisticEntry = this.entriesMap.putIfAbsent(statisticEntryKey, newStatisticEntry = new StatisticEntry(statisticEntryKey))) == null) {
            statisticEntry = newStatisticEntry;
        }
        statisticEntry.increment(value);
        return statisticEntry;
    }

    public void clear() {
        this.entriesMap.clear();
    }

    public Set<StatisticEntry> getEntries() {
        return new HashSet<StatisticEntry>(this.entriesMap.values());
    }

    public StatisticEntry getEntry(Object entryKey) {
        return (StatisticEntry)this.entriesMap.get(entryKey);
    }

    public long getStatisticValue(Object entryKey) {
        StatisticEntry statisticEntry = (StatisticEntry)this.entriesMap.get(entryKey);
        return statisticEntry != null ? statisticEntry.getValue() : 0L;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Statistic)) {
            return false;
        }
        Statistic entry = (Statistic)object;
        return new EqualsBuilder().append((Object)this.getType(), (Object)entry.getType()).isEquals();
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

