/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.infra.handler.threadpool;

import com.google.common.base.Strings;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.infra.exception.JobConfigurationException;
import org.apache.shardingsphere.elasticjob.infra.handler.threadpool.JobExecutorServiceHandler;
import org.apache.shardingsphere.elasticjob.infra.spi.ElasticJobServiceLoader;

public final class JobExecutorServiceHandlerFactory {
    private static final String DEFAULT_HANDLER = "CPU";

    public static JobExecutorServiceHandler getHandler(String type) {
        if (Strings.isNullOrEmpty((String)type)) {
            return ElasticJobServiceLoader.getCachedTypedServiceInstance(JobExecutorServiceHandler.class, DEFAULT_HANDLER).get();
        }
        return ElasticJobServiceLoader.getCachedTypedServiceInstance(JobExecutorServiceHandler.class, type).orElseThrow(() -> new JobConfigurationException("Cannot find executor service handler using type '%s'.", type));
    }

    @Generated
    private JobExecutorServiceHandlerFactory() {
    }

    static {
        ElasticJobServiceLoader.registerTypedService(JobExecutorServiceHandler.class);
    }
}

