/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.infra.pojo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;

public final class JobConfigurationPOJO {
    private String jobName;
    private String cron;
    private int shardingTotalCount;
    private String shardingItemParameters;
    private String jobParameter;
    private boolean monitorExecution;
    private boolean failover;
    private boolean misfire;
    private int maxTimeDiffSeconds = -1;
    private int reconcileIntervalMinutes;
    private String jobShardingStrategyType;
    private String jobExecutorServiceHandlerType;
    private String jobErrorHandlerType;
    private Collection<String> jobListenerTypes = new ArrayList<String>();
    private String description;
    private Properties props = new Properties();
    private boolean disabled;
    private boolean overwrite;

    public JobConfiguration toJobConfiguration() {
        JobConfiguration result = JobConfiguration.newBuilder((String)this.jobName, (int)this.shardingTotalCount).cron(this.cron).shardingItemParameters(this.shardingItemParameters).jobParameter(this.jobParameter).monitorExecution(this.monitorExecution).failover(this.failover).misfire(this.misfire).maxTimeDiffSeconds(this.maxTimeDiffSeconds).reconcileIntervalMinutes(this.reconcileIntervalMinutes).jobShardingStrategyType(this.jobShardingStrategyType).jobExecutorServiceHandlerType(this.jobExecutorServiceHandlerType).jobErrorHandlerType(this.jobErrorHandlerType).jobListenerTypes(this.jobListenerTypes.toArray(new String[0])).description(this.description).disabled(this.disabled).overwrite(this.overwrite).build();
        for (Object each : this.props.keySet()) {
            result.getProps().setProperty(each.toString(), this.props.get(each.toString()).toString());
        }
        return result;
    }

    public static JobConfigurationPOJO fromJobConfiguration(JobConfiguration jobConfiguration) {
        JobConfigurationPOJO result = new JobConfigurationPOJO();
        result.setJobName(jobConfiguration.getJobName());
        result.setCron(jobConfiguration.getCron());
        result.setShardingTotalCount(jobConfiguration.getShardingTotalCount());
        result.setShardingItemParameters(jobConfiguration.getShardingItemParameters());
        result.setJobParameter(jobConfiguration.getJobParameter());
        result.setMonitorExecution(jobConfiguration.isMonitorExecution());
        result.setFailover(jobConfiguration.isFailover());
        result.setMisfire(jobConfiguration.isMisfire());
        result.setMaxTimeDiffSeconds(jobConfiguration.getMaxTimeDiffSeconds());
        result.setReconcileIntervalMinutes(jobConfiguration.getReconcileIntervalMinutes());
        result.setJobShardingStrategyType(jobConfiguration.getJobShardingStrategyType());
        result.setJobExecutorServiceHandlerType(jobConfiguration.getJobExecutorServiceHandlerType());
        result.setJobErrorHandlerType(jobConfiguration.getJobErrorHandlerType());
        result.setJobListenerTypes(jobConfiguration.getJobListenerTypes());
        result.setDescription(jobConfiguration.getDescription());
        result.setProps(jobConfiguration.getProps());
        result.setDisabled(jobConfiguration.isDisabled());
        result.setOverwrite(jobConfiguration.isOverwrite());
        return result;
    }

    @Generated
    public String getJobName() {
        return this.jobName;
    }

    @Generated
    public String getCron() {
        return this.cron;
    }

    @Generated
    public int getShardingTotalCount() {
        return this.shardingTotalCount;
    }

    @Generated
    public String getShardingItemParameters() {
        return this.shardingItemParameters;
    }

    @Generated
    public String getJobParameter() {
        return this.jobParameter;
    }

    @Generated
    public boolean isMonitorExecution() {
        return this.monitorExecution;
    }

    @Generated
    public boolean isFailover() {
        return this.failover;
    }

    @Generated
    public boolean isMisfire() {
        return this.misfire;
    }

    @Generated
    public int getMaxTimeDiffSeconds() {
        return this.maxTimeDiffSeconds;
    }

    @Generated
    public int getReconcileIntervalMinutes() {
        return this.reconcileIntervalMinutes;
    }

    @Generated
    public String getJobShardingStrategyType() {
        return this.jobShardingStrategyType;
    }

    @Generated
    public String getJobExecutorServiceHandlerType() {
        return this.jobExecutorServiceHandlerType;
    }

    @Generated
    public String getJobErrorHandlerType() {
        return this.jobErrorHandlerType;
    }

    @Generated
    public Collection<String> getJobListenerTypes() {
        return this.jobListenerTypes;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public boolean isDisabled() {
        return this.disabled;
    }

    @Generated
    public boolean isOverwrite() {
        return this.overwrite;
    }

    @Generated
    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    @Generated
    public void setCron(String cron) {
        this.cron = cron;
    }

    @Generated
    public void setShardingTotalCount(int shardingTotalCount) {
        this.shardingTotalCount = shardingTotalCount;
    }

    @Generated
    public void setShardingItemParameters(String shardingItemParameters) {
        this.shardingItemParameters = shardingItemParameters;
    }

    @Generated
    public void setJobParameter(String jobParameter) {
        this.jobParameter = jobParameter;
    }

    @Generated
    public void setMonitorExecution(boolean monitorExecution) {
        this.monitorExecution = monitorExecution;
    }

    @Generated
    public void setFailover(boolean failover) {
        this.failover = failover;
    }

    @Generated
    public void setMisfire(boolean misfire) {
        this.misfire = misfire;
    }

    @Generated
    public void setMaxTimeDiffSeconds(int maxTimeDiffSeconds) {
        this.maxTimeDiffSeconds = maxTimeDiffSeconds;
    }

    @Generated
    public void setReconcileIntervalMinutes(int reconcileIntervalMinutes) {
        this.reconcileIntervalMinutes = reconcileIntervalMinutes;
    }

    @Generated
    public void setJobShardingStrategyType(String jobShardingStrategyType) {
        this.jobShardingStrategyType = jobShardingStrategyType;
    }

    @Generated
    public void setJobExecutorServiceHandlerType(String jobExecutorServiceHandlerType) {
        this.jobExecutorServiceHandlerType = jobExecutorServiceHandlerType;
    }

    @Generated
    public void setJobErrorHandlerType(String jobErrorHandlerType) {
        this.jobErrorHandlerType = jobErrorHandlerType;
    }

    @Generated
    public void setJobListenerTypes(Collection<String> jobListenerTypes) {
        this.jobListenerTypes = jobListenerTypes;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }

    @Generated
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Generated
    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }
}

