/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.instance;

import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.elasticjob.infra.handler.sharding.JobInstance;
import org.apache.shardingsphere.elasticjob.lite.internal.instance.InstanceNode;
import org.apache.shardingsphere.elasticjob.lite.internal.instance.InstanceOperation;
import org.apache.shardingsphere.elasticjob.lite.internal.server.ServerService;
import org.apache.shardingsphere.elasticjob.lite.internal.storage.JobNodeStorage;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class InstanceService {
    private final JobNodeStorage jobNodeStorage;
    private final InstanceNode instanceNode;
    private final ServerService serverService;

    public InstanceService(CoordinatorRegistryCenter regCenter, String jobName) {
        this.jobNodeStorage = new JobNodeStorage(regCenter, jobName);
        this.instanceNode = new InstanceNode(jobName);
        this.serverService = new ServerService(regCenter, jobName);
    }

    public void persistOnline() {
        this.jobNodeStorage.fillEphemeralJobNode(this.instanceNode.getLocalInstancePath(), "");
    }

    public void removeInstance() {
        this.jobNodeStorage.removeJobNodeIfExisted(this.instanceNode.getLocalInstancePath());
    }

    void clearTriggerFlag() {
        this.jobNodeStorage.updateJobNode(this.instanceNode.getLocalInstancePath(), "");
    }

    public List<JobInstance> getAvailableJobInstances() {
        LinkedList<JobInstance> result = new LinkedList<JobInstance>();
        for (String each : this.jobNodeStorage.getJobNodeChildrenKeys("instances")) {
            JobInstance jobInstance = new JobInstance(each);
            if (!this.serverService.isEnableServer(jobInstance.getIp())) continue;
            result.add(new JobInstance(each));
        }
        return result;
    }

    boolean isLocalJobInstanceExisted() {
        return this.jobNodeStorage.isJobNodeExisted(this.instanceNode.getLocalInstancePath());
    }

    public void triggerAllInstances() {
        this.jobNodeStorage.getJobNodeChildrenKeys("instances").forEach(each -> this.jobNodeStorage.replaceJobNode(this.instanceNode.getInstancePath((String)each), InstanceOperation.TRIGGER.name()));
    }
}

