/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.setup;

import java.util.Collection;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.infra.listener.ElasticJobListener;
import org.apache.shardingsphere.elasticjob.lite.internal.config.ConfigurationService;
import org.apache.shardingsphere.elasticjob.lite.internal.election.LeaderService;
import org.apache.shardingsphere.elasticjob.lite.internal.instance.InstanceService;
import org.apache.shardingsphere.elasticjob.lite.internal.listener.ListenerManager;
import org.apache.shardingsphere.elasticjob.lite.internal.reconcile.ReconcileService;
import org.apache.shardingsphere.elasticjob.lite.internal.server.ServerService;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class SetUpFacade {
    private final ConfigurationService configService;
    private final LeaderService leaderService;
    private final ServerService serverService;
    private final InstanceService instanceService;
    private final ReconcileService reconcileService;
    private final ListenerManager listenerManager;

    public SetUpFacade(CoordinatorRegistryCenter regCenter, String jobName, Collection<ElasticJobListener> elasticJobListeners) {
        this.configService = new ConfigurationService(regCenter, jobName);
        this.leaderService = new LeaderService(regCenter, jobName);
        this.serverService = new ServerService(regCenter, jobName);
        this.instanceService = new InstanceService(regCenter, jobName);
        this.reconcileService = new ReconcileService(regCenter, jobName);
        this.listenerManager = new ListenerManager(regCenter, jobName, elasticJobListeners);
    }

    public JobConfiguration setUpJobConfiguration(String jobClassName, JobConfiguration jobConfig) {
        return this.configService.setUpJobConfiguration(jobClassName, jobConfig);
    }

    public void registerStartUpInfo(boolean enabled) {
        this.listenerManager.startAllListeners();
        this.leaderService.electLeader();
        this.serverService.persistOnline(enabled);
        this.instanceService.persistOnline();
        if (!this.reconcileService.isRunning()) {
            this.reconcileService.startAsync();
        }
    }
}

