/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.response.ResultContext;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.SolrIndexSearcher;

public class ResponseLogComponent
extends SearchComponent {
    public static final String COMPONENT_NAME = "responseLog";

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false)) {
            return;
        }
        SolrIndexSearcher searcher = rb.req.getSearcher();
        IndexSchema schema = searcher.getSchema();
        if (schema.getUniqueKeyField() == null) {
            return;
        }
        ResultContext rc = (ResultContext)rb.rsp.getValues().get("response");
        if (rc.docs.hasScores()) {
            this.processScores(rb, rc.docs, schema, searcher);
        } else {
            this.processIds(rb, rc.docs, schema, searcher);
        }
    }

    protected void processIds(ResponseBuilder rb, DocList dl, IndexSchema schema, SolrIndexSearcher searcher) throws IOException {
        StringBuilder sb = new StringBuilder();
        Set<String> fields = Collections.singleton(schema.getUniqueKeyField().getName());
        DocIterator iter = dl.iterator();
        while (iter.hasNext()) {
            sb.append(schema.printableUniqueKey(searcher.doc(iter.nextDoc(), fields))).append(',');
        }
        if (sb.length() > 0) {
            rb.rsp.addToLog(COMPONENT_NAME, sb.substring(0, sb.length() - 1));
        }
    }

    protected void processScores(ResponseBuilder rb, DocList dl, IndexSchema schema, SolrIndexSearcher searcher) throws IOException {
        StringBuilder sb = new StringBuilder();
        Set<String> fields = Collections.singleton(schema.getUniqueKeyField().getName());
        DocIterator iter = dl.iterator();
        while (iter.hasNext()) {
            sb.append(schema.printableUniqueKey(searcher.doc(iter.nextDoc(), fields))).append(':').append(iter.score()).append(',');
        }
        if (sb.length() > 0) {
            rb.rsp.addToLog(COMPONENT_NAME, sb.substring(0, sb.length() - 1));
        }
    }

    @Override
    public String getDescription() {
        return "A component that inserts the retrieved documents (and optionally scores) into the response log entry";
    }

    @Override
    public String getSource() {
        return null;
    }
}

