/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.StringHelper;
import org.apache.solr.client.solrj.response.TermsResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.params.TermsParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SimpleFacets;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.StrField;
import org.apache.solr.util.BoundedTreeSet;

public class TermsComponent
extends SearchComponent {
    public static final int UNLIMITED_MAX_COUNT = -1;
    public static final String COMPONENT_NAME = "terms";

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        String shards;
        SolrParams params = rb.req.getParams();
        if (params.getBool(COMPONENT_NAME, false)) {
            rb.doTerms = true;
        }
        if ((shards = params.get("shards")) != null) {
            rb.isDistrib = true;
            if (params.get("shards.qt") == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No shards.qt parameter specified");
            }
            List lst = StrUtils.splitSmart((String)shards, (String)",", (boolean)true);
            rb.shards = lst.toArray(new String[lst.size()]);
        }
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false)) {
            return;
        }
        String[] fields = params.getParams("terms.fl");
        SimpleOrderedMap termsResult = new SimpleOrderedMap();
        rb.rsp.add(COMPONENT_NAME, termsResult);
        if (fields == null || fields.length == 0) {
            return;
        }
        int limit = params.getInt("terms.limit", 10);
        if (limit < 0) {
            limit = Integer.MAX_VALUE;
        }
        String lowerStr = params.get("terms.lower");
        String upperStr = params.get("terms.upper");
        boolean upperIncl = params.getBool("terms.upper.incl", false);
        boolean lowerIncl = params.getBool("terms.lower.incl", true);
        boolean sort = !"index".equals(params.get("terms.sort", "count"));
        int freqmin = params.getInt("terms.mincount", 1);
        int freqmax = params.getInt("terms.maxcount", -1);
        if (freqmax < 0) {
            freqmax = Integer.MAX_VALUE;
        }
        String prefix = params.get("terms.prefix");
        String regexp = params.get("terms.regex");
        Pattern pattern = regexp != null ? Pattern.compile(regexp, this.resolveRegexpFlags(params)) : null;
        boolean raw = params.getBool("terms.raw", false);
        AtomicReader indexReader = rb.req.getSearcher().getAtomicReader();
        Fields lfields = indexReader.fields();
        block0: for (String field : fields) {
            BytesRef lowerBytes;
            FieldType ft;
            Terms terms;
            NamedList fieldTerms = new NamedList();
            termsResult.add(field, (Object)fieldTerms);
            Terms terms2 = terms = lfields == null ? null : lfields.terms(field);
            if (terms == null) continue;
            FieldType fieldType = ft = raw ? null : rb.req.getSchema().getFieldTypeNoEx(field);
            if (ft == null) {
                ft = new StrField();
            }
            BytesRef prefixBytes = prefix == null ? null : new BytesRef((CharSequence)prefix);
            BytesRef upperBytes = null;
            if (upperStr != null) {
                BytesRef b = new BytesRef();
                ft.readableToIndexed(upperStr, b);
                upperBytes = b;
            }
            if (lowerStr == null) {
                lowerBytes = prefixBytes;
            } else {
                lowerBytes = new BytesRef();
                if (raw) {
                    lowerBytes = new BytesRef((CharSequence)lowerStr);
                } else {
                    BytesRef b = new BytesRef();
                    ft.readableToIndexed(lowerStr, b);
                    lowerBytes = b;
                }
            }
            TermsEnum termsEnum = terms.iterator(null);
            BytesRef term = null;
            if (lowerBytes != null) {
                if (termsEnum.seekCeil(lowerBytes) == TermsEnum.SeekStatus.END) {
                    termsEnum = null;
                } else {
                    term = termsEnum.term();
                    if (!lowerIncl && term.equals((Object)lowerBytes)) {
                        term = termsEnum.next();
                    }
                }
            } else {
                term = termsEnum.next();
            }
            int i = 0;
            BoundedTreeSet<SimpleFacets.CountPair<BytesRef, Integer>> queue = sort ? new BoundedTreeSet<SimpleFacets.CountPair<BytesRef, Integer>>(limit) : null;
            CharsRef external = new CharsRef();
            while (term != null && (i < limit || sort)) {
                int n;
                boolean externalized = false;
                if (prefixBytes != null && !StringHelper.startsWith((BytesRef)term, (BytesRef)prefixBytes)) break;
                if (pattern != null) {
                    ft.indexedToReadable(term, external);
                    externalized = true;
                    if (!pattern.matcher((CharSequence)external).matches()) {
                        term = termsEnum.next();
                        continue;
                    }
                }
                if (upperBytes != null && ((n = term.compareTo(upperBytes)) > 0 || n == 0 && !upperIncl)) break;
                n = termsEnum.docFreq();
                if (n >= freqmin && n <= freqmax) {
                    if (sort) {
                        queue.add(new SimpleFacets.CountPair<BytesRef, Integer>(BytesRef.deepCopyOf((BytesRef)term), n));
                    } else {
                        if (!externalized) {
                            ft.indexedToReadable(term, external);
                        }
                        fieldTerms.add(external.toString(), (Object)n);
                        ++i;
                    }
                }
                term = termsEnum.next();
            }
            if (!sort) continue;
            for (SimpleFacets.CountPair countPair : queue) {
                if (i >= limit) continue block0;
                ft.indexedToReadable((BytesRef)countPair.key, external);
                fieldTerms.add(external.toString(), countPair.val);
                ++i;
            }
        }
    }

    int resolveRegexpFlags(SolrParams params) {
        String[] flagParams = params.getParams("terms.regex.flag");
        if (flagParams == null) {
            return 0;
        }
        int flags = 0;
        for (String flagParam : flagParams) {
            try {
                flags |= TermsParams.TermsRegexpFlag.valueOf((String)flagParam.toUpperCase(Locale.ROOT)).getValue();
            }
            catch (IllegalArgumentException iae) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown terms regex flag '" + flagParam + "'");
            }
        }
        return flags;
    }

    @Override
    public int distributedProcess(ResponseBuilder rb) throws IOException {
        if (!rb.doTerms) {
            return ResponseBuilder.STAGE_DONE;
        }
        if (rb.stage == ResponseBuilder.STAGE_EXECUTE_QUERY) {
            TermsHelper th = rb._termsHelper;
            if (th == null) {
                th = rb._termsHelper = new TermsHelper();
                th.init(rb.req.getParams());
            }
            ShardRequest sreq = this.createShardQuery(rb.req.getParams());
            rb.addRequest(this, sreq);
        }
        if (rb.stage < ResponseBuilder.STAGE_EXECUTE_QUERY) {
            return ResponseBuilder.STAGE_EXECUTE_QUERY;
        }
        return ResponseBuilder.STAGE_DONE;
    }

    @Override
    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
        if (!rb.doTerms || (sreq.purpose & 0x400) == 0) {
            return;
        }
        TermsHelper th = rb._termsHelper;
        if (th != null) {
            for (ShardResponse srsp : sreq.responses) {
                NamedList terms = (NamedList)srsp.getSolrResponse().getResponse().get(COMPONENT_NAME);
                th.parse((NamedList<NamedList<Number>>)terms);
            }
        }
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        if (!rb.doTerms || rb.stage != ResponseBuilder.STAGE_EXECUTE_QUERY) {
            return;
        }
        TermsHelper ti = rb._termsHelper;
        NamedList terms = ti.buildResponse();
        rb.rsp.add(COMPONENT_NAME, terms);
        rb._termsHelper = null;
    }

    private ShardRequest createShardQuery(SolrParams params) {
        ShardRequest sreq = new ShardRequest();
        sreq.purpose = 1024;
        sreq.params = new ModifiableSolrParams(params);
        sreq.params.remove("terms.maxcount");
        sreq.params.remove("terms.mincount");
        sreq.params.set("terms.limit", -1);
        sreq.params.set("terms.sort", new String[]{"index"});
        return sreq;
    }

    @Override
    public String getSource() {
        return null;
    }

    @Override
    public String getDescription() {
        return "A Component for working with Term Enumerators";
    }

    public class TermsHelper {
        private HashMap<String, HashMap<String, TermsResponse.Term>> fieldmap = new HashMap(5);
        private SolrParams params;

        public void init(SolrParams params) {
            this.params = params;
            String[] fields = params.getParams("terms.fl");
            if (fields != null) {
                for (String field : fields) {
                    this.fieldmap.put(field, new HashMap(128));
                }
            }
        }

        public void parse(NamedList<NamedList<Number>> terms) {
            if (terms == null) {
                return;
            }
            TermsResponse termsResponse = new TermsResponse(terms);
            for (String key : this.fieldmap.keySet()) {
                HashMap<String, TermsResponse.Term> termmap = this.fieldmap.get(key);
                List termlist = termsResponse.getTerms(key);
                if (termlist == null) continue;
                for (TermsResponse.Term tc : termlist) {
                    String term = tc.getTerm();
                    if (termmap.containsKey(term)) {
                        TermsResponse.Term oldtc = termmap.get(term);
                        oldtc.addFrequency(tc.getFrequency());
                        termmap.put(term, oldtc);
                        continue;
                    }
                    termmap.put(term, tc);
                }
            }
        }

        public NamedList buildResponse() {
            SimpleOrderedMap response = new SimpleOrderedMap();
            boolean sort = !"index".equals(this.params.get("terms.sort", "count"));
            long freqmin = 1L;
            String s = this.params.get("terms.mincount");
            if (s != null) {
                freqmin = Long.parseLong(s);
            }
            long freqmax = -1L;
            s = this.params.get("terms.maxcount");
            if (s != null) {
                freqmax = Long.parseLong(s);
            }
            if (freqmax < 0L) {
                freqmax = Long.MAX_VALUE;
            }
            long limit = 10L;
            s = this.params.get("terms.limit");
            if (s != null) {
                limit = Long.parseLong(s);
            }
            if (limit < 0L) {
                limit = Long.MAX_VALUE;
            }
            for (String key : this.fieldmap.keySet()) {
                SimpleOrderedMap fieldterms = new SimpleOrderedMap();
                TermsResponse.Term[] data = null;
                data = sort ? this.getCountSorted(this.fieldmap.get(key)) : this.getLexSorted(this.fieldmap.get(key));
                int cnt = 0;
                for (TermsResponse.Term tc : data) {
                    if (tc.getFrequency() >= freqmin && tc.getFrequency() <= freqmax) {
                        fieldterms.add(tc.getTerm(), (Object)this.num(tc.getFrequency()));
                        ++cnt;
                    }
                    if ((long)cnt >= limit) break;
                }
                response.add(key, (Object)fieldterms);
            }
            return response;
        }

        private Number num(long val) {
            if (val < Integer.MAX_VALUE) {
                return (int)val;
            }
            return val;
        }

        public TermsResponse.Term[] getLexSorted(HashMap<String, TermsResponse.Term> data) {
            TermsResponse.Term[] arr = data.values().toArray(new TermsResponse.Term[data.size()]);
            Arrays.sort(arr, new Comparator<TermsResponse.Term>(){

                @Override
                public int compare(TermsResponse.Term o1, TermsResponse.Term o2) {
                    return o1.getTerm().compareTo(o2.getTerm());
                }
            });
            return arr;
        }

        public TermsResponse.Term[] getCountSorted(HashMap<String, TermsResponse.Term> data) {
            TermsResponse.Term[] arr = data.values().toArray(new TermsResponse.Term[data.size()]);
            Arrays.sort(arr, new Comparator<TermsResponse.Term>(){

                @Override
                public int compare(TermsResponse.Term o1, TermsResponse.Term o2) {
                    long freq1 = o1.getFrequency();
                    long freq2 = o2.getFrequency();
                    if (freq2 < freq1) {
                        return -1;
                    }
                    if (freq1 < freq2) {
                        return 1;
                    }
                    return o1.getTerm().compareTo(o2.getTerm());
                }
            });
            return arr;
        }
    }
}

