/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics;

import com.codahale.metrics.MetricRegistry;
import org.apache.solr.core.SolrInfoBean;

public final class SolrMetricInfo {
    public final String name;
    public final String scope;
    public final SolrInfoBean.Category category;

    public SolrMetricInfo(SolrInfoBean.Category category, String scope, String name) {
        this.name = name;
        this.scope = scope;
        this.category = category;
    }

    public static SolrMetricInfo of(String fullName) {
        String name;
        String scope;
        SolrInfoBean.Category category;
        if (fullName == null || fullName.isEmpty()) {
            return null;
        }
        String[] names = fullName.split("\\.");
        if (names.length < 2) {
            return null;
        }
        try {
            category = SolrInfoBean.Category.valueOf(names[0]);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        if (names.length == 2) {
            scope = null;
            name = fullName.substring(names[0].length() + 1);
        } else {
            scope = names[1];
            name = fullName.substring(names[0].length() + names[1].length() + 2);
        }
        return new SolrMetricInfo(category, scope, name);
    }

    public String getMetricName() {
        return MetricRegistry.name((String)this.category.toString(), (String[])new String[]{this.scope, this.name});
    }

    public String toString() {
        return "SolrMetricInfo{name='" + this.name + '\'' + ", scope='" + this.scope + '\'' + ", category=" + (Object)((Object)this.category) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SolrMetricInfo that = (SolrMetricInfo)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) {
            return false;
        }
        return this.category == that.category;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
        result = 31 * result + (this.category != null ? this.category.hashCode() : 0);
        return result;
    }
}

