/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import com.codahale.metrics.Meter;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.LongAdder;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SlowCodecReaderWrapper;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.FunctionRangeQuery;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryUtils;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.function.ValueSourceRangeFilter;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitTracker;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteByQueryWrapper;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.SolrCoreState;
import org.apache.solr.update.SolrIndexSplitter;
import org.apache.solr.update.SolrIndexWriter;
import org.apache.solr.update.SplitIndexCommand;
import org.apache.solr.update.UpdateCommand;
import org.apache.solr.update.UpdateHandler;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.TestInjection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectUpdateHandler2
extends UpdateHandler
implements SolrCoreState.IndexWriterCloser,
SolrMetricProducer {
    private static final int NO_FILE_SIZE_UPPER_BOUND_PLACEHOLDER = -1;
    protected final SolrCoreState solrCoreState;
    LongAdder addCommands = new LongAdder();
    Meter addCommandsCumulative;
    LongAdder deleteByIdCommands = new LongAdder();
    Meter deleteByIdCommandsCumulative;
    LongAdder deleteByQueryCommands = new LongAdder();
    Meter deleteByQueryCommandsCumulative;
    Meter expungeDeleteCommands;
    Meter mergeIndexesCommands;
    Meter commitCommands;
    Meter splitCommands;
    Meter optimizeCommands;
    Meter rollbackCommands;
    LongAdder numDocsPending = new LongAdder();
    LongAdder numErrors = new LongAdder();
    Meter numErrorsCumulative;
    SolrMetricsContext solrMetricsContext;
    protected final CommitTracker commitTracker;
    protected final CommitTracker softCommitTracker;
    protected boolean commitWithinSoftCommit;
    protected boolean indexWriterCloseWaitsForMerges;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static volatile boolean commitOnClose = true;

    void setCommitWithinSoftCommit(boolean value) {
        this.commitWithinSoftCommit = value;
    }

    public DirectUpdateHandler2(SolrCore core) {
        super(core);
        this.solrCoreState = core.getSolrCoreState();
        SolrConfig.UpdateHandlerInfo updateHandlerInfo = core.getSolrConfig().getUpdateHandlerInfo();
        int docsUpperBound = updateHandlerInfo.autoCommmitMaxDocs;
        int timeUpperBound = updateHandlerInfo.autoCommmitMaxTime;
        long fileSizeUpperBound = updateHandlerInfo.autoCommitMaxSizeBytes;
        this.commitTracker = new CommitTracker("Hard", core, docsUpperBound, timeUpperBound, fileSizeUpperBound, updateHandlerInfo.openSearcher, false);
        int softCommitDocsUpperBound = updateHandlerInfo.autoSoftCommmitMaxDocs;
        int softCommitTimeUpperBound = updateHandlerInfo.autoSoftCommmitMaxTime;
        this.softCommitTracker = new CommitTracker("Soft", core, softCommitDocsUpperBound, softCommitTimeUpperBound, -1L, true, true);
        this.commitWithinSoftCommit = updateHandlerInfo.commitWithinSoftCommit;
        this.indexWriterCloseWaitsForMerges = updateHandlerInfo.indexWriterCloseWaitsForMerges;
        ZkController zkController = core.getCoreContainer().getZkController();
        if (zkController != null && core.getCoreDescriptor().getCloudDescriptor().getReplicaType() == Replica.Type.TLOG) {
            this.commitWithinSoftCommit = false;
            this.commitTracker.setOpenSearcher(true);
        }
    }

    public DirectUpdateHandler2(SolrCore core, UpdateHandler updateHandler) {
        super(core, updateHandler.getUpdateLog());
        this.solrCoreState = core.getSolrCoreState();
        SolrConfig.UpdateHandlerInfo updateHandlerInfo = core.getSolrConfig().getUpdateHandlerInfo();
        int docsUpperBound = updateHandlerInfo.autoCommmitMaxDocs;
        int timeUpperBound = updateHandlerInfo.autoCommmitMaxTime;
        long fileSizeUpperBound = updateHandlerInfo.autoCommitMaxSizeBytes;
        this.commitTracker = new CommitTracker("Hard", core, docsUpperBound, timeUpperBound, fileSizeUpperBound, updateHandlerInfo.openSearcher, false);
        int softCommitDocsUpperBound = updateHandlerInfo.autoSoftCommmitMaxDocs;
        int softCommitTimeUpperBound = updateHandlerInfo.autoSoftCommmitMaxTime;
        this.softCommitTracker = new CommitTracker("Soft", core, softCommitDocsUpperBound, softCommitTimeUpperBound, -1L, updateHandlerInfo.openSearcher, true);
        this.commitWithinSoftCommit = updateHandlerInfo.commitWithinSoftCommit;
        this.indexWriterCloseWaitsForMerges = updateHandlerInfo.indexWriterCloseWaitsForMerges;
        UpdateLog existingLog = updateHandler.getUpdateLog();
        if (this.ulog != null && this.ulog == existingLog) {
            this.ulog.init(this, core);
        }
    }

    @Override
    public SolrMetricsContext getSolrMetricsContext() {
        return this.solrMetricsContext;
    }

    @Override
    public void initializeMetrics(SolrMetricsContext parentContext, String scope) {
        this.solrMetricsContext = parentContext.getChildContext(this);
        this.commitCommands = this.solrMetricsContext.meter(this, "commits", this.getCategory().toString(), scope);
        this.solrMetricsContext.gauge(this, () -> this.commitTracker.getCommitCount(), true, "autoCommits", this.getCategory().toString(), scope);
        this.solrMetricsContext.gauge(this, () -> this.softCommitTracker.getCommitCount(), true, "softAutoCommits", this.getCategory().toString(), scope);
        if (this.commitTracker.getDocsUpperBound() > 0) {
            this.solrMetricsContext.gauge(this, () -> this.commitTracker.getDocsUpperBound(), true, "autoCommitMaxDocs", this.getCategory().toString(), scope);
        }
        if (this.commitTracker.getTimeUpperBound() > 0L) {
            this.solrMetricsContext.gauge(this, () -> "" + this.commitTracker.getTimeUpperBound() + "ms", true, "autoCommitMaxTime", this.getCategory().toString(), scope);
        }
        if (this.commitTracker.getTLogFileSizeUpperBound() > 0L) {
            this.solrMetricsContext.gauge(this, () -> this.commitTracker.getTLogFileSizeUpperBound(), true, "autoCommitMaxSize", this.getCategory().toString(), scope);
        }
        if (this.softCommitTracker.getDocsUpperBound() > 0) {
            this.solrMetricsContext.gauge(this, () -> this.softCommitTracker.getDocsUpperBound(), true, "softAutoCommitMaxDocs", this.getCategory().toString(), scope);
        }
        if (this.softCommitTracker.getTimeUpperBound() > 0L) {
            this.solrMetricsContext.gauge(this, () -> "" + this.softCommitTracker.getTimeUpperBound() + "ms", true, "softAutoCommitMaxTime", this.getCategory().toString(), scope);
        }
        this.optimizeCommands = this.solrMetricsContext.meter(this, "optimizes", this.getCategory().toString(), scope);
        this.rollbackCommands = this.solrMetricsContext.meter(this, "rollbacks", this.getCategory().toString(), scope);
        this.splitCommands = this.solrMetricsContext.meter(this, "splits", this.getCategory().toString(), scope);
        this.mergeIndexesCommands = this.solrMetricsContext.meter(this, "merges", this.getCategory().toString(), scope);
        this.expungeDeleteCommands = this.solrMetricsContext.meter(this, "expungeDeletes", this.getCategory().toString(), scope);
        this.solrMetricsContext.gauge(this, () -> this.numDocsPending.longValue(), true, "docsPending", this.getCategory().toString(), scope);
        this.solrMetricsContext.gauge(this, () -> this.addCommands.longValue(), true, "adds", this.getCategory().toString(), scope);
        this.solrMetricsContext.gauge(this, () -> this.deleteByIdCommands.longValue(), true, "deletesById", this.getCategory().toString(), scope);
        this.solrMetricsContext.gauge(this, () -> this.deleteByQueryCommands.longValue(), true, "deletesByQuery", this.getCategory().toString(), scope);
        this.solrMetricsContext.gauge(this, () -> this.numErrors.longValue(), true, "errors", this.getCategory().toString(), scope);
        this.addCommandsCumulative = this.solrMetricsContext.meter(this, "cumulativeAdds", this.getCategory().toString(), scope);
        this.deleteByIdCommandsCumulative = this.solrMetricsContext.meter(this, "cumulativeDeletesById", this.getCategory().toString(), scope);
        this.deleteByQueryCommandsCumulative = this.solrMetricsContext.meter(this, "cumulativeDeletesByQuery", this.getCategory().toString(), scope);
        this.numErrorsCumulative = this.solrMetricsContext.meter(this, "cumulativeErrors", this.getCategory().toString(), scope);
    }

    private void deleteAll() throws IOException {
        log.info(this.core.getLogId() + "REMOVING ALL DOCUMENTS FROM INDEX");
        RefCounted<IndexWriter> iw = this.solrCoreState.getIndexWriter(this.core);
        try {
            iw.get().deleteAll();
        }
        finally {
            iw.decref();
        }
    }

    protected void rollbackWriter() throws IOException {
        this.numDocsPending.reset();
        this.solrCoreState.rollbackIndexWriter(this.core);
    }

    @Override
    public int addDoc(AddUpdateCommand cmd) throws IOException {
        TestInjection.injectDirectUpdateLatch();
        try {
            return this.addDoc0(cmd);
        }
        catch (SolrException e) {
            throw e;
        }
        catch (AlreadyClosedException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, String.format(Locale.ROOT, "Server error writing document id %s to the index", cmd.getPrintableId()), (Throwable)e);
        }
        catch (IllegalArgumentException iae) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Exception writing document id %s to the index; possible analysis error: " + iae.getMessage() + (iae.getCause() instanceof BytesRefHash.MaxBytesLengthExceededException ? ". Perhaps the document has an indexed string field (solr.StrField) which is too large" : ""), cmd.getPrintableId()), (Throwable)iae);
        }
        catch (RuntimeException t) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Exception writing document id %s to the index; possible analysis error.", cmd.getPrintableId()), (Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addDoc0(AddUpdateCommand cmd) throws IOException {
        int rc = -1;
        this.addCommands.increment();
        this.addCommandsCumulative.mark();
        if (this.idField == null) {
            cmd.overwrite = false;
        }
        try {
            if ((cmd.getFlags() & UpdateCommand.IGNORE_INDEXWRITER) != 0) {
                if (this.ulog != null) {
                    this.ulog.add(cmd);
                }
                int n = 1;
                return n;
            }
            if (cmd.overwrite) {
                List<UpdateLog.DBQ> deletesAfter = null;
                if (this.ulog != null && cmd.version > 0L) {
                    deletesAfter = this.ulog.getDBQNewer(cmd.version);
                }
                if (deletesAfter != null) {
                    this.addAndDelete(cmd, deletesAfter);
                } else {
                    this.doNormalUpdate(cmd);
                }
            } else {
                this.allowDuplicateUpdate(cmd);
            }
            if ((cmd.getFlags() & UpdateCommand.IGNORE_AUTOCOMMIT) == 0) {
                long currentTlogSize = this.getCurrentTLogSize();
                if (this.commitWithinSoftCommit) {
                    this.commitTracker.addedDocument(-1, currentTlogSize);
                    this.softCommitTracker.addedDocument(cmd.commitWithin);
                } else {
                    this.softCommitTracker.addedDocument(-1);
                    this.commitTracker.addedDocument(cmd.commitWithin, currentTlogSize);
                }
            }
            rc = 1;
        }
        finally {
            if (rc != 1) {
                this.numErrors.increment();
                this.numErrorsCumulative.mark();
            } else {
                this.numDocsPending.increment();
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allowDuplicateUpdate(AddUpdateCommand cmd) throws IOException {
        RefCounted<IndexWriter> iw = this.solrCoreState.getIndexWriter(this.core);
        try {
            IndexWriter writer = iw.get();
            Iterable<Document> nestedDocs = cmd.getLuceneDocsIfNested();
            if (nestedDocs != null) {
                writer.addDocuments(nestedDocs);
            } else {
                writer.addDocument((Iterable)cmd.getLuceneDocument());
            }
            if (this.ulog != null) {
                this.ulog.add(cmd);
            }
        }
        finally {
            iw.decref();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNormalUpdate(AddUpdateCommand cmd) throws IOException {
        RefCounted<IndexWriter> iw = this.solrCoreState.getIndexWriter(this.core);
        try {
            IndexWriter writer = iw.get();
            this.updateDocOrDocValues(cmd, writer);
            if (this.ulog != null) {
                this.ulog.add(cmd);
            }
        }
        finally {
            iw.decref();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAndDelete(AddUpdateCommand cmd, List<UpdateLog.DBQ> deletesAfter) throws IOException {
        log.info("Reordered DBQs detected.  Update=" + cmd + " DBQs=" + deletesAfter);
        ArrayList<Query> dbqList = new ArrayList<Query>(deletesAfter.size());
        for (UpdateLog.DBQ dbq : deletesAfter) {
            try {
                DeleteUpdateCommand tmpDel = new DeleteUpdateCommand(cmd.req);
                tmpDel.query = dbq.q;
                tmpDel.version = -dbq.version;
                dbqList.add(this.getQuery(tmpDel));
            }
            catch (Exception e) {
                log.error("Exception parsing reordered query : " + dbq, (Throwable)e);
            }
        }
        RefCounted<IndexWriter> iw = this.solrCoreState.getIndexWriter(this.core);
        try {
            IndexWriter writer = iw.get();
            Object object = this.solrCoreState.getUpdateLock();
            synchronized (object) {
                this.updateDocOrDocValues(cmd, writer);
                if (cmd.isInPlaceUpdate() && this.ulog != null) {
                    this.ulog.openRealtimeSearcher();
                }
                for (Query q : dbqList) {
                    writer.deleteDocuments(new Query[]{new DeleteByQueryWrapper(q, this.core.getLatestSchema())});
                }
                if (this.ulog != null) {
                    this.ulog.add(cmd, true);
                }
            }
        }
        finally {
            iw.decref();
        }
    }

    private void updateDeleteTrackers(DeleteUpdateCommand cmd) {
        if ((cmd.getFlags() & UpdateCommand.IGNORE_AUTOCOMMIT) == 0) {
            if (this.commitWithinSoftCommit) {
                this.softCommitTracker.deletedDocument(cmd.commitWithin);
            } else {
                this.commitTracker.deletedDocument(cmd.commitWithin);
            }
            if (this.commitTracker.getTimeUpperBound() > 0L) {
                this.commitTracker.scheduleCommitWithin(this.commitTracker.getTimeUpperBound());
            }
            long currentTlogSize = this.getCurrentTLogSize();
            this.commitTracker.scheduleMaxSizeTriggeredCommitIfNeeded(currentTlogSize);
            if (this.softCommitTracker.getTimeUpperBound() > 0L) {
                this.softCommitTracker.scheduleCommitWithin(this.softCommitTracker.getTimeUpperBound());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(DeleteUpdateCommand cmd) throws IOException {
        TestInjection.injectDirectUpdateLatch();
        this.deleteByIdCommands.increment();
        this.deleteByIdCommandsCumulative.mark();
        if ((cmd.getFlags() & UpdateCommand.IGNORE_INDEXWRITER) != 0) {
            if (this.ulog != null) {
                this.ulog.delete(cmd);
            }
            return;
        }
        Term deleteTerm = this.getIdTerm(cmd.getIndexedId(), false);
        RefCounted<IndexWriter> iw = this.solrCoreState.getIndexWriter(this.core);
        try {
            iw.get().deleteDocuments(new Term[]{deleteTerm});
        }
        finally {
            iw.decref();
        }
        if (this.ulog != null) {
            this.ulog.delete(cmd);
        }
        this.updateDeleteTrackers(cmd);
    }

    public void clearIndex() throws IOException {
        this.deleteAll();
        if (this.ulog != null) {
            this.ulog.deleteAll();
        }
    }

    private Query getQuery(DeleteUpdateCommand cmd) {
        try {
            QParser parser = QParser.getParser(cmd.getQuery(), cmd.req);
            Query q = parser.getQuery();
            q = QueryUtils.makeQueryable(q);
            if (this.ulog != null && cmd.getVersion() != 0L && cmd.getVersion() != -9223372036854775807L) {
                BooleanQuery.Builder bq = new BooleanQuery.Builder();
                bq.add(q, BooleanClause.Occur.MUST);
                SchemaField sf = this.ulog.getVersionInfo().getVersionField();
                ValueSource vs = sf.getType().getValueSource(sf, null);
                ValueSourceRangeFilter filt = new ValueSourceRangeFilter(vs, Long.toString(Math.abs(cmd.getVersion())), null, true, true);
                FunctionRangeQuery range = new FunctionRangeQuery(filt);
                bq.add((Query)range, BooleanClause.Occur.MUST_NOT);
                q = bq.build();
            }
            return q;
        }
        catch (SyntaxError e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteByQuery(DeleteUpdateCommand cmd) throws IOException {
        boolean delAll;
        TestInjection.injectDirectUpdateLatch();
        this.deleteByQueryCommands.increment();
        this.deleteByQueryCommandsCumulative.mark();
        boolean madeIt = false;
        if ((cmd.getFlags() & UpdateCommand.IGNORE_INDEXWRITER) != 0) {
            if (this.ulog != null) {
                this.ulog.deleteByQuery(cmd);
            }
            madeIt = true;
            return;
        }
        Query q = this.getQuery(cmd);
        boolean bl = delAll = MatchAllDocsQuery.class == q.getClass();
        if (delAll && cmd.getVersion() == -9223372036854775807L) {
            Object object = this.solrCoreState.getUpdateLock();
            synchronized (object) {
                this.deleteAll();
                this.ulog.deleteAll();
                return;
            }
        }
        Object object = this.solrCoreState.getUpdateLock();
        synchronized (object) {
            if (this.ulog != null) {
                this.ulog.openRealtimeSearcher();
            }
            if (delAll) {
                this.deleteAll();
            } else {
                RefCounted<IndexWriter> iw = this.solrCoreState.getIndexWriter(this.core);
                try {
                    iw.get().deleteDocuments(new Query[]{new DeleteByQueryWrapper(q, this.core.getLatestSchema())});
                }
                finally {
                    iw.decref();
                }
            }
            if (this.ulog != null) {
                this.ulog.deleteByQuery(cmd);
            }
        }
        finally {
            if (!madeIt) {
                this.numErrors.increment();
                this.numErrorsCumulative.mark();
            }
        }
        madeIt = true;
        this.updateDeleteTrackers(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int mergeIndexes(MergeIndexesCommand cmd) throws IOException {
        int rc;
        TestInjection.injectDirectUpdateLatch();
        this.mergeIndexesCommands.mark();
        log.info("start " + cmd);
        List<DirectoryReader> readers = cmd.readers;
        if (readers != null && readers.size() > 0) {
            ArrayList<CodecReader> mergeReaders = new ArrayList<CodecReader>();
            for (DirectoryReader reader : readers) {
                for (LeafReaderContext leaf : reader.leaves()) {
                    mergeReaders.add(SlowCodecReaderWrapper.wrap((LeafReader)leaf.reader()));
                }
            }
            RefCounted<IndexWriter> iw = this.solrCoreState.getIndexWriter(this.core);
            try {
                iw.get().addIndexes(mergeReaders.toArray(new CodecReader[mergeReaders.size()]));
            }
            finally {
                iw.decref();
            }
            rc = 1;
        } else {
            rc = 0;
        }
        log.info("end_mergeIndexes");
        if (rc == 1 && this.commitTracker.getTimeUpperBound() > 0L) {
            this.commitTracker.scheduleCommitWithin(this.commitTracker.getTimeUpperBound());
        } else if (rc == 1 && this.softCommitTracker.getTimeUpperBound() > 0L) {
            this.softCommitTracker.scheduleCommitWithin(this.softCommitTracker.getTimeUpperBound());
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareCommit(CommitUpdateCommand cmd) throws IOException {
        boolean error = true;
        try {
            log.info("start " + cmd);
            RefCounted<IndexWriter> iw = this.solrCoreState.getIndexWriter(this.core);
            try {
                SolrIndexWriter.setCommitData(iw.get(), cmd.getVersion());
                iw.get().prepareCommit();
            }
            finally {
                iw.decref();
            }
            log.info("end_prepareCommit");
            error = false;
        }
        finally {
            if (error) {
                this.numErrors.increment();
                this.numErrorsCumulative.mark();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(CommitUpdateCommand cmd) throws IOException {
        TestInjection.injectDirectUpdateLatch();
        if (cmd.prepareCommit) {
            this.prepareCommit(cmd);
            return;
        }
        if (cmd.optimize) {
            this.optimizeCommands.mark();
        } else {
            this.commitCommands.mark();
            if (cmd.expungeDeletes) {
                this.expungeDeleteCommands.mark();
            }
        }
        Future[] waitSearcher = null;
        if (cmd.waitSearcher) {
            waitSearcher = new Future[1];
        }
        boolean error = true;
        try {
            Object object;
            block46: {
                if (!cmd.softCommit) {
                    this.solrCoreState.getCommitLock().lock();
                }
                log.info("start " + cmd);
                if (cmd.openSearcher) {
                    this.softCommitTracker.cancelPendingCommit();
                }
                if (!(cmd.softCommit || !cmd.openSearcher && this.commitTracker.getOpenSearcher())) {
                    this.commitTracker.cancelPendingCommit();
                }
                RefCounted<IndexWriter> iw = this.solrCoreState.getIndexWriter(this.core);
                try {
                    IndexWriter writer = iw.get();
                    if (cmd.optimize) {
                        writer.forceMerge(cmd.maxOptimizeSegments);
                    } else if (cmd.expungeDeletes) {
                        writer.forceMergeDeletes();
                    }
                    if (cmd.softCommit) break block46;
                    Object object2 = this.solrCoreState.getUpdateLock();
                    synchronized (object2) {
                        if (this.ulog != null) {
                            this.ulog.preCommit(cmd);
                        }
                    }
                    if (writer.hasUncommittedChanges()) {
                        SolrIndexWriter.setCommitData(writer, cmd.getVersion());
                        writer.commit();
                    } else {
                        log.info("No uncommitted changes. Skipping IW.commit.");
                    }
                    this.numDocsPending.reset();
                    this.callPostCommitCallbacks();
                }
                finally {
                    iw.decref();
                }
            }
            if (cmd.optimize) {
                this.callPostOptimizeCallbacks();
            }
            if (cmd.softCommit) {
                object = this.solrCoreState.getUpdateLock();
                synchronized (object) {
                    if (this.ulog != null) {
                        this.ulog.preSoftCommit(cmd);
                    }
                    this.core.getSearcher(true, false, waitSearcher, true);
                    if (this.ulog != null) {
                        this.ulog.postSoftCommit(cmd);
                    }
                }
                this.callPostSoftCommitCallbacks();
            } else {
                object = this.solrCoreState.getUpdateLock();
                synchronized (object) {
                    if (this.ulog != null) {
                        this.ulog.preSoftCommit(cmd);
                    }
                    if (cmd.openSearcher) {
                        this.core.getSearcher(true, false, waitSearcher);
                    } else {
                        RefCounted<SolrIndexSearcher> searchHolder = this.core.openNewSearcher(true, true);
                        searchHolder.decref();
                    }
                    if (this.ulog != null) {
                        this.ulog.postSoftCommit(cmd);
                    }
                }
                if (this.ulog != null) {
                    this.ulog.postCommit(cmd);
                }
            }
            if (cmd.softCommit) {
                this.softCommitTracker.didCommit();
            } else {
                this.commitTracker.didCommit();
            }
            log.info("end_commit_flush");
            error = false;
        }
        finally {
            if (!cmd.softCommit) {
                this.solrCoreState.getCommitLock().unlock();
            }
            this.addCommands.reset();
            this.deleteByIdCommands.reset();
            this.deleteByQueryCommands.reset();
            if (error) {
                this.numErrors.increment();
                this.numErrorsCumulative.mark();
            }
        }
        if (waitSearcher != null && waitSearcher[0] != null) {
            try {
                waitSearcher[0].get();
            }
            catch (InterruptedException | ExecutionException e) {
                SolrException.log((Logger)log, (Throwable)e);
            }
        }
    }

    @Override
    public void newIndexWriter(boolean rollback) throws IOException {
        this.solrCoreState.newIndexWriter(this.core, rollback);
    }

    @Override
    public void rollback(RollbackUpdateCommand cmd) throws IOException {
        TestInjection.injectDirectUpdateLatch();
        if (this.core.getCoreContainer().isZooKeeperAware()) {
            throw new UnsupportedOperationException("Rollback is currently not supported in SolrCloud mode. (SOLR-4895)");
        }
        this.rollbackCommands.mark();
        boolean error = true;
        try {
            log.info("start " + cmd);
            this.rollbackWriter();
            this.commitTracker.didRollback();
            this.softCommitTracker.didRollback();
            log.info("end_rollback");
            error = false;
        }
        finally {
            this.addCommandsCumulative.mark(-this.addCommands.sumThenReset());
            this.deleteByIdCommandsCumulative.mark(-this.deleteByIdCommands.sumThenReset());
            this.deleteByQueryCommandsCumulative.mark(-this.deleteByQueryCommands.sumThenReset());
            if (error) {
                this.numErrors.increment();
                this.numErrorsCumulative.mark();
            }
        }
    }

    @Override
    public UpdateLog getUpdateLog() {
        return this.ulog;
    }

    @Override
    public void close() throws IOException {
        log.debug("closing " + this);
        this.commitTracker.close();
        this.softCommitTracker.close();
        this.numDocsPending.reset();
        try {
            SolrMetricProducer.super.close();
        }
        catch (Exception e) {
            throw new IOException("Error closing", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeWriter(IndexWriter writer) throws IOException {
        block27: {
            block26: {
                assert (TestInjection.injectNonGracefullClose(this.core.getCoreContainer()));
                boolean clearRequestInfo = false;
                LocalSolrQueryRequest req = new LocalSolrQueryRequest(this.core, (SolrParams)new ModifiableSolrParams());
                SolrQueryResponse rsp = new SolrQueryResponse();
                if (SolrRequestInfo.getRequestInfo() == null) {
                    clearRequestInfo = true;
                    SolrRequestInfo.setRequestInfo(new SolrRequestInfo(req, rsp));
                }
                try {
                    if (!commitOnClose) {
                        if (writer != null) {
                            writer.rollback();
                        }
                        if (this.ulog != null) {
                            this.ulog.close(false);
                        }
                        return;
                    }
                    boolean tryToCommit = writer != null && this.ulog != null && this.ulog.hasUncommittedChanges() && this.ulog.getState() == UpdateLog.State.ACTIVE;
                    this.solrCoreState.getCommitLock().lock();
                    try {
                        try {
                            if (!tryToCommit) break block26;
                            log.info("Committing on IndexWriter close.");
                            CommitUpdateCommand cmd = new CommitUpdateCommand(req, false);
                            cmd.openSearcher = false;
                            cmd.waitSearcher = false;
                            cmd.softCommit = false;
                            Object object = this.solrCoreState.getUpdateLock();
                            synchronized (object) {
                                this.ulog.preCommit(cmd);
                            }
                            SolrIndexWriter.setCommitData(writer, cmd.getVersion());
                            writer.commit();
                            object = this.solrCoreState.getUpdateLock();
                            synchronized (object) {
                                this.ulog.postCommit(cmd);
                            }
                        }
                        catch (Throwable th) {
                            log.error("Error in final commit", th);
                            if (th instanceof OutOfMemoryError) {
                                throw (OutOfMemoryError)th;
                            }
                        }
                    }
                    finally {
                        this.solrCoreState.getCommitLock().unlock();
                    }
                }
                finally {
                    if (clearRequestInfo) {
                        SolrRequestInfo.clearRequestInfo();
                    }
                }
            }
            try {
                if (this.ulog != null) {
                    this.ulog.close(false);
                }
            }
            catch (Throwable th) {
                log.error("Error closing log files", th);
                if (!(th instanceof OutOfMemoryError)) break block27;
                throw (OutOfMemoryError)th;
            }
        }
        if (writer != null) {
            writer.close();
        }
    }

    @Override
    public void split(SplitIndexCommand cmd) throws IOException {
        this.commit(new CommitUpdateCommand(cmd.req, false));
        SolrIndexSplitter splitter = new SolrIndexSplitter(cmd);
        this.splitCommands.mark();
        NamedList results = new NamedList();
        try {
            splitter.split((NamedList<Object>)results);
            cmd.rsp.addResponse(results);
        }
        catch (IOException e) {
            this.numErrors.increment();
            this.numErrorsCumulative.mark();
            throw e;
        }
    }

    private void updateDocOrDocValues(AddUpdateCommand cmd, IndexWriter writer) throws IOException {
        boolean hasUpdateTerm;
        assert (this.idField != null);
        boolean bl = hasUpdateTerm = cmd.updateTerm != null;
        if (cmd.isInPlaceUpdate()) {
            if (hasUpdateTerm) {
                throw new IllegalStateException("cmd.updateTerm/dedupe is not compatible with in-place updates");
            }
            Term updateTerm = new Term(this.idField.getName(), cmd.getIndexedId());
            Document luceneDocument = cmd.getLuceneDocument();
            List origDocFields = luceneDocument.getFields();
            ArrayList<Field> fieldsToUpdate = new ArrayList<Field>(origDocFields.size());
            for (IndexableField field : origDocFields) {
                if (field.name().equals(updateTerm.field())) continue;
                fieldsToUpdate.add((Field)field);
            }
            log.debug("updateDocValues({})", (Object)cmd);
            writer.updateDocValues(updateTerm, fieldsToUpdate.toArray(new Field[fieldsToUpdate.size()]));
        } else {
            Term updateTerm;
            Iterable<Document> nestedDocs = cmd.getLuceneDocsIfNested();
            boolean isNested = nestedDocs != null;
            Term idTerm = this.getIdTerm(isNested ? new BytesRef((CharSequence)cmd.getRootIdUsingRouteParam()) : cmd.getIndexedId(), isNested);
            Term term = updateTerm = hasUpdateTerm ? cmd.updateTerm : idTerm;
            if (isNested) {
                log.debug("updateDocuments({})", (Object)cmd);
                writer.updateDocuments(updateTerm, nestedDocs);
            } else {
                Document luceneDocument = cmd.getLuceneDocument();
                log.debug("updateDocument({})", (Object)cmd);
                writer.updateDocument(updateTerm, (Iterable)luceneDocument);
            }
            if (hasUpdateTerm) {
                BooleanQuery.Builder bq = new BooleanQuery.Builder();
                bq.add((Query)new TermQuery(updateTerm), BooleanClause.Occur.MUST_NOT);
                bq.add((Query)new TermQuery(idTerm), BooleanClause.Occur.MUST);
                writer.deleteDocuments(new Query[]{new DeleteByQueryWrapper((Query)bq.build(), this.core.getLatestSchema())});
            }
        }
    }

    private Term getIdTerm(BytesRef termVal, boolean isNested) {
        boolean useRootId = isNested || this.core.getLatestSchema().isUsableForChildDocs();
        return new Term(useRootId ? "_root_" : this.idField.getName(), termVal);
    }

    @Override
    public String getName() {
        return DirectUpdateHandler2.class.getName();
    }

    @Override
    public String getDescription() {
        return "Update handler that efficiently directly updates the on-disk main lucene index";
    }

    @Override
    public SolrCoreState getSolrCoreState() {
        return this.solrCoreState;
    }

    private long getCurrentTLogSize() {
        return this.ulog != null && this.ulog.hasUncommittedChanges() ? this.ulog.getCurrentLogSizeFromStream() : -1L;
    }

    public CommitTracker getCommitTracker() {
        return this.commitTracker;
    }

    public CommitTracker getSoftCommitTracker() {
        return this.softCommitTracker;
    }
}

